/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;

public class MoveDownCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Activity activity;
    private Collection modifiedResources;
    private int elementLocation = 0;
    private int transferLocation = 0;
    private Object elementObj;
    private Collection eClasses;
    private boolean adjacent = false;

    public MoveDownCommand(Activity activity, Object object, Collection collection) {
        this.activity = activity;
        this.elementObj = object;
        this.eClasses = collection;
        this.modifiedResources = new HashSet();
        if (activity.eResource() != null) {
            this.modifiedResources.add(activity.eResource());
        }
    }

    public void execute() {
        Object object;
        List list = this.activity.getBreakdownElements();
        int n = 0;
        while (n < list.size()) {
            object = list.get(n);
            if (object.equals(this.elementObj)) {
                this.elementLocation = n;
                break;
            }
            ++n;
        }
        n = this.elementLocation + 1;
        while (n <= list.size()) {
            object = list.get(n);
            if (TngUtil.isEClassInstanceOf(this.eClasses, object)) {
                this.transferLocation = n;
                break;
            }
            ++n;
        }
        BreakdownElement breakdownElement = (BreakdownElement)list.get(this.transferLocation);
        object = (BreakdownElement)this.elementObj;
        if (object.getPresentedAfter() == breakdownElement) {
            this.adjacent = true;
        }
        this.redo();
    }

    public void redo() {
        if (this.adjacent) {
            BreakdownElement breakdownElement = (BreakdownElement)this.activity.getBreakdownElements().get(this.transferLocation);
            BreakdownElement breakdownElement2 = (BreakdownElement)this.elementObj;
            breakdownElement2.setPresentedAfter(breakdownElement.getPresentedAfter());
            breakdownElement.setPresentedAfter(breakdownElement2);
        }
        ((EList)this.activity.getBreakdownElements()).move(this.transferLocation, this.elementLocation);
    }

    public void undo() {
        ((EList)this.activity.getBreakdownElements()).move(this.elementLocation, this.transferLocation);
        if (this.adjacent) {
            BreakdownElement breakdownElement = (BreakdownElement)this.activity.getBreakdownElements().get(this.transferLocation);
            BreakdownElement breakdownElement2 = (BreakdownElement)this.elementObj;
            breakdownElement.setPresentedAfter(breakdownElement2.getPresentedAfter());
            breakdownElement2.setPresentedAfter(breakdownElement);
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }
}

