/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityDeepCopyCommand;
import org.eclipse.epf.library.edit.process.command.CopyHelper;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.epf.uma.util.UmaUtil;

public class ActivityHandler {
    private ArrayList procPackages;
    private ArrayList<Object> activitiesToDeepCopy;
    private MethodConfiguration deepCopyConfig;
    private List deepCopies;
    private Map deepCopyToOriginalMap;
    private ArrayList activities = new ArrayList();
    private Map copyToOriginal;
    private AdapterFactoryEditingDomain editingDomain;
    private CopyCommand.Helper copyHelper;
    private CopyHelper deepCopyHelper;
    private Process targetProcess;
    private IProgressMonitor monitor;

    public ActivityHandler() {
        this.activitiesToDeepCopy = new ArrayList();
        this.deepCopies = new ArrayList();
        this.deepCopyToOriginalMap = new HashMap();
        this.copyToOriginal = new HashMap();
        this.procPackages = new ArrayList();
        this.copyHelper = new CopyCommand.Helper();
    }

    public void dispose() {
        this.activities.clear();
        this.activitiesToDeepCopy.clear();
        this.copyToOriginal.clear();
        this.procPackages.clear();
        this.copyHelper.clear();
        this.deepCopies.clear();
        if (this.deepCopyHelper != null) {
            this.deepCopyHelper.clear();
        }
        this.deepCopyToOriginalMap.clear();
    }

    public void copy(Activity activity) {
        this.procPackages.add(activity.eContainer());
    }

    public MethodConfiguration getDeepCopyConfig() {
        return this.deepCopyConfig;
    }

    public void setDeepCopyConfig(MethodConfiguration methodConfiguration) {
        this.deepCopyConfig = methodConfiguration;
    }

    public Process getTargetProcess() {
        return this.targetProcess;
    }

    public void setTargetProcess(Process process) {
        this.targetProcess = process;
    }

    public void setMonitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
    }

    public List getDeepCopies() {
        return this.deepCopies;
    }

    public void deepCopy(Object object) {
        Object object2 = TngUtil.unwrap(object);
        if (object2 instanceof Activity && ((Activity)object2).eContainer() != null) {
            this.activitiesToDeepCopy.add(object);
        }
    }

    public void extend(Activity activity) {
        Activity activity2 = ProcessUtil.generalize(activity, VariabilityType.EXTENDS_LITERAL);
        this.activities.add(activity2);
    }

    public List getActivities() {
        if (!this.procPackages.isEmpty() || !this.activitiesToDeepCopy.isEmpty()) {
            this.editingDomain = new TraceableAdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
            if (!this.procPackages.isEmpty()) {
                this.activities.addAll(this.copy(this.procPackages));
            }
            if (!this.activitiesToDeepCopy.isEmpty()) {
                if (this.monitor == null) {
                    this.monitor = new NullProgressMonitor();
                }
                for (Object object : this.activitiesToDeepCopy) {
                    ActivityDeepCopyCommand activityDeepCopyCommand = new ActivityDeepCopyCommand(object, this.getDeepCopyHelper(), this.deepCopyConfig, this.targetProcess, this.monitor);
                    try {
                        Collection<?> collection;
                        long l = 0L;
                        if (TngUtil.DEBUG) {
                            l = System.currentTimeMillis();
                        }
                        activityDeepCopyCommand.execute();
                        if (TngUtil.DEBUG) {
                            System.out.println("ActivityDeepCopyCommand executed: " + (System.currentTimeMillis() - l) + " ms");
                            l = System.currentTimeMillis();
                        }
                        if ((collection = activityDeepCopyCommand.getResult()).isEmpty()) continue;
                        Activity activity = (Activity)collection.iterator().next();
                        ProcessUtil.fixBreakdonwElementOrderRecursively(activity);
                        if (TngUtil.DEBUG) {
                            System.out.println("ProcessUtil.fixBreakdonwElementOrderRecursively(): " + (System.currentTimeMillis() - l) + " ms");
                            l = System.currentTimeMillis();
                        }
                        activityDeepCopyCommand.copySuppressionStates();
                        if (TngUtil.DEBUG) {
                            System.out.println("ActivityDeepCopyCommand.copySuppressionStates(): " + (System.currentTimeMillis() - l) + " ms");
                            l = System.currentTimeMillis();
                        }
                        this.deepCopies.add(activity);
                        this.deepCopyToOriginalMap.put(activity, object);
                    }
                    finally {
                        activityDeepCopyCommand.dispose();
                    }
                }
                this.activities.addAll(this.deepCopies);
            }
        }
        return this.activities;
    }

    private void updatePredecessors(List list) {
        Object object;
        IBSItemProvider iBSItemProvider;
        ArrayList<PredecessorList> arrayList = new ArrayList<PredecessorList>();
        Object v = this.copyToOriginal.get(list.get(0));
        AdapterFactory adapterFactory = this.editingDomain.getAdapterFactory();
        IBSItemProvider iBSItemProvider2 = (IBSItemProvider)adapterFactory.adapt(v, ITreeItemContentProvider.class);
        int n = iBSItemProvider2.getId();
        arrayList.add(iBSItemProvider2.getPredecessors());
        IBSItemProvider iBSItemProvider3 = null;
        AdapterFactoryTreeIterator adapterFactoryTreeIterator = new AdapterFactoryTreeIterator(adapterFactory, v, false);
        while (adapterFactoryTreeIterator.hasNext()) {
            Object e = adapterFactoryTreeIterator.next();
            Object object2 = TngUtil.unwrap(e);
            if (!(object2 instanceof WorkBreakdownElement)) continue;
            iBSItemProvider = null;
            if (e instanceof IBSItemProvider) {
                iBSItemProvider = (IBSItemProvider)e;
                arrayList.add(iBSItemProvider.getPredecessors());
            } else {
                object = adapterFactory.adapt(e, ITreeItemContentProvider.class);
                if (object instanceof IBSItemProvider) {
                    iBSItemProvider = (IBSItemProvider)object;
                    arrayList.add(iBSItemProvider.getPredecessors());
                }
            }
            if (iBSItemProvider == null) continue;
            iBSItemProvider3 = iBSItemProvider;
        }
        int n2 = iBSItemProvider3 != null ? iBSItemProvider3.getId() : n;
        int n3 = list.size();
        Assert.isTrue((n3 == arrayList.size() ? 1 : 0) != 0);
        int n4 = 0;
        while (n4 < n3) {
            iBSItemProvider = (WorkBreakdownElement)list.get(n4);
            iBSItemProvider.getLinkToPredecessor().clear();
            object = (PredecessorList)arrayList.get(n4);
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                iBSItemProvider2 = (IBSItemProvider)iterator.next();
                int n5 = iBSItemProvider2.getId();
                if (n5 < n || n5 > n2) continue;
                WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)list.get(n5 - n);
                iBSItemProvider.getLinkToPredecessor().add(UmaUtil.createDefaultWorkOrder((WorkBreakdownElement)iBSItemProvider, (WorkBreakdownElement)workBreakdownElement));
            }
            ++n4;
        }
    }

    private Collection copyProcessPackages(Collection collection) {
        Command command = this.createCopyCommand((EditingDomain)this.editingDomain, collection);
        if (command != null) {
            try {
                command.execute();
                Collection collection2 = command.getResult();
                return collection2;
            }
            finally {
                command.dispose();
            }
        }
        return Collections.EMPTY_LIST;
    }

    private Command createCopyCommand(EditingDomain editingDomain, Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand compoundCommand = new CompoundCommand(Integer.MAX_VALUE);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            compoundCommand.append(editingDomain.createCommand(CopyCommand.class, new CommandParameter(iterator.next(), null, (Object)this.copyHelper)));
        }
        return compoundCommand.unwrap();
    }

    private List copy(List list) {
        Collection collection = this.copyProcessPackages(list);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ProcessPackage processPackage : collection) {
            if (processPackage instanceof ProcessComponent) {
                Process process = ((ProcessComponent)processPackage).getProcess();
                ProcessPackage processPackage2 = UmaFactory.eINSTANCE.createProcessPackage();
                processPackage2.setName(process.getName());
                processPackage2.getProcessElements().add(process);
                processPackage2.getProcessElements().addAll(processPackage.getProcessElements());
                processPackage2.getDiagrams().addAll(processPackage.getDiagrams());
                processPackage2.getChildPackages().addAll(processPackage.getChildPackages());
                arrayList.add(process);
                continue;
            }
            arrayList.add(ProcessUtil.findActivity(processPackage));
        }
        return arrayList;
    }

    public Map getDeepCopyToOriginalMap() {
        return this.deepCopyToOriginalMap;
    }

    public CopyCommand.Helper getCopyHelper() {
        return this.copyHelper;
    }

    public CopyHelper getDeepCopyHelper() {
        if (this.deepCopyHelper == null) {
            this.deepCopyHelper = new CopyHelper();
        }
        return this.deepCopyHelper;
    }
}

