/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.ComposedBreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.RemoveUnusedDescriptorsCommand;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ConstraintManager;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;

public class Suppression {
    public static final String WBS = "wbs";
    public static final String TBS = "tbs";
    public static final String WPBS = "wpbs";
    public static final String CBS = "cbs";
    private static final Map procToSuppressionMap = new HashMap();
    private static boolean autoInheritIntermediateSuppressionState = true;
    protected Process process;
    private Set suppressedExternalElementPaths;
    private boolean modified;
    private Set internalUnsuppressedElements = new HashSet();

    public static final void clearCachedSuppressions() {
        procToSuppressionMap.clear();
    }

    public static final void cleanUp() {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        for (Process process : new ArrayList(procToSuppressionMap.keySet())) {
            if (!process.eIsProxy()) continue;
            arrayList.add(process);
        }
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            procToSuppressionMap.remove(arrayList.get(n2));
            ++n2;
        }
    }

    public static final void setAutoInheritSuppressionStates(boolean bl) {
        autoInheritIntermediateSuppressionState = bl;
    }

    public Suppression(Process process) {
        this.process = process;
        this.suppressedExternalElementPaths = this.loadSuppressedElementPaths();
    }

    public Process getProcess() {
        return this.process;
    }

    private Set loadSuppressedElementPaths() {
        Constraint constraint = ConstraintManager.getConstraint((MethodElement)this.process, "", false);
        if (constraint != null && constraint.getBody().length() > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(constraint.getBody());
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
            return hashSet;
        }
        return null;
    }

    private Set getSuppressedExternalElementPaths() {
        if (this.suppressedExternalElementPaths == null) {
            this.suppressedExternalElementPaths = this.loadSuppressedElementPaths();
            if (this.suppressedExternalElementPaths == null) {
                this.suppressedExternalElementPaths = new HashSet();
            }
        }
        return this.suppressedExternalElementPaths;
    }

    public boolean hasSuppressed(Collection collection) {
        for (Object e : collection) {
            if (!(e instanceof BreakdownElementWrapperItemProvider ? this.isSuppressed((BreakdownElementWrapperItemProvider)e) : e instanceof BreakdownElement && this.isSuppressed((BreakdownElement)e))) continue;
            return true;
        }
        return false;
    }

    public boolean canSuppress(Collection collection) {
        return this.canDo(collection, true);
    }

    public boolean canReveal(Collection collection) {
        return this.canDo(collection, false);
    }

    private Collection getApplicableItems(Collection collection, boolean bl) {
        ArrayList arrayList = new ArrayList();
        for (Object e : collection) {
            if (e instanceof BreakdownElementWrapperItemProvider) {
                BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)e;
                if (breakdownElementWrapperItemProvider.isReadOnly()) {
                    if (this.isInSuppressedList(breakdownElementWrapperItemProvider) == bl) continue;
                    arrayList.add(e);
                    continue;
                }
                Object object = TngUtil.unwrap(breakdownElementWrapperItemProvider);
                if (!(object instanceof MethodElement) || ((MethodElement)object).getSuppressed() == bl) continue;
                arrayList.add(e);
                continue;
            }
            if (!(e instanceof MethodElement) || ((MethodElement)e).getSuppressed() == bl) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static boolean isValid(Object object) {
        BreakdownElement breakdownElement = null;
        if (object instanceof BreakdownElementWrapperItemProvider) {
            BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)object;
            if (breakdownElementWrapperItemProvider.isRollupChild()) {
                return false;
            }
            breakdownElement = (BreakdownElement)TngUtil.unwrap(breakdownElementWrapperItemProvider);
        } else if (object instanceof BreakdownElement) {
            breakdownElement = (BreakdownElement)object;
        }
        return !(breakdownElement instanceof RoleDescriptor) && !(breakdownElement instanceof WorkProductDescriptor) || breakdownElement.getSuperActivities() != null && breakdownElement.getSuperActivities() != null;
    }

    private boolean canDo(Collection collection, boolean bl) {
        for (Object e : collection) {
            Object object;
            BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider;
            if (!Suppression.isValid(e) || !(e instanceof BreakdownElementWrapperItemProvider ? ((breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)e).isReadOnly() ? this.isInSuppressedList(breakdownElementWrapperItemProvider) != bl : (object = TngUtil.unwrap(breakdownElementWrapperItemProvider)) instanceof MethodElement && ((MethodElement)object).getSuppressed() != bl) : e instanceof MethodElement && ((MethodElement)e).getSuppressed() != bl)) continue;
            return true;
        }
        return false;
    }

    private boolean __isSuppressed(BreakdownElement breakdownElement) {
        return Suppression.getSuppressed(breakdownElement, true, null) != null;
    }

    private static boolean isDirectlySuppressed(MethodElement methodElement) {
        VariabilityElement variabilityElement;
        VariabilityType variabilityType;
        Boolean bl = methodElement.getSuppressed();
        if (bl != null && bl.booleanValue()) {
            return true;
        }
        if (methodElement instanceof VariabilityElement && ((variabilityType = (variabilityElement = (VariabilityElement)methodElement).getVariabilityType()) == VariabilityType.EXTENDS_LITERAL || variabilityType == VariabilityType.CONTRIBUTES_LITERAL) && variabilityElement.getVariabilityBasedOnElement() != null) {
            return Suppression.isDirectlySuppressed((MethodElement)variabilityElement.getVariabilityBasedOnElement());
        }
        return false;
    }

    private static BreakdownElement getSuppressed(BreakdownElement breakdownElement, boolean bl, Object object) {
        if (breakdownElement.getSuppressed().booleanValue()) {
            return breakdownElement;
        }
        if (bl) {
            Object object2 = breakdownElement;
            while (object2 != object && object2.getSuperActivities() != null) {
                if (!(object2 = object2.getSuperActivities()).getSuppressed().booleanValue()) continue;
                return object2;
            }
            if (breakdownElement instanceof WorkProductDescriptor) {
                Object object3;
                object2 = (WorkProductDescriptor)breakdownElement;
                WorkProduct workProduct = object2.getWorkProduct();
                if (workProduct instanceof Artifact && (object3 = UmaUtil.getParentActivity((BreakdownElement)breakdownElement)) != null) {
                    for (Object e : object3.getBreakdownElements()) {
                        WorkProductDescriptor workProductDescriptor;
                        WorkProduct workProduct2;
                        if (e == breakdownElement || !(e instanceof WorkProductDescriptor) || !((workProduct2 = (workProductDescriptor = (WorkProductDescriptor)e).getWorkProduct()) instanceof Artifact) || !UmaUtil.isContainedBy((EObject)workProduct, (Object)workProduct2) || !workProductDescriptor.getSuppressed().booleanValue()) continue;
                        return workProductDescriptor;
                    }
                }
                if (object2 != object && object2.getSuperActivities() == null && (object3 = AssociationHelper.getDeliverableDescriptors((WorkProductDescriptor)object2)).size() == 1) {
                    return Suppression.getSuppressed((BreakdownElement)object3.get(0), bl, object);
                }
            } else if (breakdownElement instanceof RoleDescriptor) {
                TeamProfile teamProfile;
                if (breakdownElement.getSuperActivities() == null && (object2 = AssociationHelper.getTeamProfiles((RoleDescriptor)((RoleDescriptor)breakdownElement))).size() == 1 && (teamProfile = (TeamProfile)object2.get(0)) != object && teamProfile != null) {
                    return Suppression.getSuppressed((BreakdownElement)teamProfile, bl, object);
                }
            } else if (breakdownElement instanceof TeamProfile && breakdownElement.getSuperActivities() == null && (object2 = ((TeamProfile)breakdownElement).getSuperTeam()) != object && object2 != null) {
                return Suppression.getSuppressed((BreakdownElement)object2, bl, object);
            }
        }
        return null;
    }

    public boolean isInSuppressedList(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        if (this.suppressedExternalElementPaths == null) {
            return false;
        }
        String string = Suppression.getPath(breakdownElementWrapperItemProvider);
        return this.suppressedExternalElementPaths.contains(string);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        return this.getSuppressed(breakdownElementWrapperItemProvider, true);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider, boolean bl) {
        return this.getSuppressed(breakdownElementWrapperItemProvider, bl, true, autoInheritIntermediateSuppressionState);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider, boolean bl, boolean bl2, boolean bl3) {
        return this.getSuppressed(breakdownElementWrapperItemProvider, bl, bl2, bl3, true, null);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider, boolean bl, boolean bl2, boolean bl3, boolean bl4, Object object) {
        Process process;
        Object object2;
        BreakdownElement breakdownElement = (BreakdownElement)TngUtil.unwrap(breakdownElementWrapperItemProvider);
        if (!breakdownElementWrapperItemProvider.isReadOnly()) {
            return Suppression.getSuppressed(breakdownElement, bl4, object);
        }
        if (bl && (object2 = Suppression.getSuppressed(breakdownElement, bl4, object)) != null) {
            return object2;
        }
        object2 = null;
        if (bl2) {
            if (this.isInSuppressedList(breakdownElementWrapperItemProvider)) {
                return breakdownElement;
            }
            if (bl4 && (object2 = breakdownElementWrapperItemProvider.getParent(breakdownElementWrapperItemProvider)) instanceof BreakdownElement && object2 != object && (process = Suppression.getSuppressed(object2, bl4, object)) != null) {
                return process;
            }
        }
        if (bl3) {
            Process process2;
            process = TngUtil.getOwningProcess(breakdownElement);
            Activity activity = ProcessUtil.getInheritor(breakdownElementWrapperItemProvider);
            BreakdownElement breakdownElement2 = (BreakdownElement)activity.getVariabilityBasedOnElement();
            if (breakdownElement2 != null && process != (process2 = TngUtil.getOwningProcess(breakdownElement2))) {
                Object object3;
                Object object4 = activity.getVariabilityBasedOnElement();
                ArrayList<BreakdownElement> arrayList = new ArrayList<BreakdownElement>(ProcessUtil.getParentList(activity, breakdownElementWrapperItemProvider));
                arrayList.add(breakdownElement);
                Object object5 = arrayList.iterator();
                block0: while (object5.hasNext()) {
                    object3 = object5.next();
                    ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)breakdownElementWrapperItemProvider.getAdapterFactory().adapt(object4, ITreeItemContentProvider.class);
                    for (Object e : iTreeItemContentProvider.getChildren(object4)) {
                        if (object3 != TngUtil.unwrap(e)) continue;
                        object4 = e;
                        continue block0;
                    }
                }
                if (object4 instanceof BreakdownElementWrapperItemProvider && (object3 = super.getSuppressed((BreakdownElementWrapperItemProvider)object4, false, true, bl3, bl4, TngUtil.unwrap(object4))) != null) {
                    return object3;
                }
            }
        }
        if (bl4) {
            if (object2 == null) {
                object2 = breakdownElementWrapperItemProvider.getParent(breakdownElementWrapperItemProvider);
            }
            if (object2 instanceof BreakdownElementWrapperItemProvider && TngUtil.unwrap(object2) != object) {
                return this.getSuppressed((BreakdownElementWrapperItemProvider)object2, bl, true, bl3, bl4, object);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Suppression getSuppression(Process process) {
        Suppression suppression = (Suppression)procToSuppressionMap.get(process);
        if (suppression == null) {
            Map map = procToSuppressionMap;
            synchronized (map) {
                suppression = (Suppression)procToSuppressionMap.get(process);
                if (suppression == null) {
                    suppression = new Suppression(process);
                    procToSuppressionMap.put(process, suppression);
                }
            }
        }
        return suppression;
    }

    public static synchronized void setSuppression(Suppression suppression) {
        procToSuppressionMap.put(suppression.getProcess(), suppression);
    }

    private boolean __isSuppressed(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        return this.getSuppressed(breakdownElementWrapperItemProvider) != null;
    }

    public void saveToModel() {
        if (this.suppressedExternalElementPaths == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.suppressedExternalElementPaths) {
            if (!this.isValid(string)) continue;
            stringBuffer.append(string).append(' ');
        }
        Constraint constraint = ConstraintManager.getConstraint((MethodElement)this.process, "", true);
        constraint.setBody(stringBuffer.toString());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValid(String string) {
        URI uRI = URI.createURI((String)string);
        String string2 = uRI.scheme();
        ConfigurableComposedAdapterFactory configurableComposedAdapterFactory = null;
        if (WBS.equals(string2)) {
            configurableComposedAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        } else if (TBS.equals(string2)) {
            configurableComposedAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        } else if (WPBS.equals(string2)) {
            configurableComposedAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        } else {
            if (!CBS.equals(string2)) return false;
            configurableComposedAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
        }
        MethodConfiguration methodConfiguration = null;
        IConfigurator iConfigurator = null;
        IFilter iFilter = configurableComposedAdapterFactory.getFilter();
        if (iFilter instanceof IConfigurator) {
            iConfigurator = (IConfigurator)configurableComposedAdapterFactory.getFilter();
            methodConfiguration = iConfigurator.getMethodConfiguration();
            iConfigurator.setMethodConfiguration(this.process.getDefaultContext());
        }
        try {
            String string3 = uRI.authority();
            if (!this.process.getGuid().equals(string3)) {
                return false;
            }
            Process process = this.process;
            ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)configurableComposedAdapterFactory.adapt(process, ITreeItemContentProvider.class);
            int n = 0;
            while (n < uRI.segmentCount()) {
                void var9_10;
                string3 = uRI.segment(n);
                Iterator iterator = iTreeItemContentProvider.getChildren((Object)var9_10).iterator();
                iTreeItemContentProvider = null;
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Object object = TngUtil.unwrap(e);
                    if (object instanceof MethodElement) {
                        if (!string3.equals(((MethodElement)object).getGuid())) continue;
                        if (e instanceof ITreeItemContentProvider) {
                            iTreeItemContentProvider = (ITreeItemContentProvider)e;
                            break;
                        }
                        iTreeItemContentProvider = (ITreeItemContentProvider)configurableComposedAdapterFactory.adapt(e, ITreeItemContentProvider.class);
                        break;
                    }
                    ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)object;
                    MethodElement methodElement = (MethodElement)itemProviderAdapter.getTarget();
                    if (!string3.equals(methodElement.getGuid())) continue;
                    iTreeItemContentProvider = (ITreeItemContentProvider)itemProviderAdapter;
                    break;
                }
                if (iTreeItemContentProvider == null) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        finally {
            if (iConfigurator != null) {
                iConfigurator.setMethodConfiguration(methodConfiguration);
            }
        }
    }

    public void reveal(List list) {
        this.doSetSuppressed(list, false);
    }

    private static String getViewType(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        Object object = TngUtil.unwrap(breakdownElementWrapperItemProvider);
        if (object instanceof WorkBreakdownElement) {
            return WBS;
        }
        if (object instanceof TeamProfile || object instanceof RoleDescriptor) {
            return TBS;
        }
        if (object instanceof WorkProductDescriptor) {
            return WPBS;
        }
        return "";
    }

    public static String getProcessGUID(String string) {
        int n;
        int n2;
        int n3 = string.indexOf("://");
        if (n3 != -1 && (n2 = n3 + 3) < string.length() && (n = string.indexOf(47, n2)) != -1) {
            return string.substring(n2, n);
        }
        return null;
    }

    public static String getPath(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        StringBuffer stringBuffer = Suppression.getPathWithoutViewType(breakdownElementWrapperItemProvider);
        String string = Suppression.getViewType(breakdownElementWrapperItemProvider);
        stringBuffer.insert(0, ":/").insert(0, string);
        return stringBuffer.toString();
    }

    public static StringBuffer getPathWithoutViewType(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = ProcessUtil.getParentList(null, breakdownElementWrapperItemProvider);
        if (!list.isEmpty()) {
            for (MethodElement methodElement : list) {
                if (methodElement instanceof TaskDescriptor || methodElement instanceof RoleDescriptor) continue;
                stringBuffer.append('/').append(methodElement.getGuid());
            }
        }
        MethodElement methodElement = (MethodElement)TngUtil.unwrap(breakdownElementWrapperItemProvider);
        stringBuffer.append('/').append(methodElement.getGuid());
        return stringBuffer;
    }

    private static List getOwnRelatedElements(Collection collection, boolean bl) {
        if (!collection.isEmpty()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Descriptor descriptor : new ArrayList(collection)) {
                Object[] objectArray = null;
                if (descriptor instanceof TaskDescriptor) {
                    objectArray = RemoveUnusedDescriptorsCommand.TASK_DESCRIPTOR__RELATIONSHIPS;
                } else if (descriptor instanceof RoleDescriptor) {
                    objectArray = RemoveUnusedDescriptorsCommand.ROLE_DESCRIPTOR__RELATIONSHIPS;
                } else if (descriptor instanceof WorkProductDescriptor) {
                    objectArray = RemoveUnusedDescriptorsCommand.WORK_PRODUCT_DESCRIPTOR__RELATIONSHIPS;
                }
                if (objectArray == null) continue;
                int n = 0;
                while (n < objectArray.length) {
                    Object object;
                    boolean bl2;
                    Object object2;
                    Object object3 = objectArray[n];
                    if (object3 instanceof OppositeFeature) {
                        object2 = (OppositeFeature)object3;
                        bl2 = object2.isMany();
                        object = ((MultiResourceEObject)descriptor).getOppositeFeatureValue((OppositeFeature)object2);
                    } else {
                        object2 = (EStructuralFeature)object3;
                        bl2 = object2.isMany();
                        object = descriptor.eGet((EStructuralFeature)object2);
                    }
                    if (bl2) {
                        for (Descriptor descriptor2 : (Collection)object) {
                            if (descriptor2.getSuppressed() == bl || ProcessUtil.checkDescriptorReferences(collection, descriptor2)) continue;
                            arrayList.add(descriptor2);
                            collection.add(descriptor2);
                        }
                    } else {
                        object2 = (Descriptor)object;
                        if (object2 != null && object2.getSuppressed() != bl && !ProcessUtil.checkDescriptorReferences(collection, (Descriptor)object2)) {
                            arrayList.add(object2);
                            collection.add(object2);
                        }
                    }
                    ++n;
                }
            }
            return arrayList;
        }
        return null;
    }

    private Result setSuppressed(List list, boolean bl) {
        List list2;
        Result result = this.doSetSuppressed(list, bl);
        if (!result.descriptors.isEmpty() && (list2 = Suppression.getOwnRelatedElements(result.descriptors, bl)) != null) {
            Result result2 = this.doSetSuppressed(list2, bl);
            result.elements.addAll(result2.elements);
            result.descriptors.addAll(result2.descriptors);
            result.paths.addAll(result2.paths);
        }
        return result;
    }

    public void suppress(List list) {
        this.doSetSuppressed(list, true);
    }

    private Result doSetSuppressed(List list, boolean bl) {
        Result result = new Result();
        for (Object e : list) {
            BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider;
            if (e instanceof BreakdownElementWrapperItemProvider) {
                breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)e;
                BreakdownElement breakdownElement = (BreakdownElement)TngUtil.unwrap(breakdownElementWrapperItemProvider);
                if (!breakdownElementWrapperItemProvider.isReadOnly()) {
                    if (breakdownElement.getSuppressed() == bl) continue;
                    breakdownElement.setSuppressed(Boolean.valueOf(bl));
                    result.elements.add(breakdownElement);
                    if (!(breakdownElement instanceof Descriptor)) continue;
                    result.descriptors.add(breakdownElement);
                    continue;
                }
                String string = Suppression.getPath(breakdownElementWrapperItemProvider);
                boolean bl2 = bl ? this.getSuppressedExternalElementPaths().add(string) : this.getSuppressedExternalElementPaths().remove(string);
                if (!bl2) continue;
                result.paths.add(string);
                continue;
            }
            if (!(e instanceof MethodElement) || (breakdownElementWrapperItemProvider = (MethodElement)e).getSuppressed() == bl) continue;
            breakdownElementWrapperItemProvider.setSuppressed(bl);
            result.elements.add(breakdownElementWrapperItemProvider);
            if (!(breakdownElementWrapperItemProvider instanceof Descriptor)) continue;
            result.descriptors.add(breakdownElementWrapperItemProvider);
        }
        this.modified = !result.isEmpty();
        return result;
    }

    public boolean hasUnsuppressed(List list) {
        for (Object e : list) {
            if (!(e instanceof BreakdownElementWrapperItemProvider ? !this.isSuppressed((BreakdownElementWrapperItemProvider)e) : e instanceof BreakdownElement && !this.isSuppressed((BreakdownElement)e))) continue;
            return true;
        }
        return false;
    }

    public boolean isSaveNeeded() {
        return this.modified;
    }

    public void saveIsDone() {
        this.modified = false;
    }

    protected boolean __isSuppressed(ComposedBreakdownElementWrapperItemProvider composedBreakdownElementWrapperItemProvider) {
        for (Object e : composedBreakdownElementWrapperItemProvider.getValues()) {
            if (this.isSuppressed(e)) continue;
            return false;
        }
        return true;
    }

    public boolean isSuppressed(Object object) {
        if (object == null) {
            return true;
        }
        ComposedBreakdownElementWrapperItemProvider composedBreakdownElementWrapperItemProvider = ProcessUtil.getComposedWrapper(object);
        if (composedBreakdownElementWrapperItemProvider != null) {
            return this.__isSuppressed(composedBreakdownElementWrapperItemProvider);
        }
        if (this.internalUnsuppressedElements.contains(object)) {
            return false;
        }
        if (object instanceof BreakdownElementWrapperItemProvider) {
            return this.__isSuppressed((BreakdownElementWrapperItemProvider)object);
        }
        if (object instanceof BreakdownElement) {
            return this.__isSuppressed((BreakdownElement)object);
        }
        Object object2 = null;
        if (object instanceof WrapperItemProvider) {
            object2 = ((WrapperItemProvider)object).getValue();
        } else if (object instanceof ItemProviderAdapter) {
            object2 = ((ItemProviderAdapter)object).getTarget();
        }
        if (object2 != null && object2 != object) {
            return this.isSuppressed(object2);
        }
        return false;
    }

    public boolean updateSuppressionFromBase(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        String string = Suppression.getPath(breakdownElementWrapperItemProvider);
        BreakdownElement breakdownElement = this.getSuppressed(breakdownElementWrapperItemProvider, true, false, true, false, null);
        boolean bl = breakdownElement != null ? this.getSuppressedExternalElementPaths().add(string) : this.getSuppressedExternalElementPaths().remove(string);
        if (bl) {
            this.modified = true;
        }
        return bl;
    }

    public String checkDuplicateNameAfterReveal(Collection collection, AdapterFactory adapterFactory) {
        Collection collection2 = this.getApplicableItems(collection, false);
        for (Object e : collection2) {
            Object object;
            String string;
            Object object2;
            if (e instanceof BreakdownElement) {
                object2 = (BreakdownElement)e;
                string = ProcessUtil.checkBreakdownElementName(adapterFactory, object2, object2.getName(), this);
                if (string != null) {
                    return LibraryEditResources.Suppression_nameDuplication;
                }
                string = ProcessUtil.checkBreakdownElementPresentationName(adapterFactory, object2, object2.getPresentationName(), this);
                if (string == null) continue;
                return LibraryEditResources.Suppression_presentationNameDuplication;
            }
            object2 = TngUtil.unwrap(e);
            if (!(object2 instanceof BreakdownElement) || !((object = (string = (ITreeItemContentProvider)adapterFactory.adapt(e, ITreeItemContentProvider.class)).getParent(e)) instanceof BreakdownElement)) continue;
            string = (ITreeItemContentProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class);
            Collection collection3 = string.getChildren(object);
            MethodElement methodElement = null;
            if (e instanceof Descriptor) {
                methodElement = ProcessUtil.getAssociatedElement((Descriptor)e);
            }
            try {
                this.internalUnsuppressedElements.add(e);
                for (Object e2 : collection3) {
                    Object object3;
                    BreakdownElement breakdownElement;
                    if (!(e2 instanceof BreakdownElement) || (breakdownElement = (BreakdownElement)e2).getSuppressed().booleanValue() || methodElement != null && e2 instanceof Descriptor && (object3 = ProcessUtil.getAssociatedElement((Descriptor)e)) == methodElement) continue;
                    object3 = ProcessUtil.checkBreakdownElementName(adapterFactory, breakdownElement, breakdownElement.getName(), this);
                    if (object3 != null) {
                        String string2 = LibraryEditResources.Suppression_nameDuplication;
                        return string2;
                    }
                    object3 = ProcessUtil.checkBreakdownElementPresentationName(adapterFactory, breakdownElement, breakdownElement.getPresentationName(), this);
                    if (object3 == null) continue;
                    String string3 = LibraryEditResources.Suppression_presentationNameDuplication;
                    return string3;
                }
            }
            finally {
                this.internalUnsuppressedElements.remove(e);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object getObjectByPath(String[] var1_1, AdapterFactory var2_2) {
        if (var1_1.length == 0 || var2_2 == null || !var1_1[0].equals(this.process.getGuid())) {
            return null;
        }
        var3_3 /* !! */  = this.process;
        var4_4 = var1_1.length;
        var5_5 = 1;
        while (var5_5 < var4_4) {
            var6_6 = (ITreeItemContentProvider)var2_2.adapt((Object)var3_3 /* !! */ , ITreeItemContentProvider.class);
            var7_7 = false;
            var8_8 = null;
            var9_9 = null;
            try {
                if (TngUtil.unwrap(var3_3 /* !! */ ) instanceof Activity) {
                    if (var6_6 instanceof BSActivityItemProvider) {
                        var10_10 /* !! */  = (BSActivityItemProvider)var6_6;
                        if (var10_10 /* !! */ .isRolledUp()) {
                            var10_10 /* !! */ .basicSetRolledUp(false);
                            var8_8 = var10_10 /* !! */ ;
                        }
                    } else if (var6_6 instanceof IBSItemProvider && (var10_10 /* !! */  = (IBSItemProvider)var6_6).isRolledUp()) {
                        var10_10 /* !! */ .setRolledUp(false);
                        var8_8 = var10_10 /* !! */ ;
                    }
                }
                var9_9 = var6_6.getChildren((Object)var3_3 /* !! */ ).iterator();
                if (true) ** GOTO lbl33
            }
            finally {
                if (var8_8 != null) {
                    var8_8.setRolledUp(true);
                }
            }
            do {
                if (!((var11_11 = TngUtil.unwrap(var10_10 /* !! */  = var9_9.next())) instanceof MethodElement) || !((MethodElement)var11_11).getGuid().equals(var1_1[var5_5])) continue;
                var7_7 = true;
                var3_3 /* !! */  = var10_10 /* !! */ ;
                break;
lbl33:
                // 2 sources

            } while (var9_9.hasNext());
            if (!var7_7) {
                return null;
            }
            ++var5_5;
        }
        return var3_3 /* !! */ ;
    }

    public boolean isSuppressed(String[] stringArray, AdapterFactory adapterFactory) throws IllegalArgumentException {
        Object object = this.getObjectByPath(stringArray, adapterFactory);
        if (object == null) {
            throw new IllegalArgumentException("Could not find object with path '" + stringArray + "'");
        }
        return this.isSuppressed(object);
    }

    public static Set getSuppressedItems(Process process, AdapterFactory[] adapterFactoryArray) {
        HashSet hashSet = new HashSet();
        Suppression suppression = new Suppression(process);
        int n = 0;
        while (n < adapterFactoryArray.length) {
            AdapterFactoryTreeIterator adapterFactoryTreeIterator = new AdapterFactoryTreeIterator(adapterFactoryArray[n], (Object)process);
            while (adapterFactoryTreeIterator.hasNext()) {
                Object e = adapterFactoryTreeIterator.next();
                if (!suppression.isSuppressed(e)) continue;
                hashSet.add(e);
            }
            ++n;
        }
        return hashSet;
    }

    public boolean isItselfSuppressed(Object object) {
        if (object instanceof ProcessElement) {
            return ((ProcessElement)object).getSuppressed();
        }
        if (object instanceof BreakdownElementWrapperItemProvider && ProcessUtil.isInherited(object)) {
            return this.isInSuppressedList((BreakdownElementWrapperItemProvider)object);
        }
        if (object instanceof BreakdownElementWrapperItemProvider && !ProcessUtil.isInherited(object)) {
            Object object2 = TngUtil.unwrap(object);
            return ((MethodElement)object2).getSuppressed();
        }
        return false;
    }

    public boolean isSuppressed(Object object, EStructuralFeature eStructuralFeature) {
        return this.isSuppressed(object);
    }

    private static class Result {
        Collection elements = new ArrayList();
        Collection descriptors = new ArrayList();
        Collection paths = new ArrayList();

        Result() {
        }

        boolean isEmpty() {
            return this.elements.isEmpty() && this.paths.isEmpty();
        }

        void clear() {
            this.elements.clear();
            this.descriptors.clear();
            this.paths.clear();
        }
    }

    public static class SuppressionCommand
    extends AbstractCommand
    implements IResourceAwareCommand {
        protected Collection modifiedResources;
        protected List collection;
        protected Result result;
        protected boolean suppressed;
        protected Suppression suppression;

        public SuppressionCommand(Suppression suppression, List list, boolean bl) {
            this.suppression = suppression;
            this.collection = list;
            this.suppressed = bl;
        }

        public Collection getModifiedResources() {
            if (this.modifiedResources == null) {
                this.modifiedResources = Collections.singletonList(this.suppression.getProcess().eResource());
            }
            return this.modifiedResources;
        }

        public void execute() {
            this.result = this.suppression.setSuppressed(this.collection, this.suppressed);
            this.didExecute();
        }

        protected void didExecute() {
        }

        public void redo() {
            this.execute();
        }

        public void undo() {
            if (this.result != null && !this.result.isEmpty()) {
                if (!this.result.elements.isEmpty()) {
                    for (Object object : this.result.elements) {
                        object.setSuppressed(Boolean.valueOf(!this.suppressed));
                    }
                }
                if (!this.result.paths.isEmpty()) {
                    for (Object object : this.result.paths) {
                        if (this.suppressed) {
                            this.suppression.getSuppressedExternalElementPaths().remove(object);
                            continue;
                        }
                        this.suppression.getSuppressedExternalElementPaths().add(object);
                    }
                }
                this.didUndo();
                this.result.clear();
            }
        }

        protected void didUndo() {
        }

        protected boolean prepare() {
            return true;
        }

        public Collection getResult() {
            if (!this.result.isEmpty()) {
                return this.collection;
            }
            return Collections.EMPTY_LIST;
        }

        public Collection getAffectedObjects() {
            return this.collection;
        }

        public boolean isReadOnlyElementAffected() {
            return !this.result.paths.isEmpty();
        }

        public void dispose() {
            if (this.result != null) {
                this.result.clear();
            }
            super.dispose();
        }
    }
}

