/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.PluginDependencyInfoMgr;
import org.eclipse.epf.uma.MethodPlugin;

public class PluginDepInfo {
    private PluginDependencyInfoMgr mgr;
    private MethodPlugin plugin;
    private HashMap parentMap;
    private boolean complete = false;
    private boolean debug = false;

    protected PluginDepInfo(PluginDependencyInfoMgr pluginDependencyInfoMgr, MethodPlugin methodPlugin) {
        this.mgr = pluginDependencyInfoMgr;
        this.plugin = methodPlugin;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void build(boolean bl) {
        if (this.debug) {
            System.out.println("LD> build: " + this);
        }
        this.buildInner(bl);
    }

    private void buildInner(boolean bl) {
        PluginDepInfo pluginDepInfo = this.mgr.getProcessedInfo(this.getPlugin());
        if (pluginDepInfo != null) {
            if (pluginDepInfo == this && this.complete) {
                return;
            }
            throw new RuntimeException("Internal error in buildInner: " + pluginDepInfo);
        }
        this.mgr.addToProcessed(this);
        if (this.debug) {
            System.out.println("LD> buildInner: " + this);
            System.out.println("");
        }
        this.buildInner_(bl);
    }

    private void buildInner_(boolean bl) {
        int n;
        List list = this.getPlugin().getBases();
        int n2 = n = list == null ? 0 : list.size();
        if (n == 0) {
            this.complete = true;
            return;
        }
        this.parentMap = new HashMap();
        ArrayList<PluginDepInfo> arrayList = null;
        int n3 = 0;
        while (n3 < n) {
            MethodPlugin methodPlugin = (MethodPlugin)list.get(n3);
            PluginDepInfo pluginDepInfo = this.mgr.getProcessedInfo(methodPlugin);
            if (pluginDepInfo == null) {
                pluginDepInfo = new PluginDepInfo(this.mgr, methodPlugin);
                this.parentMap.put(methodPlugin.getGuid(), pluginDepInfo);
                pluginDepInfo.buildInner(bl);
            } else {
                this.parentMap.put(methodPlugin.getGuid(), pluginDepInfo);
                if (bl) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<PluginDepInfo>();
                    }
                    arrayList.add(pluginDepInfo);
                }
            }
            ++n3;
        }
        this.complete = true;
        if (bl && arrayList != null) {
            n3 = 0;
            while (n3 < arrayList.size()) {
                this.reachableBy((PluginDepInfo)arrayList.get(n3));
                ++n3;
            }
        }
    }

    public boolean reachableBy(PluginDepInfo pluginDepInfo) {
        if (!(pluginDepInfo instanceof PluginDepInfo)) {
            throw new UnsupportedOperationException();
        }
        if (this.debug) {
            System.out.println("LD> Entry reachableBy: this -> " + this);
            System.out.println("LD> Entry reachableBy: info -> " + pluginDepInfo);
            System.out.println("");
        }
        return this.reachableBy(pluginDepInfo, new Stack(), new HashMap());
    }

    private boolean reachableBy(PluginDepInfo pluginDepInfo, Stack stack, Map map) {
        stack.push(pluginDepInfo);
        if (this.debug) {
            System.out.println("LD> reachableBy: this -> " + this);
            System.out.println("LD> reachableBy: info -> " + pluginDepInfo);
            System.out.println("");
        }
        boolean bl = this.reachableBy_(pluginDepInfo, stack, map);
        stack.pop();
        return bl;
    }

    private boolean reachableBy_(PluginDepInfo pluginDepInfo, Stack stack, Map map) {
        HashMap hashMap = pluginDepInfo.parentMap;
        if (hashMap == null || hashMap.isEmpty()) {
            return false;
        }
        if (hashMap.containsKey(this.getPlugin().getGuid())) {
            if (this.debug) {
                System.out.println("LD> Contained in parentMap of: " + pluginDepInfo);
            }
            stack.push(this);
            this.mgr.logCircularDependency((Stack)stack.clone());
            stack.pop();
            return true;
        }
        if (map.containsKey(pluginDepInfo.getPlugin().getGuid())) {
            return false;
        }
        map.put(pluginDepInfo.getPlugin().getGuid(), pluginDepInfo);
        for (PluginDepInfo pluginDepInfo2 : hashMap.values()) {
            if (pluginDepInfo2.containedIn(stack)) {
                if (this.debug) {
                    System.out.println("LD> containedIn stack: " + pluginDepInfo);
                }
                stack.push(pluginDepInfo2);
                this.mgr.logCircularDependency((Stack)stack.clone());
                stack.pop();
                return true;
            }
            if (!this.reachableBy(pluginDepInfo2, stack, map)) continue;
            return true;
        }
        return false;
    }

    public MethodPlugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return TngUtil.getLabelWithPath(this.plugin);
    }

    private boolean containedIn(List list) {
        int n;
        int n2 = n = list == null ? 0 : list.size();
        if (n == 0) {
            return false;
        }
        String string = this.getPlugin().getGuid();
        if (n == 1) {
            return string.equals(((PluginDepInfo)list.get(0)).getPlugin().getGuid());
        }
        HashMap<String, PluginDepInfo> hashMap = new HashMap<String, PluginDepInfo>();
        int n3 = 0;
        while (n3 < n) {
            PluginDepInfo pluginDepInfo = (PluginDepInfo)list.get(n3);
            hashMap.put(pluginDepInfo.getPlugin().getGuid(), pluginDepInfo);
            ++n3;
        }
        return hashMap.containsKey(string);
    }
}

