/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.Bookmark;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.util.IconUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.DefaultElementTypeResources;
import org.eclipse.epf.publishing.services.ISiteGenerator;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.services.PublishingContentValidator;
import org.eclipse.epf.publishing.services.PublishingRunnable;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractViewBuilder {
    protected static final int TIMEOUT_INTERVAL = 600000;
    protected static boolean profiling = PublishingPlugin.getDefault().isProfiling();
    protected ISiteGenerator siteGenerator;
    protected PublishOptions options;
    protected MethodConfiguration config;
    protected Bookmark defaultView;
    PublishingRunnable runnable = null;

    public AbstractViewBuilder(ISiteGenerator iSiteGenerator) {
        this.siteGenerator = iSiteGenerator;
        this.options = iSiteGenerator.getPublishOptions();
        this.config = iSiteGenerator.getHtmlBuilder().getLayoutManager().getConfiguration();
        this.runnable = new PublishingRunnable(iSiteGenerator.getHtmlBuilder(), 600000);
    }

    public ISiteGenerator getSiteGenerator() {
        return this.siteGenerator;
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.siteGenerator.getHtmlBuilder();
    }

    public PublishOptions getOptions() {
        return this.siteGenerator.getPublishOptions();
    }

    public ElementLayoutManager getLayoutMgr() {
        return this.getHtmlBuilder().getLayoutManager();
    }

    public PublishingContentValidator getValidator() {
        return (PublishingContentValidator)this.getHtmlBuilder().getValidator();
    }

    protected boolean canPublish(MethodElement methodElement) {
        return this.isVisible(methodElement);
    }

    protected boolean isVisible(MethodElement methodElement) {
        if (methodElement == null) {
            return false;
        }
        if (this.getValidator().isDiscarded(null, null, methodElement)) {
            return false;
        }
        if (!ConfigurationHelper.canShow((MethodElement)methodElement, (MethodConfiguration)this.config)) {
            return false;
        }
        if (this.options.isPublishProcess()) {
            return this.getValidator().inClosure(methodElement);
        }
        return true;
    }

    protected void discardEmptyCategory(ContentCategory contentCategory, boolean bl) {
        if (bl) {
            this.getValidator().setDiscardedElement((MethodElement)contentCategory);
            this.getValidator().logWarning((MethodElement)contentCategory, PublishingResources.discaredCategoryWarning_msg);
        } else {
            this.getValidator().addValidCategory(contentCategory);
        }
    }

    protected MethodElement calc01FeatureValue(MethodElement methodElement, EStructuralFeature eStructuralFeature) {
        return ConfigurationHelper.calc01FeatureValue((MethodElement)methodElement, (EStructuralFeature)eStructuralFeature, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
    }

    protected List calc0nFeatureValue(MethodElement methodElement, EStructuralFeature eStructuralFeature) {
        return ConfigurationHelper.calc0nFeatureValue((MethodElement)methodElement, (EStructuralFeature)eStructuralFeature, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
    }

    protected MethodElement calc01FeatureValue(MethodElement methodElement, OppositeFeature oppositeFeature) {
        return ConfigurationHelper.calc01FeatureValue((MethodElement)methodElement, (OppositeFeature)oppositeFeature, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
    }

    protected List calc0nFeatureValue(MethodElement methodElement, OppositeFeature oppositeFeature) {
        return ConfigurationHelper.calc0nFeatureValue((MethodElement)methodElement, (OppositeFeature)oppositeFeature, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
    }

    protected List getPublishedElements() {
        return this.getValidator().getPublishedElements();
    }

    protected void publish(IProgressMonitor iProgressMonitor, MethodElement methodElement) {
        block6: {
            try {
                List list = this.getValidator().getReferencedElements();
                List list2 = this.getValidator().getPublishedElements();
                HtmlBuilder htmlBuilder = this.getHtmlBuilder();
                if (!this.canPublish(methodElement)) {
                    htmlBuilder.getValidator().logWarning(methodElement, PublishingResources.invalidElementWarning_msg);
                    break block6;
                }
                if (list2.contains(methodElement)) break block6;
                try {
                    Object object;
                    if (iProgressMonitor != null) {
                        object = list != null ? NLS.bind((String)PublishingResources.publishingLinkedElementTask_name, (Object)Integer.toString(list2.size()), (Object)Integer.toString(list.size())) : NLS.bind((String)PublishingResources.publishingElementTask_name, (Object)methodElement.getType().getName(), (Object)methodElement.getName());
                        iProgressMonitor.subTask((String)object);
                    }
                    object = htmlBuilder.getLayoutManager().getLayout(methodElement, true);
                    String string = this.runnable.generateHtml((IElementLayout)object);
                    this.elementPublished((IElementLayout)object, string);
                }
                catch (Exception exception) {
                    htmlBuilder.getValidator().logError(methodElement, NLS.bind((String)PublishingResources.publishElementError_msg, (Object)exception.getMessage()), (Throwable)exception);
                }
                list2.add(methodElement);
            }
            catch (RuntimeException runtimeException) {
                this.getHtmlBuilder().getValidator().logError(methodElement, NLS.bind((String)PublishingResources.publishElementError_msg, (Object)runtimeException.getMessage()), (Throwable)runtimeException);
            }
        }
    }

    protected void elementPublished(IElementLayout iElementLayout, String string) {
    }

    private void copyNodeIcon(File file) {
        String string = file.getName();
        File file2 = new File(this.siteGenerator.getNodeIconPath(), string);
        if (!FileUtil.copyFile((File)file, (File)file2)) {
            this.getHtmlBuilder().getValidator().logWarning(NLS.bind((String)PublishingResources.copyFileWarning_msg, (Object)file.getAbsolutePath(), (Object)file2.getAbsolutePath()));
        }
    }

    private String getNodeIconName(Object object) {
        Object object2;
        File file = null;
        String string = null;
        if (object instanceof DescribableElement) {
            object2 = ((DescribableElement)object).getNodeicon();
            String string2 = ((DescribableElement)object).getType().getName().toLowerCase();
            if (DefaultElementTypeResources.useDefaultIcon(string2)) {
                object2 = null;
            }
            if (object2 != null) {
                boolean bl = false;
                try {
                    URL uRL = ((URI)object2).toURL();
                    if (uRL != null) {
                        file = new File(URLDecoder.decode(uRL.getFile(), "UTF-8"));
                        bl = true;
                    }
                }
                catch (Exception exception) {}
                if (!bl) {
                    file = new File(TngUtil.getFullPathofNodeorShapeIconURI((EObject)((EObject)object), (URI)object2));
                }
            }
        }
        if (file != null && !file.exists()) {
            file = null;
        }
        if (file == null && object instanceof MethodElement) {
            object2 = ((MethodElement)object).getType().getName().toLowerCase();
            file = IconUtil.getNodeIconFile((String)object2);
        }
        if (file != null) {
            if (!file.exists()) {
                if (object instanceof MethodElement) {
                    this.getHtmlBuilder().getValidator().logWarning((MethodElement)object, NLS.bind((String)PublishingResources.missingIconFileWarning_msg, (Object)file.getAbsolutePath()));
                } else {
                    this.getHtmlBuilder().getValidator().logWarning(NLS.bind((String)PublishingResources.missingIconFileWarning_msg, (Object)file.getAbsolutePath()));
                }
            }
            this.copyNodeIcon(file);
            string = file.getName();
        }
        if (string == null || string.length() == 0) {
            object2 = object instanceof MethodElement ? ((MethodElement)object).getName() : object.toString();
            this.getHtmlBuilder().getValidator().logWarning(NLS.bind((String)PublishingResources.missingIconNameWarning_msg, (Object)object2));
        }
        return string;
    }

    private String getName(Object object) {
        String string = null;
        if (object instanceof MethodElement) {
            int n;
            MethodElement methodElement = (MethodElement)object;
            string = ConfigurationHelper.getPresentationName((MethodElement)methodElement, (MethodConfiguration)this.config);
            if ((string == null || string.equals("")) && (n = (string = methodElement.getClass().getName()).lastIndexOf(".")) >= 0 && (string = string.substring(n + 1)).endsWith("Impl")) {
                string = string.substring(0, string.length() - 4);
            }
        } else if (object instanceof ItemProviderAdapter) {
            ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)object;
            string = itemProviderAdapter.getText(object);
        }
        return string;
    }

    private String getGUID(Object object) {
        if (object instanceof MethodElement) {
            return ((MethodElement)object).getGuid();
        }
        return null;
    }

    private String getURL(Object object) {
        if (object instanceof MethodElement) {
            return this.getLayoutMgr().getLayout((MethodElement)object, true).getUrl();
        }
        return "applet//empty.htm";
    }

    protected Bookmark createBookmark(IProgressMonitor iProgressMonitor, Object object) {
        if (object instanceof MethodElement) {
            this.getHtmlBuilder().getValidator().addReferencedElement(null, (MethodElement)object);
        }
        String string = this.getName(object);
        String string2 = this.getGUID(object);
        String string3 = this.getURL(object);
        String string4 = this.getNodeIconName(object);
        String string5 = NLS.bind((String)PublishingResources.generatingBookmarkTask_name, (Object)string);
        iProgressMonitor.subTask(string5);
        return this.createBookmark(string, string2, string3, string4, string4, object);
    }

    protected Bookmark createBookmark(String string, String string2, String string3, String string4, String string5, Object object) {
        Bookmark bookmark = new Bookmark(string);
        bookmark.setPresentationName(string);
        bookmark.setUniqueId(string2);
        bookmark.setClosedIconName(string4);
        bookmark.setOpenIconName(string5);
        bookmark.setFileName(string3);
        bookmark.setFromContentLibrary(true);
        bookmark.setEnabled(true);
        bookmark.setExist(true);
        bookmark.setVisible(true);
        bookmark.setTransparency(false);
        bookmark.setDefault(true);
        bookmark.setCurrent(false);
        bookmark.setOwner(object);
        return bookmark;
    }

    public Bookmark getDefaultView() {
        return this.defaultView;
    }

    public abstract List<Bookmark> buildViews(IProgressMonitor var1);

    public void dispose() {
        this.config = null;
        if (this.runnable != null) {
            this.runnable.dispose();
            this.runnable = null;
        }
        if (this.siteGenerator != null) {
            this.siteGenerator.dispose();
            this.siteGenerator = null;
        }
    }
}

