/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.xmi;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.common.serviceability.VersionUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceException;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.library.xmi.XMILibraryPlugin;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.migration.MappingUtil;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.osgi.util.NLS;

public class XMILibraryUtil {
    private static final String EMPTY_METHOD_LIBRARY_PATH_MSG = LibraryResources.emptyLibraryPathError_reason;
    private static final String MISSING_LIBRARY_FILE_MSG = LibraryResources.missingLibraryFileError_reason;
    private static final String COULD_NOT_LOCK_LIBRARY_MSG = LibraryResources.couldNotLockLibrary_reason;
    public static final IStatus EMPTY_METHOD_LIBRARY_PATH_STATUS = new Status(4, LibraryPlugin.getDefault().getId(), 1, EMPTY_METHOD_LIBRARY_PATH_MSG, null);
    public static final IStatus MISSING_LIBRARY_FILE_STATUS = new Status(4, LibraryPlugin.getDefault().getId(), 1, MISSING_LIBRARY_FILE_MSG, null);
    public static final IStatus COULD_NOT_LOCK_LIBRARY_STATUS = new Status(4, LibraryPlugin.getDefault().getId(), 1, COULD_NOT_LOCK_LIBRARY_MSG, null);

    static {
        try {
            new MultiFileResourceSetImpl();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean hasMethodLibrary(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        File file2 = new File(file, "library.xmi");
        return file2.exists();
    }

    public static String getLibraryModelFile(String string) {
        if (!StrUtil.isBlank((String)string)) {
            String string2;
            String string3 = new File(string).getAbsolutePath();
            if (string3.endsWith(string2 = String.valueOf(File.separator) + "library.xmi")) {
                return string3;
            }
            return String.valueOf(string3) + string2;
        }
        return string;
    }

    public static IStatus isValidLibrary(String string, boolean bl) {
        String string2;
        String string3;
        File file;
        if (string == null || string.trim().length() == 0) {
            return EMPTY_METHOD_LIBRARY_PATH_STATUS;
        }
        if (bl && !(file = new File(XMILibraryUtil.getLibraryModelFile(string))).exists()) {
            return MISSING_LIBRARY_FILE_STATUS;
        }
        file = new File(string);
        if (string.endsWith("library.xmi")) {
            file = file.getParentFile();
        }
        if ((string3 = file.getAbsolutePath()).startsWith("\\")) {
            boolean bl2 = true;
            int n = string3.indexOf(File.separatorChar, 2);
            if (n < 0) {
                bl2 = false;
            } else {
                string2 = string3.substring(n + 1);
                if (string2.length() == 0) {
                    bl2 = false;
                } else {
                    string2 = (n = string3.indexOf(File.separatorChar, n + 1)) < 0 ? string3 : string3.substring(0, n);
                    File file2 = new File(string2);
                    if (!file2.exists()) {
                        bl2 = false;
                    }
                }
            }
            if (!bl2) {
                return EMPTY_METHOD_LIBRARY_PATH_STATUS;
            }
        }
        IProjectDescription iProjectDescription = null;
        try {
            iProjectDescription = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(string3) + File.separator + ".project"));
            if (iProjectDescription != null) {
                return Status.OK_STATUS;
            }
        }
        catch (CoreException coreException) {}
        if (Platform.getLocation().isPrefixOf((IPath)new Path(string3))) {
            return Status.OK_STATUS;
        }
        string2 = ResourceUtil.findProject((String)string3);
        if (string2 == null) {
            string2 = ResourcesPlugin.getWorkspace().getRoot().getProject(file.getName());
        }
        return ResourcesPlugin.getWorkspace().validateProjectLocation((IProject)string2, (IPath)new Path(string3));
    }

    public static IStatus isValidLibrary(String string) {
        return XMILibraryUtil.isValidLibrary(string, false);
    }

    public static boolean isMethodLibraryUpgradeRequired(String string, VersionUtil.VersionCheckInfo versionCheckInfo) {
        return XMILibraryUtil.isMethodLibraryUpgradeRequired(string, "library.xmi", versionCheckInfo);
    }

    public static boolean isMethodLibraryUpgradeRequired(String string, String string2, VersionUtil.VersionCheckInfo versionCheckInfo) {
        return MappingUtil.conversionRequired((String)(String.valueOf(string) + File.separator + string2), (VersionUtil.VersionCheckInfo)versionCheckInfo);
    }

    public static MethodLibrary createMethodLibrary(String string, String string2) throws LibraryServiceException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("library.path", string2);
        return LibraryService.getInstance().createMethodLibrary(string, "xmi", hashMap);
    }

    public static MethodLibrary openMethodLibrary(String string) throws LibraryServiceException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("library.path", string);
        return LibraryService.getInstance().openMethodLibrary("xmi", hashMap);
    }

    public static void openMethodLibraryProject(MethodLibrary methodLibrary, IProgressMonitor iProgressMonitor) {
        IProject iProject;
        if (methodLibrary != null && methodLibrary.eResource() != null && methodLibrary.eResource().getURI().isFile() && (iProject = ResourceUtil.findProject((MethodLibrary)methodLibrary)) != null && !iProject.isOpen()) {
            try {
                iProject.open(128, iProgressMonitor);
            }
            catch (CoreException coreException) {
                XMILibraryPlugin.getDefault().getLogger().logError((Throwable)coreException);
            }
        }
    }

    public static boolean containsPluginOrConfigSpecExportFile(String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        string = new File(string).getAbsolutePath();
        string = String.valueOf(string) + File.separator + "export.xmi";
        File file = new File(string);
        return file.exists();
    }

    public static IStatus checkVersion(File file, VersionUtil.VersionCheckInfo versionCheckInfo) {
        if (versionCheckInfo != null && versionCheckInfo.result > 0) {
            String string = versionCheckInfo.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)LibraryResources.oldToolVersion_err_msg, (Object[])new Object[]{Platform.getProduct().getName(), versionCheckInfo.toolVersion, file}) : NLS.bind((String)LibraryResources.toolVersionMismatch_err_msg, (Object[])new Object[]{Platform.getProduct().getName()});
            return new Status(4, XMILibraryPlugin.getDefault().getId(), 0, string, null);
        }
        return Status.OK_STATUS;
    }
}

