/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.serviceability;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.common.serviceability.ErrorDialogNoReason;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.serviceability.WrappedMessageDialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MsgDialog {
    private AbstractPlugin plugin;
    private String pluginId;
    private Logger logger;

    public MsgDialog(AbstractPlugin abstractPlugin) {
        this.plugin = abstractPlugin;
        this.pluginId = abstractPlugin.getId();
        this.logger = abstractPlugin.getLogger();
    }

    public void displayError(String string, String string2) {
        this.display(4, string, string2, null, null, null);
    }

    public void displayError(String string, String string2, Throwable throwable) {
        this.display(4, string, string2, null, null, throwable);
    }

    public void displayError(String string, String string2, String string3) {
        this.display(4, string, string2, string3, null, null);
    }

    public void displayError(String string, String string2, String string3, Throwable throwable) {
        this.display(4, string, string2, string3, null, throwable);
    }

    public void displayError(String string, String string2, String string3, String string4) {
        this.display(4, string, string2, string3, string4, null);
    }

    public void displayError(String string, String string2, String string3, String string4, Throwable throwable) {
        this.display(4, string, string2, string3, string4, throwable);
    }

    public int displayError(String string, IStatus iStatus) {
        return this.display(string, null, iStatus);
    }

    public int displayError(String string, String string2, IStatus iStatus) {
        return this.display(string, string2, iStatus);
    }

    public void displayWarning(String string, String string2) {
        this.display(2, string, string2, null, null, null);
    }

    public void displayWarning(String string, String string2, Throwable throwable) {
        this.display(2, string, string2, null, null, throwable);
    }

    public void displayWarning(String string, String string2, String string3) {
        this.display(2, string, string2, string3, null, null);
    }

    public void displayWarning(String string, String string2, String string3, Throwable throwable) {
        this.display(2, string, string2, string3, null, throwable);
    }

    public void displayWarning(String string, String string2, String string3, String string4) {
        this.display(2, string, string2, string3, string4, null);
    }

    public void displayWarning(String string, String string2, String string3, String string4, Throwable throwable) {
        this.display(2, string, string2, string3, string4, throwable);
    }

    public void displayWarning(String string, IStatus iStatus) {
        this.display(string, null, iStatus);
    }

    public void displayWarning(String string, String string2, IStatus iStatus) {
        this.display(string, string2, iStatus);
    }

    public synchronized void display(int n, String string, String string2, String string3, String string4, Throwable throwable) {
        if (string2 == null && throwable != null) {
            string2 = throwable.getMessage();
        }
        if (string2 == null) {
            string2 = "";
        }
        if (n != 4 && n != 2) {
            throw new IllegalArgumentException("severity argument must be IStatus.ERROR or IStatus.WARNING");
        }
        this.logger.logMsg(n, string2, throwable);
        Image image = ErrorDialog.getDefaultImage();
        Image image2 = this.getShellImage();
        if (image2 != null) {
            ErrorDialog.setDefaultImage((Image)image2);
        }
        Shell shell = this.plugin.getWorkbench().getDisplay().getActiveShell();
        if (string4 != null && string4.length() > 0) {
            MultiStatus multiStatus = new MultiStatus(this.pluginId, 0, string3, throwable);
            Status status = new Status(n, this.pluginId, 0, string4, throwable);
            multiStatus.add((IStatus)status);
            ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)multiStatus);
        } else if (string3 != null && string3.length() > 0) {
            Status status = new Status(n, this.pluginId, 0, string3, throwable);
            ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)status);
        } else if (n == 4) {
            WrappedMessageDialog.openError(shell, string, string2);
        } else if (n == 2) {
            WrappedMessageDialog.openWarning(shell, string, string2);
        }
        if (image2 != null) {
            ErrorDialog.setDefaultImage((Image)image);
        }
    }

    public synchronized int display(String string, IStatus iStatus) {
        return this.display(string, null, iStatus);
    }

    public synchronized int display(String string, String string2, IStatus iStatus) {
        int n;
        if (iStatus == null) {
            throw new IllegalArgumentException("status argument cannot be null");
        }
        if (string2 == null) {
            string2 = iStatus.getMessage();
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((n = iStatus.getSeverity()) == 4 || n == 2) {
            this.logger.logMsg(n, string2, iStatus.getException());
        }
        Image image = ErrorDialog.getDefaultImage();
        Image image2 = this.getShellImage();
        if (image2 != null) {
            ErrorDialog.setDefaultImage((Image)image2);
        }
        Shell shell = this.plugin.getWorkbench().getDisplay().getActiveShell();
        int n2 = ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
        if (image2 != null) {
            ErrorDialog.setDefaultImage((Image)image);
        }
        return n2;
    }

    public void displayInfo(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        Image image = WrappedMessageDialog.getDefaultImage();
        Image image2 = this.getShellImage();
        if (image2 != null) {
            WrappedMessageDialog.setDefaultImage((Image)image2);
        }
        Shell shell = this.plugin.getWorkbench().getDisplay().getActiveShell();
        WrappedMessageDialog.openInformation(shell, string, string2);
        if (image2 != null) {
            WrappedMessageDialog.setDefaultImage((Image)image);
        }
    }

    public boolean displayPrompt(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        Image image = WrappedMessageDialog.getDefaultImage();
        Image image2 = this.getShellImage();
        if (image2 != null) {
            WrappedMessageDialog.setDefaultImage((Image)image2);
        }
        Shell shell = this.plugin.getWorkbench().getDisplay().getActiveShell();
        boolean bl = WrappedMessageDialog.openQuestion(shell, string, string2);
        if (image2 != null) {
            WrappedMessageDialog.setDefaultImage((Image)image);
        }
        return bl;
    }

    public boolean displayConfirmation(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        Image image = WrappedMessageDialog.getDefaultImage();
        Image image2 = this.getShellImage();
        if (image2 != null) {
            WrappedMessageDialog.setDefaultImage((Image)image2);
        }
        Shell shell = this.plugin.getWorkbench().getDisplay().getActiveShell();
        boolean bl = WrappedMessageDialog.openConfirm(shell, string, string2);
        if (image2 != null) {
            WrappedMessageDialog.setDefaultImage((Image)image);
        }
        return bl;
    }

    public int displayConfirmation(String string, String string2, IStatus iStatus) {
        Image image;
        if (iStatus == null) {
            throw new IllegalArgumentException("status argument cannot be null");
        }
        if (string2 == null) {
            string2 = iStatus.getMessage();
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((image = this.getShellImage()) != null) {
            ErrorDialogNoReason.setDefaultImage((Image)image);
        }
        Shell shell = this.plugin.getWorkbench().getDisplay().getActiveShell();
        int n = ErrorDialogNoReason.openError(shell, string, string2, iStatus);
        return n;
    }

    private Image getShellImage() {
        Shell shell;
        IWorkbenchWindow iWorkbenchWindow;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench != null && (iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow()) != null && (shell = iWorkbenchWindow.getShell()) != null) {
            return shell.getImage();
        }
        return null;
    }
}

