/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractSAXParser
extends DefaultHandler {
    protected Logger logger;
    protected String xmlFile;
    protected StringBuffer strBuf;
    private boolean validating;

    public AbstractSAXParser(Logger logger, boolean bl) {
        this.logger = logger;
        this.validating = bl;
    }

    public void parse(String string) {
        File[] fileArray;
        File[] fileArray2;
        String string2 = StrUtil.replace(string, "%20", " ");
        File file = new File(string2);
        if (file.isFile()) {
            File[] fileArray3 = new File[1];
            fileArray2 = fileArray3;
            fileArray3[0] = file;
        } else {
            fileArray2 = fileArray = file.listFiles();
        }
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                block7: {
                    if (!fileArray[n].isDirectory()) {
                        try {
                            this.parseFile(fileArray[n].getAbsoluteFile());
                        }
                        catch (Exception exception) {
                            if (this.logger == null) break block7;
                            this.logger.logError("Failed to parse \"" + fileArray[n].getAbsolutePath() + '\"', exception);
                        }
                    }
                }
                ++n;
            }
        }
    }

    protected void parseFile(File file) throws ParserConfigurationException, IOException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(this.validating);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        XMLReader xMLReader = sAXParser.getXMLReader();
        xMLReader.setContentHandler(this);
        xMLReader.setErrorHandler(this);
        this.xmlFile = file.getAbsolutePath();
        xMLReader.parse(NetUtil.getUri(file));
    }

    public void startDocument() {
        this.strBuf = new StringBuffer();
    }

    public void characters(char[] cArray, int n, int n2) {
        this.strBuf.append(cArray, n, n2);
    }

    public abstract void startElement(String var1, String var2, String var3, Attributes var4);

    public abstract void endElement(String var1, String var2, String var3);

    public void endDocument() {
    }

    public void warning(SAXParseException sAXParseException) {
        if (this.logger != null) {
            this.logger.logWarning("SAX parsing warning encountered at " + XMLUtil.getLocationOfException(sAXParseException) + ": " + sAXParseException.getMessage());
        }
    }

    public void error(SAXParseException sAXParseException) {
        if (this.logger != null) {
            this.logger.logError("SAX parsing error encountered at " + XMLUtil.getLocationOfException(sAXParseException) + ": " + sAXParseException.getMessage());
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.logger != null) {
            this.logger.logError("SAX parsing fatal error encountered at " + XMLUtil.getLocationOfException(sAXParseException) + ": " + sAXParseException.getMessage());
            this.logger.logError(sAXParseException);
        }
    }

    public String getXMLFile() {
        return this.xmlFile;
    }
}

