/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.internal.ccvs.core.IResourceStateChangeListener;
import org.eclipse.team.internal.ccvs.core.Policy;

public class ResourceStateChangeListeners {
    private static List listeners = new ArrayList();
    private static ResourceStateChangeListeners instance;

    public static synchronized ResourceStateChangeListeners getListener() {
        if (instance == null) {
            instance = new ResourceStateChangeListeners();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IResourceStateChangeListener[] getListeners() {
        List list = listeners;
        synchronized (list) {
            return listeners.toArray(new IResourceStateChangeListener[listeners.size()]);
        }
    }

    private void fireNotification(Notification notification) {
        IResourceStateChangeListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IResourceStateChangeListener listener = listeners[i];
            notification.run(listener);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceStateChangeListener(IResourceStateChangeListener listener) {
        List list = listeners;
        synchronized (list) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceStateChangeListener(IResourceStateChangeListener listener) {
        List list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    public void resourceSyncInfoChanged(final IResource[] resources) {
        if (Policy.DEBUG_SYNC_CHANGE_EVENTS) {
            this.printDebugInfo("Sync info change event ", resources);
        }
        this.fireNotification(new Notification(){

            public void notify(IResourceStateChangeListener listener) {
                listener.resourceSyncInfoChanged(resources);
            }
        });
    }

    public void externalSyncInfoChange(final IResource[] resources) {
        if (Policy.DEBUG_SYNC_CHANGE_EVENTS) {
            this.printDebugInfo("External sync info change event ", resources);
        }
        this.fireNotification(new Notification(){

            public void notify(IResourceStateChangeListener listener) {
                listener.externalSyncInfoChange(resources);
            }
        });
    }

    public void resourceModified(final IResource[] resources) {
        if (Policy.DEBUG_SYNC_CHANGE_EVENTS) {
            this.printDebugInfo("Resource modified change event ", resources);
        }
        this.fireNotification(new Notification(){

            public void notify(IResourceStateChangeListener listener) {
                listener.resourceModified(resources);
            }
        });
    }

    public void projectConfigured(final IProject project) {
        if (Policy.DEBUG_SYNC_CHANGE_EVENTS) {
            this.printDebugInfo("Project configured change event ", new IResource[]{project});
        }
        this.fireNotification(new Notification(){

            public void notify(IResourceStateChangeListener listener) {
                listener.projectConfigured(project);
            }
        });
    }

    public void projectDeconfigured(final IProject project) {
        if (Policy.DEBUG_SYNC_CHANGE_EVENTS) {
            this.printDebugInfo("Project deconfigured change event ", new IResource[]{project});
        }
        this.fireNotification(new Notification(){

            public void notify(IResourceStateChangeListener listener) {
                listener.projectDeconfigured(project);
            }
        });
    }

    private void printDebugInfo(String prefix, IResource[] resources) {
        System.out.print(prefix);
        System.out.print(" from thread  " + Thread.currentThread().getName());
        System.out.print(" for the following " + resources.length + " resources");
        System.out.println(":");
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            System.out.println(resource.getFullPath().toString());
            ++i;
        }
    }

    private abstract class Notification
    implements ISafeRunnable {
        private IResourceStateChangeListener listener;

        private Notification() {
        }

        public void handleException(Throwable exception) {
        }

        public void run(IResourceStateChangeListener listener) {
            this.listener = listener;
            Platform.run((ISafeRunnable)this);
        }

        public void run() throws Exception {
            this.notify(this.listener);
        }

        protected abstract void notify(IResourceStateChangeListener var1);
    }
}

