/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.impl.ContentElementImpl;
import org.eclipse.epf.uma.impl.ProcessElementImpl;
import org.eclipse.epf.uma.util.UmaUtil;

public final class ContentDescriptionFactory {
    private static final Map<EClass, EClass> contentDescClassMap = new HashMap<EClass, EClass>();

    static {
        contentDescClassMap.put(UmaPackage.eINSTANCE.getPractice(), UmaPackage.eINSTANCE.getPracticeDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getRole(), UmaPackage.eINSTANCE.getRoleDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getTask(), UmaPackage.eINSTANCE.getTaskDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getTemplate(), UmaPackage.eINSTANCE.getGuidanceDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getExample(), UmaPackage.eINSTANCE.getGuidanceDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getReusableAsset(), UmaPackage.eINSTANCE.getGuidanceDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getWhitepaper(), UmaPackage.eINSTANCE.getGuidanceDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getArtifact(), UmaPackage.eINSTANCE.getArtifactDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getDeliverable(), UmaPackage.eINSTANCE.getDeliverableDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getOutcome(), UmaPackage.eINSTANCE.getWorkProductDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getRoleDescriptor(), UmaPackage.eINSTANCE.getDescriptorDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getCompositeRole(), UmaPackage.eINSTANCE.getDescriptorDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getTaskDescriptor(), UmaPackage.eINSTANCE.getDescriptorDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getWorkProductDescriptor(), UmaPackage.eINSTANCE.getDescriptorDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getMilestone(), UmaPackage.eINSTANCE.getBreakdownElementDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getTeamProfile(), UmaPackage.eINSTANCE.getBreakdownElementDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getActivity(), UmaPackage.eINSTANCE.getActivityDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getIteration(), UmaPackage.eINSTANCE.getActivityDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getPhase(), UmaPackage.eINSTANCE.getActivityDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getCapabilityPattern(), UmaPackage.eINSTANCE.getProcessDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getDeliveryProcess(), UmaPackage.eINSTANCE.getDeliveryProcessDescription());
        contentDescClassMap.put(UmaPackage.eINSTANCE.getProcessPlanningTemplate(), UmaPackage.eINSTANCE.getProcessDescription());
    }

    public static EClass getContentDescriptionType(EClass eClass) {
        EClass eClass2 = contentDescClassMap.get(eClass);
        if (eClass2 == null && UmaPackage.eINSTANCE.getDescribableElement().isSuperTypeOf(eClass)) {
            eClass2 = UmaPackage.eINSTANCE.getContentDescription();
        }
        return eClass2;
    }

    public static final ContentDescription createContentDescription(DescribableElement describableElement) {
        EClass eClass = contentDescClassMap.get(describableElement.eClass());
        if (eClass == null) {
            eClass = UmaPackage.eINSTANCE.getContentDescription();
        }
        ContentDescription contentDescription = (ContentDescription)UmaFactory.eINSTANCE.create(eClass);
        contentDescription.setName(UmaUtil.createContentDescriptionName(describableElement));
        contentDescription.setGuid(UmaUtil.generateGUID(describableElement.getGuid()));
        return contentDescription;
    }

    public static ContentDescription createContentDescription(ContentElement contentElement) {
        return ContentDescriptionFactory.createContentDescription(contentElement, false);
    }

    public static ContentDescription createContentDescription(DescribableElement describableElement, boolean bl) {
        return ContentDescriptionFactory.createContentDescription(describableElement);
    }

    public static ContentDescription createContentDescription(ContentElement contentElement, boolean bl) {
        ContentDescription contentDescription = ContentDescriptionFactory.createContentDescription((DescribableElement)contentElement);
        return contentDescription;
    }

    public static boolean hasPresentation(MethodElement methodElement) {
        if (methodElement instanceof ContentElementImpl) {
            return ((ContentElementImpl)methodElement).basicGetPresentation() != null;
        }
        if (methodElement instanceof ProcessElementImpl) {
            return ((ProcessElementImpl)methodElement).basicGetPresentation() != null;
        }
        return false;
    }

    public static EClass getContentDescriptionEClass(DescribableElement describableElement) {
        return contentDescClassMap.get(describableElement.eClass());
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        System.out.println("input: '" + string + "'");
        System.out.println("Java's hash code: " + string.hashCode());
        System.out.println("new GUID: " + UmaUtil.generateGUID(string));
    }
}

