/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.wpdd.providers;

import java.lang.ref.WeakReference;
import org.eclipse.epf.diagram.wpdd.edit.parts.DiagramEditPartFactory;
import org.eclipse.epf.diagram.wpdd.part.DiagramVisualIDRegistry;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.AbstractEditPartProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.CreateGraphicEditPartOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.IEditPartOperation;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramEditPartProvider
extends AbstractEditPartProvider {
    private EditPartFactory factory;
    private boolean allowCaching;
    private WeakReference cachedPart;
    private WeakReference cachedView;

    public DiagramEditPartProvider() {
        this.setFactory(new DiagramEditPartFactory());
        this.setAllowCaching(true);
    }

    public final EditPartFactory getFactory() {
        return this.factory;
    }

    protected void setFactory(EditPartFactory editPartFactory) {
        this.factory = editPartFactory;
    }

    public final boolean isAllowCaching() {
        return this.allowCaching;
    }

    protected synchronized void setAllowCaching(boolean bl) {
        this.allowCaching = bl;
        if (!bl) {
            this.cachedPart = null;
            this.cachedView = null;
        }
    }

    protected IGraphicalEditPart createEditPart(View view) {
        EditPart editPart = this.factory.createEditPart(null, (Object)view);
        if (editPart instanceof IGraphicalEditPart) {
            return (IGraphicalEditPart)editPart;
        }
        return null;
    }

    protected IGraphicalEditPart getCachedPart(View view) {
        if (this.cachedView != null && this.cachedView.get() == view) {
            return (IGraphicalEditPart)this.cachedPart.get();
        }
        return null;
    }

    public synchronized IGraphicalEditPart createGraphicEditPart(View view) {
        if (this.isAllowCaching()) {
            IGraphicalEditPart iGraphicalEditPart = this.getCachedPart(view);
            this.cachedPart = null;
            this.cachedView = null;
            if (iGraphicalEditPart != null) {
                return iGraphicalEditPart;
            }
        }
        return this.createEditPart(view);
    }

    public synchronized boolean provides(IOperation iOperation) {
        if (iOperation instanceof CreateGraphicEditPartOperation) {
            View view = ((IEditPartOperation)iOperation).getView();
            if (!"WPDD".equals(DiagramVisualIDRegistry.getModelID(view))) {
                return false;
            }
            if (this.isAllowCaching() && this.getCachedPart(view) != null) {
                return true;
            }
            IGraphicalEditPart iGraphicalEditPart = this.createEditPart(view);
            if (iGraphicalEditPart != null) {
                if (this.isAllowCaching()) {
                    this.cachedPart = new WeakReference<IGraphicalEditPart>(iGraphicalEditPart);
                    this.cachedView = new WeakReference<View>(view);
                }
                return true;
            }
        }
        return false;
    }
}

