/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.internal.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.map.ComputedObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.internal.beans.ListenerSupport;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JavaBeanObservableMap
extends ComputedObservableMap
implements IBeanObservable {
    private PropertyDescriptor propertyDescriptor;
    private PropertyChangeListener elementListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (!JavaBeanObservableMap.this.updating) {
                JavaBeanObservableMap.this.fireMapChange(Diffs.createMapDiffSingleChange((Object)event.getSource(), (Object)event.getOldValue(), (Object)event.getNewValue()));
            }
        }
    };
    private ListenerSupport listenerSupport;
    private boolean updating = false;

    public JavaBeanObservableMap(IObservableSet domain, PropertyDescriptor propertyDescriptor) {
        super(domain);
        this.propertyDescriptor = propertyDescriptor;
        this.listenerSupport = new ListenerSupport(this.elementListener, propertyDescriptor.getName());
        this.init();
    }

    protected void hookListener(Object domainElement) {
        this.listenerSupport.hookListener(domainElement);
    }

    protected void unhookListener(Object domainElement) {
        this.listenerSupport.unhookListener(domainElement);
    }

    protected Object doGet(Object key) {
        try {
            Method readMethod = this.propertyDescriptor.getReadMethod();
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(key, new Object[0]);
        }
        catch (Exception e) {
            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.core.databinding", 4, "cannot get value", (Throwable)e));
            throw new RuntimeException(e);
        }
    }

    protected Object doPut(Object key, Object value) {
        try {
            Object oldValue = this.get(key);
            this.propertyDescriptor.getWriteMethod().invoke(key, value);
            this.keySet().add(key);
            return oldValue;
        }
        catch (Exception e) {
            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.core.databinding", 4, "cannot set value", (Throwable)e));
            throw new RuntimeException(e);
        }
    }

    public Object getObserved() {
        return this.keySet();
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }
}

