/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.library.edit.IPluginUIPackageContextChangedListener;

public class PluginUIPackageContext {
    public static final PluginUIPackageContext INSTANCE = new PluginUIPackageContext();
    private boolean isFlatLayout = false;
    private List<IPluginUIPackageContextChangedListener> listeners;
    public static final String HIERARCHICAL_LAYOUT = "hierarchical";
    public static final String FLAT_LAYOUT = "flat";

    public boolean isFlatLayout() {
        return this.isFlatLayout;
    }

    public void toggleLayout() {
        this.isFlatLayout = !this.isFlatLayout;
        this.notifyListeners();
    }

    public String getLayoutAsString() {
        if (this.isFlatLayout()) {
            return FLAT_LAYOUT;
        }
        return HIERARCHICAL_LAYOUT;
    }

    public void setLayoutHierarchical() {
        this.isFlatLayout = false;
        this.notifyListeners();
    }

    public void setLayoutFlat() {
        this.isFlatLayout = true;
        this.notifyListeners();
    }

    public void addListener(IPluginUIPackageContextChangedListener iPluginUIPackageContextChangedListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPluginUIPackageContextChangedListener>();
        }
        if (!this.listeners.contains(iPluginUIPackageContextChangedListener)) {
            this.listeners.add(iPluginUIPackageContextChangedListener);
        }
    }

    public void removeListener(IPluginUIPackageContextChangedListener iPluginUIPackageContextChangedListener) {
        if (this.listeners != null && this.listeners.contains(iPluginUIPackageContextChangedListener)) {
            this.listeners.remove(iPluginUIPackageContextChangedListener);
        }
    }

    private void notifyListeners() {
        if (this.listeners != null) {
            for (IPluginUIPackageContextChangedListener iPluginUIPackageContextChangedListener : this.listeners) {
                iPluginUIPackageContextChangedListener.layoutChanged(this.isFlatLayout);
            }
        }
    }
}

