/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.IReferencer;
import org.eclipse.epf.library.edit.IStatefulItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.BatchCommand;
import org.eclipse.epf.library.edit.command.IDeleteMethodElementCommandListener;
import org.eclipse.epf.library.edit.command.INestedCommandProvider;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.command.Reference;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.Messenger;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteMethodElementCommand
extends CommandWrapper {
    protected Collection elements;
    private boolean refRemoved;
    public boolean executed = false;
    private Collection commandListeners;
    private ILibraryPersister.FailSafeMethodLibraryPersister persister;
    protected ArrayList elementsToDeleteContent;
    protected Set<Resource> modifiedResources;
    protected Map<EObject, Map<EObject, Collection<EStructuralFeature>>> elementToRemovedRefsMap;
    private BatchCommand batchCommand = new BatchCommand(true);
    protected ArrayList removedReferences;
    public boolean failed;
    private boolean confirmRemoveReferences;
    private ArrayList<Command> nestedCommands;
    private HashSet<Descriptor> descriptors;

    public DeleteMethodElementCommand(Command command, Collection collection) {
        this(command, collection, true);
    }

    public DeleteMethodElementCommand(Command command, Collection collection, boolean bl) {
        super(command);
        this.elements = collection == null ? null : new ArrayList(collection);
        this.commandListeners = new ArrayList();
        this.confirmRemoveReferences = bl;
    }

    public void dispose() {
        this.batchCommand.dispose();
        if (this.commandListeners != null) {
            this.commandListeners.clear();
        }
        if (this.elements != null) {
            this.elements.clear();
        }
        if (this.elementsToDeleteContent != null) {
            this.elementsToDeleteContent.clear();
        }
        if (this.elementToRemovedRefsMap != null) {
            this.elementToRemovedRefsMap.clear();
        }
        if (this.modifiedResources != null) {
            this.modifiedResources.clear();
        }
        if (this.removedReferences != null) {
            this.removedReferences.clear();
        }
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            for (Command command : this.nestedCommands) {
                command.dispose();
            }
        }
        if (this.descriptors != null) {
            this.descriptors.clear();
        }
        super.dispose();
    }

    protected void superExecute() {
        super.execute();
    }

    private void notifyPreExecute() {
        List list = Providers.getCommandListeners(DeleteMethodElementCommand.class);
        if (list != null && !list.isEmpty()) {
            for (ICommandListener iCommandListener : list) {
                try {
                    iCommandListener.preExecute((Command)this);
                }
                catch (Exception exception) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        }
    }

    private void notifyPreUndo() {
        List list = Providers.getCommandListeners(DeleteMethodElementCommand.class);
        if (list != null && !list.isEmpty()) {
            for (ICommandListener iCommandListener : list) {
                try {
                    iCommandListener.preUndo((Command)this);
                }
                catch (Exception exception) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        }
    }

    protected void prepareElements() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.elements) {
            Collection collection;
            RemoveCommand removeCommand;
            if (!(e instanceof CustomCategory) || !((removeCommand = this.getRemoveCommand(e)).getFeature() instanceof EReference) || !((EReference)removeCommand.getFeature()).isContainment() || !removeCommand.getOwnerList().contains(e) || (collection = TngUtil.getExclusiveSubCustomCategories((CustomCategory)e)).isEmpty()) continue;
            for (Object e2 : collection) {
                if (this.elements.contains(e2) || arrayList.contains(e2)) continue;
                Collection collection2 = removeCommand.getCollection();
                collection2.add(e2);
                arrayList.add(e2);
            }
        }
        this.elements.addAll(arrayList);
    }

    protected RemoveCommand getRemoveCommand(Object object) {
        if (this.command instanceof RemoveCommand) {
            if (((RemoveCommand)this.command).getCollection().contains(object)) {
                return (RemoveCommand)this.command;
            }
        } else if (this.command instanceof CompoundCommand) {
            for (Object e : ((CompoundCommand)this.command).getCommandList()) {
                RemoveCommand removeCommand;
                if (!(e instanceof RemoveCommand) || !(removeCommand = (RemoveCommand)e).getCollection().contains(object)) continue;
                return removeCommand;
            }
        }
        return null;
    }

    public void execute() {
        Object object;
        Object object2;
        Object object32;
        Object object4;
        HashSet hashSet;
        this.prepareElements();
        this.notifyPreExecute();
        this.elementsToDeleteContent = new ArrayList();
        this.descriptors = new HashSet();
        Object object5 = this.elements.iterator();
        while (object5.hasNext()) {
            hashSet = TngUtil.unwrap(object5.next());
            if (!(hashSet instanceof MethodElement)) continue;
            this.collectObjectsToDeleteContent(this.elementsToDeleteContent, (MethodElement)hashSet);
        }
        object5 = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                DeleteMethodElementCommand.this.prepareRemovingReferences();
            }
        };
        UserInteractionHelper.runWithProgress((IRunnableWithProgress)object5, LibraryEditResources.processingReferencesTask_name);
        if (!this.confirmRemovingReferences()) {
            return;
        }
        this.modifiedResources = new HashSet<Resource>();
        hashSet = new HashSet();
        this.collectOwnerResources(this.modifiedResources, hashSet);
        this.superExecute();
        this.executeNestedCommands();
        this.collectNestedCommandResources(this.modifiedResources);
        DeleteMethodElementCommand.collectResources(this.modifiedResources, super.getAffectedObjects());
        this.modifiedResources.removeAll(hashSet);
        final Exception[] exceptionArray = new Exception[1];
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    DeleteMethodElementCommand.this.removeReferences();
                }
                catch (Exception exception) {
                    exceptionArray[0] = exception;
                }
            }
        });
        if (exceptionArray[0] != null) {
            Messenger.INSTANCE.showError(LibraryEditResources.deleteDialog_title, LibraryEditResources.deleteElementError_msg, LibraryEditResources.deleteReferencesError_reason, exceptionArray[0]);
            this.undo();
            return;
        }
        this.modifiedResources.addAll(this.getReferencingResources());
        Object object6 = this.elementsToDeleteContent.iterator();
        while (object6.hasNext()) {
            object4 = (EObject)object6.next();
            if (object4.eContainer() == null) continue;
            object6.remove();
        }
        this.elementsToDeleteContent.addAll(this.elements);
        object6 = new HashSet();
        for (Object object32 : this.elementsToDeleteContent) {
            if (!(object32 instanceof EObject)) {
                object32 = TngUtil.unwrap(object32);
            }
            if (!(object32 instanceof EObject)) continue;
            object2 = (EObject)object32;
            UmaUtil.getResources((EObject)object2, (Collection)object6);
        }
        this.modifiedResources.removeAll((Collection<?>)object6);
        object4 = this.modifiedResources.iterator();
        while (object4.hasNext()) {
            object32 = (Resource)object4.next();
            object2 = ((HashSet)object6).iterator();
            while (object2.hasNext()) {
                object = (Resource)object2.next();
                if (!this.getPersister().isContainedBy(object32, object)) continue;
                object4.remove();
            }
        }
        object4 = UserInteractionHelper.checkModify(this.modifiedResources, MsgBox.getDefaultShell());
        if (!object4.isOK()) {
            Messenger.INSTANCE.showError(LibraryEditResources.deleteDialog_title, LibraryEditResources.deleteElementError_msg, (IStatus)object4);
            this.undo();
            return;
        }
        object5 = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                iProgressMonitor.beginTask("", 3);
                DeleteMethodElementCommand.this.getPersister();
                try {
                    iProgressMonitor.subTask(LibraryEditResources.deletingElementsTask_name);
                    iProgressMonitor.worked(1);
                    DeleteMethodElementCommand.this.deleteContent();
                    iProgressMonitor.subTask(LibraryEditResources.savingResources_msg);
                    iProgressMonitor.worked(1);
                    for (Resource resource : DeleteMethodElementCommand.this.modifiedResources) {
                        if (!resource.isLoaded()) continue;
                        DeleteMethodElementCommand.this.persister.save(resource);
                    }
                    DeleteMethodElementCommand.this.persister.commit();
                    DeleteMethodElementCommand.this.executed = true;
                    DeleteMethodElementCommand.this.removeAdapters();
                }
                catch (Exception exception) {
                    LibraryEditPlugin.INSTANCE.log(exception);
                    try {
                        DeleteMethodElementCommand.this.persister.rollback();
                    }
                    catch (Exception exception2) {
                        DeleteMethodElementCommand.this.failed = true;
                    }
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new WrappedException(exception);
                }
            }
        };
        UserInteractionHelper.runWithProgress((IRunnableWithProgress)object5, LibraryEditResources.deletingElementsTask_name);
        if (this.executed) {
            try {
                object32 = this.persister.getWarnings();
                if (!object32.isEmpty()) {
                    object2 = LibraryEditResources.deleteDialog_title;
                    object = LibraryEditResources.DeleteMethodElementCommand_warningMsg;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (Exception exception : object32) {
                        String string = exception.getMessage();
                        if (StrUtil.isBlank((String)string)) continue;
                        stringBuffer.append(string).append('\n');
                    }
                    Messenger.INSTANCE.showWarning((String)object2, (String)object, stringBuffer.toString());
                }
            }
            catch (Exception exception) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
            this.notifyExecuted();
        } else if (this.failed) {
            this.notifyFailure();
        } else {
            this.undo();
        }
    }

    private boolean confirmRemovingReferences() {
        if (!this.elementToRemovedRefsMap.isEmpty()) {
            Status status;
            HashSet<EObject> hashSet = new HashSet<EObject>();
            for (Map<EObject, Collection<EStructuralFeature>> map : this.elementToRemovedRefsMap.values()) {
                for (Map.Entry<EObject, Collection<EStructuralFeature>> entry : map.entrySet()) {
                    status = entry.getValue();
                    boolean bl = false;
                    boolean bl2 = false;
                    for (EStructuralFeature eStructuralFeature : status) {
                        EReference eReference;
                        if (!bl && eStructuralFeature instanceof EReference && ((eReference = (EReference)eStructuralFeature).isContainment() || eReference.getEOpposite() == null)) {
                            bl = true;
                        }
                        if (!(bl2 || eStructuralFeature != UmaPackage.eINSTANCE.getTaskDescriptor_Task() && eStructuralFeature != UmaPackage.eINSTANCE.getRoleDescriptor_Role() && eStructuralFeature != UmaPackage.eINSTANCE.getWorkProductDescriptor_WorkProduct())) {
                            bl2 = true;
                        }
                        if (bl && bl2) break;
                    }
                    if (bl) {
                        hashSet.add(entry.getKey());
                    }
                    if (!bl2 || !(entry.getKey() instanceof Descriptor)) continue;
                    this.descriptors.add((Descriptor)entry.getKey());
                }
            }
            if (this.confirmRemoveReferences) {
                IUserInteractionHandler iUserInteractionHandler;
                Object object;
                MultiStatus multiStatus = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, "", null);
                if (!this.descriptors.isEmpty()) {
                    for (EObject eObject : this.descriptors) {
                        object = NLS.bind((String)LibraryEditResources.elementType_text, (Object)TngUtil.getTypeText(eObject), (Object)TngUtil.getLabelWithPath(eObject));
                        status = new Status(1, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, (String)object, null);
                        multiStatus.add((IStatus)status);
                    }
                    IUserInteractionHandler iUserInteractionHandler2 = ExtensionManager.getDefaultUserInteractionHandler();
                    if (iUserInteractionHandler2 != null) {
                        switch (iUserInteractionHandler2.selectOne(new int[]{4, 5, 1}, LibraryEditResources.confirmDescriptorsDeletion_title, LibraryEditResources.confirmDescriptorsDeletion_msg, (IStatus)multiStatus)) {
                            case 1: {
                                return false;
                            }
                            case 5: {
                                this.descriptors.clear();
                            }
                        }
                    }
                }
                if (!this.descriptors.isEmpty()) {
                    hashSet.removeAll(this.descriptors);
                }
                MultiStatus multiStatus2 = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, "", null);
                for (EObject eObject : hashSet) {
                    if (eObject instanceof MethodElement && TngUtil.isPredefined((MethodElement)eObject)) continue;
                    object = NLS.bind((String)LibraryEditResources.elementType_text, (Object)TngUtil.getTypeText(eObject), (Object)TngUtil.getLabelWithPath(eObject));
                    status = new Status(1, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, (String)object, null);
                    multiStatus2.add((IStatus)status);
                }
                if (multiStatus2.getChildren().length > 0 && (iUserInteractionHandler = ExtensionManager.getDefaultUserInteractionHandler()) != null) {
                    int[] nArray = new int[2];
                    nArray[1] = 1;
                    if (iUserInteractionHandler.selectOne(nArray, LibraryEditResources.deleteReferencesDialog_title, LibraryEditResources.deleteReferencesDialog_text, (IStatus)multiStatus2) == 1) {
                        return false;
                    }
                }
            }
            for (EObject eObject : hashSet) {
                IStatus iStatus = UserInteractionHelper.checkModify(eObject, MsgBox.getDefaultShell());
                if (iStatus.isOK()) continue;
                Messenger.INSTANCE.showError(LibraryEditResources.deleteDialog_title, LibraryEditResources.deleteElementError_msg, iStatus);
                return false;
            }
        }
        return true;
    }

    private static void removeAdapters(EObject eObject) {
        for (Object e : new ArrayList(eObject.eAdapters())) {
            AdapterFactory adapterFactory;
            if (!(e instanceof IStatefulItemProvider)) continue;
            ((IStatefulItemProvider)e).dispose();
            if (!(e instanceof ItemProviderAdapter) || !((adapterFactory = ((ItemProviderAdapter)e).getAdapterFactory()) instanceof IReferencer)) continue;
            ((IReferencer)adapterFactory).remove(e);
        }
        eObject.eAdapters().clear();
    }

    protected void removeAdapters() {
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            EObject eObject;
            Object object = TngUtil.unwrap(iterator.next());
            if (!(object instanceof EObject) || (eObject = (EObject)object).eContainer() != null) continue;
            TreeIterator treeIterator = eObject.eAllContents();
            while (treeIterator.hasNext()) {
                EObject eObject2 = (EObject)treeIterator.next();
                DeleteMethodElementCommand.removeAdapters(eObject2);
            }
            DeleteMethodElementCommand.removeAdapters(eObject);
        }
    }

    private void notifyFailure() {
        EventObject eventObject = new EventObject((Object)this);
        for (CommandListener commandListener : this.commandListeners) {
            commandListener.notifyFailure(eventObject);
        }
    }

    protected ILibraryPersister.FailSafeMethodLibraryPersister getPersister() {
        if (this.persister == null) {
            this.persister = Services.getDefaultLibraryPersister().getFailSafePersister();
        }
        return this.persister;
    }

    private void notifyExecuted() {
        EventObject eventObject = new EventObject((Object)this);
        for (Object object : this.commandListeners) {
            object.notifyExecuted(eventObject);
        }
        List list = Providers.getCommandListeners(DeleteMethodElementCommand.class);
        if (list != null && !list.isEmpty()) {
            Object object;
            object = list.iterator();
            while (object.hasNext()) {
                ICommandListener iCommandListener = (ICommandListener)object.next();
                try {
                    iCommandListener.notifyExecuted((Command)this);
                }
                catch (Exception exception) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        }
    }

    private Collection getReferencingResources() {
        HashSet<EObject> hashSet = new HashSet<EObject>();
        for (Object object : this.removedReferences) {
            hashSet.add(((Reference)object).owner);
        }
        HashSet hashSet2 = new HashSet();
        for (MethodElement methodElement : hashSet) {
            if (methodElement.eResource() == null) continue;
            hashSet2.add(methodElement.eResource());
        }
        return hashSet2;
    }

    private void collectOwnerResources(Set set, Set set2) {
        ILibraryPersister iLibraryPersister = Services.getDefaultLibraryPersister();
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            EObject eObject;
            Resource resource;
            Object object = TngUtil.unwrap(iterator.next());
            if (!(object instanceof MethodElement) || (resource = (eObject = ((MethodElement)object).eContainer()).eResource()) == null) continue;
            if (iLibraryPersister.hasOwnResourceWithoutReferrer(object)) {
                set2.add(resource);
                continue;
            }
            set.add(resource);
        }
    }

    private static void collectResources(Set set, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MethodElement methodElement;
            Object object = TngUtil.unwrap(iterator.next());
            if (!(object instanceof EObject) || (methodElement = (MethodElement)object).eResource() == null) continue;
            set.add(methodElement.eResource());
        }
    }

    public void redo() {
        super.redo();
        this.removeReferences();
    }

    protected void deleteContent() throws Exception {
        ArrayList<MethodElement> arrayList = new ArrayList<MethodElement>();
        Iterator iterator = this.elementsToDeleteContent.iterator();
        while (iterator.hasNext()) {
            MethodElement methodElement;
            Object object = TngUtil.unwrap(iterator.next());
            if (!(object instanceof MethodElement) || (methodElement = (MethodElement)object).eContainer() != null) continue;
            arrayList.add(methodElement);
        }
        this.persister.delete(arrayList);
    }

    public Collection getElementsToRemoveReferences() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Object object = TngUtil.unwrap(iterator.next());
            if (!(object instanceof EObject) || !this.willRemoveElementFromContainer((EObject)object)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    protected boolean canRemoveReferences(MethodElement methodElement) {
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Object object = TngUtil.unwrap(iterator.next());
            if (methodElement != object) continue;
            return methodElement.eContainer() == null;
        }
        return true;
    }

    public List loadOppositeFeatures() {
        HashSet hashSet = new HashSet();
        HashSet<String> hashSet2 = new HashSet<String>();
        ArrayList arrayList = new ArrayList();
        for (Object e : this.getElementsToRemoveReferences()) {
            if (!(e instanceof MethodElement)) continue;
            MethodElement methodElement = (MethodElement)e;
            Object object = methodElement.eAllContents();
            while (object.hasNext()) {
                Object e2 = object.next();
                if (!(e2 instanceof MethodElement)) continue;
                arrayList.add(e2);
                Map map = ((MultiResourceEObject)e2).getOppositeFeatureMap();
                if (map == null || map.isEmpty()) continue;
                hashSet.addAll(map.keySet());
                hashSet2.add(((MethodElement)e2).getGuid());
            }
            arrayList.add(methodElement);
            object = ((MultiResourceEObject)methodElement).getOppositeFeatureMap();
            if (object == null || object.isEmpty()) continue;
            hashSet.addAll(object.keySet());
            hashSet2.add(methodElement.getGuid());
        }
        this.loadOppositeFeatures(new ArrayList(hashSet), hashSet2);
        return arrayList;
    }

    private boolean isContainedByDeletedElement(EObject eObject) {
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Object object = TngUtil.unwrap(iterator.next());
            if (!(object instanceof EObject) || !UmaUtil.isContainedBy((EObject)eObject, (Object)object)) continue;
            return true;
        }
        return false;
    }

    protected boolean collectObjectsToRemove(Collection collection, EObject eObject, EObject eObject2, Collection collection2) {
        boolean bl = false;
        List list = Providers.getCommandListeners(DeleteMethodElementCommand.class);
        if (list != null && !list.isEmpty()) {
            for (Object e : list) {
                if (!(e instanceof IDeleteMethodElementCommandListener)) continue;
                try {
                    boolean bl2 = ((IDeleteMethodElementCommandListener)e).collectObjectsToRemove(collection, eObject, eObject2, collection2);
                    if (!bl2) continue;
                    bl = true;
                }
                catch (Exception exception) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        }
        return bl;
    }

    protected boolean willRemoveElementFromContainer(EObject eObject) {
        if (DeleteMethodElementCommand.willRemoveElementFromContainer(this.command, eObject)) {
            return true;
        }
        if (this.command instanceof CompoundCommand) {
            for (Command command : ((CompoundCommand)this.command).getCommandList()) {
                if (!DeleteMethodElementCommand.willRemoveElementFromContainer(command, eObject)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean willRemoveElementFromContainer(Command command, EObject eObject) {
        if (command instanceof RemoveCommand) {
            RemoveCommand removeCommand = (RemoveCommand)command;
            return removeCommand.getCollection().contains(eObject) && removeCommand.getOwner() == eObject.eContainer();
        }
        return false;
    }

    protected void prepareRemovingReferences() {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        List list = this.loadOppositeFeatures();
        this.elementToRemovedRefsMap = new HashMap<EObject, Map<EObject, Collection<EStructuralFeature>>>();
        HashSet hashSet = new HashSet();
        for (Object object6 : list) {
            object5 = AssociationHelper.getReferenceMap((MethodElement)object6);
            if (object5.isEmpty()) continue;
            object4 = object5.entrySet().iterator();
            while (object4.hasNext()) {
                Collection object7;
                object3 = object4.next();
                object2 = (EObject)object3.getKey();
                boolean bl = this.collectObjectsToRemove(hashSet, (EObject)object6, (EObject)object2, object7 = (Collection)object3.getValue());
                if (!bl && !list.contains(object2) && !this.isContainedByDeletedElement((EObject)object2)) continue;
                object4.remove();
            }
            if (object5.isEmpty()) continue;
            this.elementToRemovedRefsMap.put((EObject)object6, (Map<EObject, Collection<EStructuralFeature>>)object5);
        }
        for (Object object6 : hashSet) {
            object5 = this.elementToRemovedRefsMap.get(object6);
            if (object5 == null) {
                object5 = new HashMap();
                this.elementToRemovedRefsMap.put((EObject)object6, (Map<EObject, Collection<EStructuralFeature>>)object5);
            }
            object4 = object6.eContainer();
            object3 = object6.eContainmentFeature();
            object2 = (Collection)object5.get(object4);
            if (object2 == null) {
                object2 = new ArrayList();
                object2.add(object3);
                object5.put(object4, object2);
                continue;
            }
            if (object2.contains(object3)) continue;
            object2.add(object3);
        }
        for (Object object6 : list) {
            if (!(object6 instanceof EObject)) continue;
            object5 = (EObject)object6;
            object4 = new HashMap();
            object3 = (EContentsEList.FeatureIterator)object5.eCrossReferences().iterator();
            while (object3.hasNext()) {
                object2 = (EObject)object3.next();
                EReference eReference = (EReference)object3.feature();
                if (eReference.getEOpposite() == null) continue;
                ArrayList<EReference> arrayList = (ArrayList<EReference>)object4.get(object2);
                if (arrayList == null) {
                    arrayList = new ArrayList<EReference>();
                    object4.put(object2, arrayList);
                }
                arrayList.add(eReference.getEOpposite());
            }
            object3 = this.elementToRemovedRefsMap.get(object5);
            if (object3 == null) {
                this.elementToRemovedRefsMap.put((EObject)object5, (Map<EObject, Collection<EStructuralFeature>>)object4);
                continue;
            }
            for (Map.Entry entry : object4.entrySet()) {
                Object k = entry.getKey();
                Collection collection = (Collection)entry.getValue();
                Collection collection2 = (Collection)object3.get(k);
                if (collection2 != null) {
                    for (Object e : collection) {
                        if (collection2.contains(e)) continue;
                        collection2.add(e);
                    }
                    continue;
                }
                object3.put(k, collection);
            }
        }
    }

    protected void collectObjectsToDeleteContent(Collection collection, MethodElement methodElement) {
        List list = Providers.getCommandListeners(DeleteMethodElementCommand.class);
        if (list != null && !list.isEmpty()) {
            for (Object e : list) {
                if (!(e instanceof IDeleteMethodElementCommandListener)) continue;
                try {
                    ((IDeleteMethodElementCommandListener)e).collectObjectsToDeleteContent(collection, methodElement);
                }
                catch (Exception exception) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        }
    }

    protected void removeReferences() {
        VariabilityType variabilityType;
        MethodElement methodElement;
        if (this.refRemoved) {
            return;
        }
        if (this.removedReferences == null) {
            this.removedReferences = new ArrayList();
        } else {
            this.removedReferences.clear();
        }
        for (Map.Entry<EObject, Map<EObject, Collection<EStructuralFeature>>> object : this.elementToRemovedRefsMap.entrySet()) {
            methodElement = (MethodElement)object.getKey();
            if (!this.canRemoveReferences(methodElement)) continue;
            variabilityType = object.getValue();
            for (Map.Entry<EObject, Collection<EStructuralFeature>> entry : variabilityType.entrySet()) {
                EObject eObject = entry.getKey();
                Collection<EStructuralFeature> collection = entry.getValue();
                block2: for (EStructuralFeature eStructuralFeature : collection) {
                    if (eStructuralFeature.isMany()) {
                        List list = (List)eObject.eGet(eStructuralFeature);
                        int n = list.indexOf(methodElement);
                        if (n != -1) {
                            list.remove(n);
                            this.removedReferences.add(new Reference(eObject, eStructuralFeature, methodElement, n));
                            continue;
                        }
                        if (TngUtil.DEBUG) {
                            System.out.println("DeleteMethodElementCommand.removeReferences(): index=" + n + ", size=" + list.size() + ", referencer=" + eObject + ", referenced=" + methodElement + ", feature=" + eStructuralFeature);
                        }
                        String string = methodElement.getGuid();
                        int n2 = 0;
                        while (n2 < list.size()) {
                            InternalEObject internalEObject = (InternalEObject)list.get(n2);
                            URI uRI = internalEObject.eProxyURI();
                            if (uRI != null && string.equals(uRI.fragment())) {
                                list.remove(n2);
                                this.removedReferences.add(new Reference(eObject, eStructuralFeature, methodElement, n2));
                                continue block2;
                            }
                            ++n2;
                        }
                        continue;
                    }
                    eObject.eSet(eStructuralFeature, null);
                    this.removedReferences.add(new Reference(eObject, eStructuralFeature, methodElement, -1));
                }
            }
        }
        if (TngUtil.DEBUG) {
            System.out.println("removedReferences: size=" + this.removedReferences.size());
        }
        this.batchCommand.getObjectToNewFeatureValuesMap().clear();
        for (Reference reference : this.removedReferences) {
            if (reference.getFeature() != UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_BASED_ON_ELEMENT) continue;
            this.batchCommand.addFeatureValue(reference.getOwner(), (EStructuralFeature)UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_TYPE, UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_TYPE.getDefaultValue());
            if (!(reference.getOwner() instanceof Activity) || (variabilityType = (methodElement = (Activity)reference.getOwner()).getVariabilityType()) != VariabilityType.EXTENDS_LITERAL && variabilityType != VariabilityType.LOCAL_CONTRIBUTION_LITERAL || !StrUtil.isNull((String)methodElement.getPresentationName())) continue;
            Activity activity = (Activity)reference.getValue();
            this.batchCommand.addFeatureValue((EObject)methodElement, (EStructuralFeature)UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION_NAME, ProcessUtil.getPresentationName((BreakdownElement)activity));
        }
        if (this.batchCommand.canExecute()) {
            this.batchCommand.execute();
        }
        this.refRemoved = true;
    }

    protected void loadOppositeFeatures(List list, Set set) {
    }

    protected static void restoreReferences(List list) {
        int n = list.size() - 1;
        while (n > -1) {
            Reference reference = (Reference)list.get(n);
            if (reference.feature.isMany()) {
                List list2 = (List)reference.owner.eGet(reference.feature);
                if (reference.index != -1) {
                    if (!list2.contains(reference.value)) {
                        if (reference.index < list2.size()) {
                            list2.add(reference.index, reference.value);
                        } else {
                            if (TngUtil.DEBUG) {
                                System.out.println("DeleteMethodElementCommand.removeReferences(): index=" + reference.index + ", size=" + list2.size() + ", referencer=" + reference.owner + ", referenced=" + reference.value + ", feature=" + reference.feature);
                            }
                            list2.add(reference.value);
                        }
                    } else if (TngUtil.DEBUG) {
                        System.out.println("DeleteMethodElementCommand.removeReferences(): reference already exists: referencer=" + reference.owner + ", referenced=" + reference.value + ", feature=" + reference.feature);
                    }
                } else {
                    list2.add(reference.value);
                }
            } else {
                reference.owner.eSet(reference.feature, reference.value);
            }
            --n;
        }
    }

    protected void restoreReferences() {
        if (!this.refRemoved) {
            return;
        }
        this.batchCommand.undo();
        DeleteMethodElementCommand.restoreReferences(this.removedReferences);
        this.refRemoved = false;
    }

    public void undo() {
        this.notifyPreUndo();
        try {
            super.undo();
            this.restoreReferences();
        }
        catch (Exception exception) {
            LibraryEditPlugin.INSTANCE.log(exception);
            this.notifyFailure();
        }
    }

    public Collection getAffectedObjects() {
        if (this.executed) {
            return super.getAffectedObjects();
        }
        return this.elements;
    }

    public void addCommandListener(CommandListener commandListener) {
        if (!this.commandListeners.contains(commandListener)) {
            this.commandListeners.add(commandListener);
        }
    }

    public void removeCommandListener(CommandListener commandListener) {
        this.commandListeners.remove(commandListener);
    }

    protected void executeNestedCommands() {
        List<INestedCommandProvider> list = ExtensionManager.getNestedCommandProviders();
        if (!list.isEmpty() && !this.elements.isEmpty()) {
            this.nestedCommands = new ArrayList();
            for (INestedCommandProvider iNestedCommandProvider : list) {
                try {
                    Command command = iNestedCommandProvider.removeRelatedObjects(this.elements, (Command)this);
                    if (command == null || !command.canExecute()) continue;
                    command.execute();
                    this.nestedCommands.add(command);
                }
                catch (Exception exception) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        }
    }

    private void collectNestedCommandResources(Set<Resource> set) {
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int n = this.nestedCommands.size() - 1;
            while (n > -1) {
                Command command = this.nestedCommands.get(n);
                try {
                    Collection<Resource> collection;
                    if (command instanceof IResourceAwareCommand && (collection = ((IResourceAwareCommand)command).getModifiedResources()) != null) {
                        set.addAll(collection);
                    }
                }
                catch (Exception exception) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
                --n;
            }
        }
    }

    public Collection<Descriptor> getDescriptorsToDelete() {
        return this.descriptors;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public static interface CommandListener {
        public void notifyExecuted(EventObject var1);

        public void notifyFailure(EventObject var1);
    }
}

