/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.uma.MethodConfiguration;

public class MoveInConfigurationCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private MethodConfiguration config;
    private EStructuralFeature feature;
    private List elementsList;
    private Collection modifiedResources;
    private static int UP = 1;
    private static int Down = 0;
    private int direction = -1;
    private boolean moved;

    public MoveInConfigurationCommand(MethodConfiguration methodConfiguration, List list, EStructuralFeature eStructuralFeature, int n) {
        this.config = methodConfiguration;
        this.feature = eStructuralFeature;
        this.elementsList = list;
        this.direction = n;
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }

    public void execute() {
        this.modifiedResources = new HashSet();
        this.redo();
    }

    public void redo() {
        if (this.config == null) {
            return;
        }
        for (Object e : this.elementsList) {
            if (this.feature.isMany()) {
                EList eList = (EList)this.config.eGet(this.feature);
                int n = eList.indexOf(e);
                if (this.direction == UP) {
                    if (n > 0) {
                        eList.move(n - 1, e);
                    }
                } else if (this.direction == Down && n < eList.size()) {
                    eList.move(n + this.elementsList.size(), e);
                }
                this.moved = true;
                continue;
            }
            this.config.eSet(this.feature, null);
        }
        if (this.config.eResource() != null) {
            this.modifiedResources.add(this.config.eResource());
        }
    }

    public void undo() {
        if (this.moved) {
            for (Object e : this.elementsList) {
                if (this.feature.isMany()) {
                    EList eList = (EList)this.config.eGet(this.feature);
                    int n = eList.indexOf(e);
                    if (this.direction == UP) {
                        if (n < eList.size()) {
                            eList.move(n + this.elementsList.size(), e);
                        }
                    } else if (this.direction == Down && n > 0) {
                        eList.move(n - 1, e);
                    }
                    this.moved = true;
                    continue;
                }
                this.config.eSet(this.feature, e);
            }
            this.moved = false;
        }
    }

    public Collection getAffectedObjects() {
        return Collections.singletonList(this.config);
    }
}

