/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.INestedCommandProvider;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.ExtensionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedCommandExcecutor {
    private Command command;
    private ArrayList<Command> nestedCommands;

    public NestedCommandExcecutor(Command command) {
        this.command = command;
    }

    public List<Command> getNestedCommands() {
        if (this.nestedCommands == null) {
            this.nestedCommands = new ArrayList();
        }
        return this.nestedCommands;
    }

    public void executeNestedCommands() {
        List<INestedCommandProvider> list = ExtensionManager.getNestedCommandProviders();
        if (!list.isEmpty()) {
            for (INestedCommandProvider iNestedCommandProvider : list) {
                try {
                    Command command = iNestedCommandProvider.createNestedCommand(this.command);
                    if (command == null || !command.canExecute()) continue;
                    command.execute();
                    this.getNestedCommands().add(command);
                }
                catch (Exception exception) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        }
    }

    public void undoNestedCommands() {
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int n = this.nestedCommands.size() - 1;
            while (n > -1) {
                block14: {
                    Command command = this.nestedCommands.get(n);
                    try {
                        try {
                            if (command.canUndo()) {
                                command.undo();
                            }
                        }
                        catch (Exception exception) {
                            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                            try {
                                command.dispose();
                            }
                            catch (Exception exception2) {}
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            command.dispose();
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        command.dispose();
                    }
                    catch (Exception exception) {}
                }
                --n;
            }
            this.nestedCommands.clear();
        }
    }

    public void dispose() {
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int n = this.nestedCommands.size() - 1;
            while (n > -1) {
                Command command = this.nestedCommands.get(n);
                try {
                    command.dispose();
                }
                catch (Exception exception) {}
                --n;
            }
            this.nestedCommands.clear();
        }
    }

    public Collection<Resource> getModifiedResources() {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int n = this.nestedCommands.size() - 1;
            while (n > -1) {
                Command command = this.nestedCommands.get(n);
                if (command instanceof IResourceAwareCommand) {
                    try {
                        Collection<Resource> collection = ((IResourceAwareCommand)command).getModifiedResources();
                        if (collection != null) {
                            hashSet.addAll(collection);
                        }
                    }
                    catch (Exception exception) {
                        LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                    }
                }
                --n;
            }
        }
        return hashSet.isEmpty() ? Collections.EMPTY_SET : hashSet;
    }
}

