/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveReferencesCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private MethodPlugin plugin;
    private MethodPlugin base;
    private Map<FeatureValuePair, Object> featureValuePairToObjectMap;
    private Collection<Resource> modifiedResources;

    public RemoveReferencesCommand(MethodPlugin methodPlugin, MethodPlugin methodPlugin2) {
        this.plugin = methodPlugin;
        this.base = methodPlugin2;
    }

    protected boolean prepare() {
        return true;
    }

    @Override
    public Collection<Resource> getModifiedResources() {
        return this.modifiedResources;
    }

    public void execute() {
        EStructuralFeature eStructuralFeature;
        EObject eObject;
        this.featureValuePairToObjectMap = new HashMap<FeatureValuePair, Object>();
        this.modifiedResources = new HashSet<Resource>();
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)this.plugin.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            eObject = (EObject)featureIterator.next();
            eStructuralFeature = featureIterator.feature();
            if (eStructuralFeature == UmaPackage.eINSTANCE.getMethodPlugin_Bases() || UmaUtil.getMethodPlugin((EObject)eObject) != this.base) continue;
            this.featureValuePairToObjectMap.put(new FeatureValuePair(eStructuralFeature, eObject), this.plugin);
        }
        featureIterator = this.plugin.eAllContents();
        while (featureIterator.hasNext()) {
            eObject = (EObject)featureIterator.next();
            if (eObject instanceof ProcessElement) continue;
            eStructuralFeature = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
            while (eStructuralFeature.hasNext()) {
                EObject eObject2 = (EObject)eStructuralFeature.next();
                if (UmaUtil.getMethodPlugin((EObject)eObject2) != this.base) continue;
                EStructuralFeature eStructuralFeature2 = eStructuralFeature.feature();
                this.featureValuePairToObjectMap.put(new FeatureValuePair(eStructuralFeature2, eObject2), eObject);
                if (eStructuralFeature2 != UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_BASED_ON_ELEMENT) continue;
                EAttribute eAttribute = UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_TYPE;
                this.featureValuePairToObjectMap.put(new FeatureValuePair((EStructuralFeature)eAttribute, eObject.eGet((EStructuralFeature)eAttribute)), eObject);
            }
        }
        this.redo();
    }

    public void redo() {
        for (Map.Entry<FeatureValuePair, Object> entry : this.featureValuePairToObjectMap.entrySet()) {
            FeatureValuePair featureValuePair = entry.getKey();
            EObject eObject = (EObject)entry.getValue();
            if (featureValuePair.feature.isMany()) {
                ((Collection)eObject.eGet(featureValuePair.feature)).remove(featureValuePair.value);
            } else {
                eObject.eSet(featureValuePair.feature, null);
            }
            if (eObject.eResource() == null) continue;
            this.modifiedResources.add(eObject.eResource());
        }
    }

    public void undo() {
        for (Map.Entry<FeatureValuePair, Object> entry : this.featureValuePairToObjectMap.entrySet()) {
            FeatureValuePair featureValuePair = entry.getKey();
            EObject eObject = (EObject)entry.getValue();
            if (featureValuePair.feature.isMany()) {
                ((Collection)eObject.eGet(featureValuePair.feature)).add(featureValuePair.value);
                continue;
            }
            eObject.eSet(featureValuePair.feature, featureValuePair.value);
        }
    }

    public void dispose() {
        this.plugin = null;
        this.base = null;
        if (this.featureValuePairToObjectMap != null) {
            this.featureValuePairToObjectMap.clear();
        }
        if (this.modifiedResources != null) {
            this.modifiedResources.clear();
        }
        super.dispose();
    }

    private static class FeatureValuePair {
        EStructuralFeature feature;
        Object value;

        FeatureValuePair(EStructuralFeature eStructuralFeature, Object object) {
            this.feature = eStructuralFeature;
            this.value = object;
        }
    }
}

