/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.TeamProfile;

public class DeleteTeamProfile
extends AbstractCommand
implements IResourceAwareCommand {
    private Activity activity;
    private TeamProfile team;
    private Collection modifiedResources;

    public DeleteTeamProfile(TeamProfile teamProfile) {
        this.team = teamProfile;
        Object object = this.getParentActivity((BreakdownElement)teamProfile);
        if (object instanceof Activity) {
            this.activity = (Activity)object;
        }
        this.modifiedResources = new HashSet();
        if (this.activity.eResource() != null) {
            this.modifiedResources.add(this.activity.eResource());
        }
        if (teamProfile.eResource() != null) {
            this.modifiedResources.add(teamProfile.eResource());
        }
    }

    public void execute() {
        ArrayList<TeamProfile> arrayList = new ArrayList<TeamProfile>();
        this.getSubTeams(this.team, arrayList);
        arrayList.add(this.team);
        int n = 0;
        while (n < arrayList.size()) {
            TeamProfile teamProfile = (TeamProfile)arrayList.get(n);
            teamProfile.getTeamRoles().clear();
            ++n;
        }
        this.redo();
    }

    private void getSubTeams(TeamProfile teamProfile, List list) {
        List list2 = teamProfile.getSubTeam();
        if (list2 != null) {
            for (TeamProfile teamProfile2 : list2) {
                list.add(teamProfile2);
                this.getSubTeams(teamProfile2, list);
            }
        }
    }

    private Object getParentActivity(BreakdownElement breakdownElement) {
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
        Object object = itemProviderAdapter.getParent((Object)breakdownElement);
        while (!(object instanceof Activity)) {
            breakdownElement = (BreakdownElement)object;
            itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
            object = itemProviderAdapter.getParent((Object)breakdownElement);
        }
        return object;
    }

    public void redo() {
    }

    public void undo() {
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }
}

