/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.UmaUtil;

public class ProcessElementDeleteCommand
extends DeleteMethodElementCommand {
    private Set contentsToRemove;
    private ArrayList elementsToRemoveReferences;
    private boolean ownedElementsIncluded;

    public ProcessElementDeleteCommand(Command command, Collection collection) {
        super(command, collection);
    }

    public ProcessElementDeleteCommand(Command command, Collection collection, boolean bl) {
        super(command, collection, bl);
    }

    public void execute() {
        if (!this.ownedElementsIncluded) {
            Collection collection = this.getOwnedElements(this.elements);
            if (!collection.isEmpty()) {
                this.includeElements(collection);
            }
            this.ownedElementsIncluded = true;
        }
        super.execute();
    }

    protected Collection getOwnedElements(Collection collection) {
        ArrayList arrayList = new ArrayList();
        for (Object e : collection) {
            WorkProductDescriptor workProductDescriptor;
            WorkProduct workProduct;
            if (!(e instanceof WorkProductDescriptor) || !((workProduct = (workProductDescriptor = (WorkProductDescriptor)e).getWorkProduct()) instanceof Artifact)) continue;
            AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(workProduct, false){
                private static final long serialVersionUID = 422181782268878289L;

                protected Iterator getChildren(Object object) {
                    return ((Artifact)object).getContainedArtifacts().iterator();
                }
            };
            HashSet hashSet = new HashSet();
            while (abstractTreeIterator.hasNext()) {
                hashSet.add(abstractTreeIterator.next());
            }
            Activity activity = UmaUtil.getParentActivity((BreakdownElement)workProductDescriptor);
            for (Object e2 : activity.getBreakdownElements()) {
                if (!(e2 instanceof WorkProductDescriptor) || !hashSet.contains(((WorkProductDescriptor)e2).getWorkProduct())) continue;
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    protected void excludeElements(Collection collection) {
        this.elements.removeAll(collection);
        for (Object e : collection) {
            RemoveCommand removeCommand = this.getRemoveCommand(e);
            if (removeCommand == null) continue;
            removeCommand.getCollection().remove(e);
        }
    }

    protected void includeElements(Collection collection) {
        for (Object e : collection) {
            Collection collection2;
            if (this.elements.contains(e)) continue;
            this.elements.add(e);
            RemoveCommand removeCommand = this.getRemoveCommand(e);
            if (removeCommand == null || (collection2 = removeCommand.getCollection()).contains(e)) continue;
            collection2.add(e);
        }
    }

    public Collection getElementsToRemoveReferences() {
        if (this.elementsToRemoveReferences == null) {
            this.elementsToRemoveReferences = new ArrayList();
            for (Object e : this.elements) {
                if (e instanceof Activity) {
                    EObject eObject = ((Activity)e).eContainer();
                    if (eObject != null) {
                        this.elementsToRemoveReferences.add(eObject);
                        continue;
                    }
                    this.elementsToRemoveReferences.add(e);
                    continue;
                }
                this.elementsToRemoveReferences.add(e);
            }
        }
        return this.elementsToRemoveReferences;
    }

    protected boolean canRemoveReferences(MethodElement methodElement) {
        return true;
    }

    protected void removeReferences() {
        this.contentsToRemove = new HashSet();
        for (Object e : this.elements) {
            if (!(e instanceof EObject)) continue;
            EObject eObject = (EObject)e;
            if (e instanceof Activity) {
                EObject eObject2;
                Activity activity = (Activity)e;
                if (ContentDescriptionFactory.hasPresentation((MethodElement)activity)) {
                    this.contentsToRemove.add(activity.getPresentation());
                }
                if ((eObject2 = eObject.eContainer()) == null) continue;
                EcoreUtil.remove((EObject)eObject2);
                TreeIterator treeIterator = eObject2.eAllContents();
                while (treeIterator.hasNext()) {
                    Object e2 = treeIterator.next();
                    if (!(e2 instanceof Activity) || !ContentDescriptionFactory.hasPresentation((MethodElement)(activity = (Activity)e2))) continue;
                    this.contentsToRemove.add(activity.getPresentation());
                }
                continue;
            }
            EcoreUtil.remove((EObject)((EObject)e));
        }
        super.removeReferences();
    }

    protected void deleteContent() throws Exception {
        Iterator iterator = this.contentsToRemove.iterator();
        while (iterator.hasNext()) {
            EcoreUtil.remove((EObject)((EObject)iterator.next()));
        }
        this.elementsToDeleteContent.addAll(this.contentsToRemove);
        super.deleteContent();
    }

    protected boolean collectObjectsToRemove(Collection collection, EObject eObject, EObject eObject2, Collection collection2) {
        boolean bl = super.collectObjectsToRemove(collection, eObject, eObject2, collection2);
        for (EReference eReference : collection2) {
            EObject eObject3;
            if (eReference != UmaPackage.eINSTANCE.getUMASemanticModelBridge_Element() || (eObject3 = eObject2.eContainer()) == null || eObject3.eContainer() == null) continue;
            collection.add(eObject3);
            bl = true;
        }
        return bl;
    }

    public void dispose() {
        if (this.contentsToRemove != null) {
            this.contentsToRemove.clear();
        }
        if (this.elementsToRemoveReferences != null) {
            this.elementsToRemoveReferences.clear();
        }
        super.dispose();
    }
}

