/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.BatchCommand;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.BasicSynchronizeDescriptorCommand;
import org.eclipse.epf.library.edit.process.command.DeleteUnusedDescriptorsCommand;
import org.eclipse.epf.library.edit.process.command.OBSDropCommand;
import org.eclipse.epf.library.edit.process.command.PBSDropCommand;
import org.eclipse.epf.library.edit.process.command.ProcessElementDeleteCommand;
import org.eclipse.epf.library.edit.process.command.SynchronizeDeliverableDescriptorCommand;
import org.eclipse.epf.library.edit.process.command.WBSDropCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.Messenger;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class SynchronizeCommand
extends CompoundCommand
implements IResourceAwareCommand {
    private Collection elements;
    private IConfigurator configurator;
    protected boolean aborted;
    private ArrayList deleteList;
    protected boolean preExecSuccessful;
    protected List deleteCommandList;
    protected boolean successful;
    private MethodConfiguration config;
    private Set synchFeatures;
    private DeleteUnusedDescriptorsCommand deleteUnusedDescriptorsCommand;
    private Collection activities;
    private boolean showSuccessfulMsg = true;
    private boolean intialized;
    private BatchCommand batchCommand = new BatchCommand(false);
    private Map<VariabilityElement, VariabilityElement> replacerToBaseMap = new HashMap<VariabilityElement, VariabilityElement>();

    public SynchronizeCommand(String string, Collection collection) {
        super(string);
        this.elements = collection;
    }

    public SynchronizeCommand(Collection collection, MethodConfiguration methodConfiguration, Set set, boolean bl) {
        super(LibraryEditResources.AutoSynchronizeCommand_label);
        this.elements = collection;
        this.config = methodConfiguration;
        this.synchFeatures = set;
        this.showSuccessfulMsg = bl;
    }

    public void setMethodConfiguration(MethodConfiguration methodConfiguration) {
        this.config = methodConfiguration;
        if (this.configurator != null) {
            this.configurator.setMethodConfiguration(methodConfiguration);
        }
    }

    public void setSynchronizationFeatures(Set set) {
        this.synchFeatures = set;
    }

    private boolean doInitialize() {
        this.commandList.clear();
        if (this.elements == null || this.elements.isEmpty()) {
            return false;
        }
        this.deleteCommandList = new ArrayList();
        this.deleteList = new ArrayList();
        this.activities = new ArrayList();
        for (Object e : this.elements) {
            this.addToDeleteList(e, this.deleteList);
            if (!(e instanceof Activity)) continue;
            this.activities.add(e);
        }
        this.elements.removeAll(this.deleteList);
        for (Object e : this.elements) {
            if (e instanceof Descriptor) {
                Task task;
                Descriptor descriptor = (Descriptor)e;
                if (!descriptor.getIsSynchronizedWithSource().booleanValue() || this.deleteList.contains(descriptor)) continue;
                if (descriptor.getSuperActivities() == null) {
                    if (descriptor instanceof WorkProductDescriptor && ((WorkProductDescriptor)descriptor).getWorkProduct() instanceof Deliverable) {
                        this.append(new SynchronizeDeliverableDescriptorCommand((WorkProductDescriptor)descriptor, this.synchFeatures, this.config));
                        continue;
                    }
                    this.append(new BasicSynchronizeDescriptorCommand(descriptor, this.synchFeatures, this.config));
                    continue;
                }
                Activity activity = descriptor.getSuperActivities();
                if (e instanceof TaskDescriptor) {
                    task = ((TaskDescriptor)e).getTask();
                    if (task == null) continue;
                    if (this.replacerToBaseMap.containsKey(task)) {
                        task = (Task)this.replacerToBaseMap.get(task);
                    }
                    this.append(new WBSDropCommand(activity, Collections.singletonList(task), this.config, this.synchFeatures));
                    continue;
                }
                if (e instanceof RoleDescriptor) {
                    task = ((RoleDescriptor)e).getRole();
                    if (task == null) continue;
                    if (this.replacerToBaseMap.containsKey(task)) {
                        task = (Role)this.replacerToBaseMap.get(task);
                    }
                    this.append(new OBSDropCommand(activity, Collections.singletonList(task), this.config, this.synchFeatures, this.configurator));
                    continue;
                }
                if (!(e instanceof WorkProductDescriptor) || (task = ((WorkProductDescriptor)e).getWorkProduct()) == null) continue;
                if (this.replacerToBaseMap.containsKey(task)) {
                    task = (WorkProduct)this.replacerToBaseMap.get(task);
                }
                this.append(new PBSDropCommand(activity, Collections.singletonList(task), this.config, this.synchFeatures, this.configurator));
                continue;
            }
            if (e instanceof Activity) {
                this.appendCommands((Activity)e);
                continue;
            }
            if (!(e instanceof TeamProfile)) continue;
            this.appendCommands((TeamProfile)e);
        }
        return !this.deleteList.isEmpty() || !this.commandList.isEmpty() || !this.activities.isEmpty();
    }

    public boolean initilize() {
        boolean bl = this.isPrepared;
        try {
            this.isPrepared = false;
            boolean bl2 = this.intialized = this.doInitialize();
            return bl2;
        }
        finally {
            this.isPrepared = bl;
        }
    }

    public boolean isIntialized() {
        return this.intialized;
    }

    private void appendCommands(Activity activity) {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        ArrayList<Task> arrayList2 = new ArrayList<Task>();
        ArrayList<Task> arrayList3 = new ArrayList<Task>();
        ArrayList arrayList4 = new ArrayList();
        for (Object e : activity.getBreakdownElements()) {
            if (e instanceof Descriptor) {
                Task task;
                if (!((Descriptor)e).getIsSynchronizedWithSource().booleanValue() || this.deleteList.contains(e)) continue;
                if (e instanceof TaskDescriptor) {
                    task = ((TaskDescriptor)e).getTask();
                    if (task == null) continue;
                    if (this.replacerToBaseMap.containsKey(task)) {
                        task = (Task)this.replacerToBaseMap.get(task);
                    }
                    arrayList.add(task);
                    continue;
                }
                if (e instanceof RoleDescriptor) {
                    task = ((RoleDescriptor)e).getRole();
                    if (task == null) continue;
                    if (this.replacerToBaseMap.containsKey(task)) {
                        task = (Role)this.replacerToBaseMap.get(task);
                    }
                    arrayList2.add(task);
                    continue;
                }
                if (!(e instanceof WorkProductDescriptor) || (task = ((WorkProductDescriptor)e).getWorkProduct()) == null) continue;
                if (this.replacerToBaseMap.containsKey(task)) {
                    task = (WorkProduct)this.replacerToBaseMap.get(task);
                }
                arrayList3.add(task);
                continue;
            }
            if (e instanceof Activity) {
                arrayList4.add(e);
                continue;
            }
            if (!(e instanceof TeamProfile)) continue;
            this.appendCommands((TeamProfile)e);
        }
        if (!arrayList.isEmpty()) {
            this.append(new WBSDropCommand(activity, arrayList, this.config, this.synchFeatures));
        }
        if (!arrayList2.isEmpty()) {
            this.append(new OBSDropCommand(activity, arrayList2, this.config, this.synchFeatures, this.configurator));
        }
        if (!arrayList3.isEmpty()) {
            this.append(new PBSDropCommand(activity, arrayList3, this.config, this.synchFeatures, this.configurator));
        }
        Iterator iterator = arrayList4.iterator();
        while (iterator.hasNext()) {
            this.appendCommands((Activity)iterator.next());
        }
    }

    private void appendCommands(TeamProfile teamProfile) {
        AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(teamProfile, false){
            private static final long serialVersionUID = 1L;

            protected Iterator getChildren(Object object) {
                if (object instanceof TeamProfile) {
                    TeamProfile teamProfile = (TeamProfile)object;
                    ArrayList arrayList = new ArrayList(teamProfile.getSubTeam());
                    arrayList.addAll(teamProfile.getTeamRoles());
                    return arrayList.iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (abstractTreeIterator.hasNext()) {
            Object e = abstractTreeIterator.next();
            if (!(e instanceof RoleDescriptor) || ((RoleDescriptor)e).getSuperActivities() != null) continue;
            this.append(new BasicSynchronizeDescriptorCommand((Descriptor)e, this.synchFeatures, this.config));
        }
    }

    public Collection getModifiedResources() {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        for (Object e : this.commandList) {
            if (!(e instanceof IResourceAwareCommand)) continue;
            hashSet.addAll(((IResourceAwareCommand)e).getModifiedResources());
        }
        return hashSet;
    }

    public void execute() {
        Object object;
        if (!this.deleteList.isEmpty() && (object = this.delete(this.deleteList)) != null) {
            this.deleteCommandList.add(object);
        }
        this.batchCommand.execute();
        if (!this.aborted) {
            object = new Runnable(){

                public void run() {
                    SynchronizeCommand.this.preExecSuccessful = SynchronizeCommand.this.preExecute();
                    if (SynchronizeCommand.this.preExecute()) {
                        SynchronizeCommand.this.superRedo();
                        SynchronizeCommand.this.successful = true;
                    }
                }
            };
            UserInteractionHelper.runInUI((Runnable)object, this.getLabel());
            if (this.successful) {
                if (!this.activities.isEmpty()) {
                    if (this.deleteUnusedDescriptorsCommand == null) {
                        this.deleteUnusedDescriptorsCommand = new DeleteUnusedDescriptorsCommand(this.elements, true, this.deleteList){

                            protected Command delete(List list) {
                                return SynchronizeCommand.this.delete(list);
                            }
                        };
                        this.deleteCommandList.add(this.deleteUnusedDescriptorsCommand);
                    }
                    this.deleteUnusedDescriptorsCommand.execute();
                }
                if (this.showSuccessfulMsg) {
                    if (!this.replacerToBaseMap.isEmpty()) {
                        this.refreshViewer();
                    }
                    Messenger.INSTANCE.showInfo(LibraryEditResources.SynchronizeCompleteDialog_Title, LibraryEditResources.AutoSynchronizeCommand_sucessful);
                }
            }
        }
    }

    private void refreshViewer() {
        if (this.elements.isEmpty()) {
            return;
        }
        Process process = TngUtil.getOwningProcess(this.elements.iterator().next());
        if (process != null) {
            int n = 0;
            while (n < TngAdapterFactory.processAdapterFactories.length) {
                AdapterFactory adapterFactory = TngAdapterFactory.processAdapterFactories[n];
                ProcessUtil.refreshViewer(adapterFactory, process);
                ++n;
            }
        }
    }

    private void superRedo() {
        super.redo();
    }

    public void redo() {
        this.execute();
    }

    public boolean isSucessful() {
        return this.successful;
    }

    protected boolean preExecute() {
        ListIterator listIterator = this.commandList.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (e instanceof BSDropCommand && !((BSDropCommand)e).preExecute()) {
                return false;
            }
            Thread.yield();
        }
        return true;
    }

    protected Command delete(List list) {
        AdapterFactoryEditingDomain adapterFactoryEditingDomain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
        ProcessElementDeleteCommand processElementDeleteCommand = new ProcessElementDeleteCommand(RemoveCommand.create((EditingDomain)adapterFactoryEditingDomain, (Collection)list), list);
        processElementDeleteCommand.execute();
        return processElementDeleteCommand;
    }

    private IConfigurator getConfigurator() {
        if (this.configurator == null) {
            MethodConfiguration methodConfiguration = this.config;
            if (methodConfiguration == null) {
                Process process = TngUtil.getOwningProcess((BreakdownElement)this.elements.iterator().next());
                methodConfiguration = process.getDefaultContext();
            }
            this.configurator = Providers.getConfiguratorFactory().createConfigurator(methodConfiguration);
        }
        return this.configurator;
    }

    private void addToDeleteList(Object object, List list) {
        if (object instanceof Descriptor) {
            if (!this.getConfigurator().accept(object)) {
                MethodElement methodElement = ProcessUtil.getAssociatedElement((Descriptor)object);
                if (methodElement instanceof VariabilityElement && TngUtil.isReplacer((VariabilityElement)methodElement)) {
                    VariabilityElement variabilityElement = ((VariabilityElement)methodElement).getVariabilityBasedOnElement();
                    while (variabilityElement != null && TngUtil.isContributorOrReplacer(variabilityElement)) {
                        variabilityElement = variabilityElement.getVariabilityBasedOnElement();
                    }
                    if (variabilityElement != null) {
                        if (!this.getConfigurator().accept(variabilityElement)) {
                            list.add(object);
                        } else {
                            this.batchCommand.addFeatureValue((EObject)object, (EStructuralFeature)ProcessUtil.getLinkReference((Descriptor)object), variabilityElement);
                            this.replacerToBaseMap.put((VariabilityElement)methodElement, variabilityElement);
                        }
                    }
                } else {
                    list.add(object);
                }
            }
        } else if (object instanceof Activity) {
            Iterator iterator = ((Activity)object).getBreakdownElements().iterator();
            while (iterator.hasNext()) {
                this.addToDeleteList(iterator.next(), list);
            }
        }
    }

    private void superUndo() {
        super.undo();
    }

    public void undo() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                if (!SynchronizeCommand.this.deleteCommandList.isEmpty()) {
                    ListIterator listIterator = SynchronizeCommand.this.deleteCommandList.listIterator(SynchronizeCommand.this.deleteCommandList.size());
                    while (listIterator.hasPrevious()) {
                        try {
                            Command command = (Command)listIterator.previous();
                            command.undo();
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            listIterator.next();
                            try {
                                while (listIterator.hasNext()) {
                                    Command command = (Command)listIterator.next();
                                    command.redo();
                                }
                            }
                            catch (RuntimeException runtimeException2) {
                                CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)runtimeException2).fillInStackTrace());
                            }
                        }
                        throw runtimeException;
                    }
                }
                SynchronizeCommand.this.superUndo();
                SynchronizeCommand.this.batchCommand.undo();
            }
        });
    }

    protected boolean prepare() {
        return true;
    }

    public void dispose() {
        if (this.activities != null) {
            this.activities.clear();
        }
        if (this.deleteCommandList != null) {
            for (Command command : this.deleteCommandList) {
                command.dispose();
            }
        }
        if (this.deleteList != null) {
            this.deleteList.clear();
        }
        super.dispose();
    }
}

