/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.model.ModelFactory;
import org.eclipse.epf.library.edit.util.model.OrderInfo;
import org.eclipse.epf.library.edit.util.model.OrderInfoCollection;
import org.eclipse.epf.library.edit.util.model.util.StringResource;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;

public class ContentElementOrderList
extends BasicEList {
    private static final long serialVersionUID = 3257572797487069233L;
    public static final String ORDER_INFO_NAME = "content elements";
    private static final Map DEFAULT_SAVE_OPTIONS = new HashMap();
    public static final int CONTENT_ELEMENTS__FOR_ELEMENT_ONLY = 1;
    public static final int CONTENT_ELEMENTS__FOR_ELEMENT_AND_PARENTS = 2;
    private ContentElement editElement;
    private boolean mixed = true;
    private boolean changed = false;
    private EStructuralFeature feature;

    static {
        DEFAULT_SAVE_OPTIONS.put("ENCODING", "ASCII");
    }

    private static boolean isContributor(VariabilityElement variabilityElement) {
        return TngUtil.isContributor(variabilityElement);
    }

    public ContentElementOrderList(ContentElement contentElement, int n, EStructuralFeature eStructuralFeature) {
        this.feature = eStructuralFeature;
        this.editElement = contentElement;
        if (n == 1) {
            this.mixed = false;
        } else if (n == 2) {
            this.calculateParentsOnly(contentElement);
        } else {
            this.mixed = false;
        }
    }

    private void calculateParentsOnly(ContentElement contentElement) {
        Object object;
        Iterator iterator = null;
        if (ContentElementOrderList.isContributor((VariabilityElement)contentElement) || ContentElementOrderList.isExtended(contentElement)) {
            object = new ArrayList<ContentElement>();
            UmaUtil.getAllSupersBoth(object, (VariabilityElement)contentElement, (VariabilityType)VariabilityType.CONTRIBUTES_LITERAL, (VariabilityType)VariabilityType.EXTENDS_LITERAL);
            object.add(contentElement);
            iterator = object.iterator();
        } else {
            this.mixed = false;
        }
        if (this.mixed) {
            Object object2;
            Object object3;
            object = null;
            HashMap<String, DescribableElement> hashMap = new HashMap<String, DescribableElement>();
            LinkedHashSet<DescribableElement> linkedHashSet = new LinkedHashSet<DescribableElement>();
            while (iterator.hasNext()) {
                Object object4;
                ContentElement contentElement2 = (ContentElement)iterator.next();
                if (contentElement2 instanceof ContentElement) {
                    object4 = new ArrayList();
                    object3 = contentElement2.eGet(this.feature);
                    if (object3 instanceof List) {
                        object4.addAll((List)object3);
                    }
                    object2 = object4.iterator();
                    while (object2.hasNext()) {
                        DescribableElement describableElement = (DescribableElement)object2.next();
                        hashMap.put(describableElement.getGuid(), describableElement);
                        linkedHashSet.add(describableElement);
                    }
                }
                if ((object4 = TngUtil.getOrderInfo((MethodElement)contentElement2, ORDER_INFO_NAME)) == null || object != null && object4.getTimestamp() <= object.getTimestamp()) continue;
                object = object4;
            }
            if (object != null) {
                int n = object.getGUIDs().size();
                int n2 = 0;
                while (n2 < n) {
                    object3 = object.getGUIDs().get(n2);
                    object2 = hashMap.get(object3);
                    if (object2 != null) {
                        super.add(object2);
                        linkedHashSet.remove(object2);
                    }
                    ++n2;
                }
            }
            super.addAll(linkedHashSet);
        }
    }

    public ContentElementOrderList(ContentElement contentElement) {
        Object object;
        this.editElement = contentElement;
        Object object2 = null;
        if (ContentElementOrderList.isContributor((VariabilityElement)contentElement) || TngUtil.hasContributor((VariabilityElement)contentElement)) {
            object = TngUtil.getBase((VariabilityElement)contentElement);
            object2 = new AbstractTreeIterator(object){

                protected Iterator getChildren(Object object) {
                    ArrayList<VariabilityElement> arrayList = new ArrayList<VariabilityElement>();
                    for (VariabilityElement variabilityElement : AssociationHelper.getImmediateVarieties((VariabilityElement)((VariabilityElement)object))) {
                        if (variabilityElement.getVariabilityType() != VariabilityType.CONTRIBUTES_LITERAL) continue;
                        arrayList.add(variabilityElement);
                    }
                    return arrayList.iterator();
                }
            };
        } else if (ContentElementOrderList.isExtended(contentElement)) {
            System.out.println("$$$ for " + contentElement.getName() + " = extended is true");
            object = new ArrayList();
            UmaUtil.getAllSupers((List)object, (VariabilityElement)contentElement, (VariabilityType)VariabilityType.EXTENDS_LITERAL);
            object.add(contentElement);
            object2 = object.iterator();
        } else {
            this.mixed = false;
        }
        if (this.mixed) {
            object = null;
            HashMap<String, ContentElement> hashMap = new HashMap<String, ContentElement>();
            LinkedList<ContentElement> linkedList = new LinkedList<ContentElement>();
            while (object2.hasNext()) {
                ContentElement contentElement2 = (ContentElement)object2.next();
                hashMap.put(contentElement2.getGuid(), contentElement2);
                linkedList.add(contentElement2);
                OrderInfo orderInfo = TngUtil.getOrderInfo((MethodElement)contentElement2, ORDER_INFO_NAME);
                if (orderInfo == null || object != null && orderInfo.getTimestamp() <= object.getTimestamp()) continue;
                object = orderInfo;
            }
            if (object != null) {
                int n = object.getGUIDs().size();
                int n2 = 0;
                while (n2 < n) {
                    Object object3 = object.getGUIDs().get(n2);
                    Object v = hashMap.get(object3);
                    if (v != null) {
                        super.add(v);
                        linkedList.remove(v);
                    }
                    ++n2;
                }
            }
            super.addAll(linkedList);
        }
    }

    private static boolean isExtended(ContentElement contentElement) {
        return contentElement.getVariabilityBasedOnElement() != null && contentElement.getVariabilityType() == VariabilityType.EXTENDS_LITERAL;
    }

    public void apply() {
        if (!this.mixed || !this.changed) {
            return;
        }
        String string = this.editElement.getOrderingGuide();
        OrderInfoCollection orderInfoCollection = null;
        StringResource stringResource = null;
        if (string == null || string.length() == 0) {
            orderInfoCollection = ModelFactory.eINSTANCE.createOrderInfoCollection();
        } else {
            stringResource = new StringResource(string);
            try {
                stringResource.load(null);
                orderInfoCollection = stringResource.getContents().isEmpty() ? ModelFactory.eINSTANCE.createOrderInfoCollection() : (OrderInfoCollection)stringResource.getContents().get(0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        OrderInfo orderInfo = null;
        for (OrderInfo orderInfo2 : orderInfoCollection.getOrderInfos()) {
            if (!ORDER_INFO_NAME.equalsIgnoreCase(orderInfo2.getName())) continue;
            orderInfo = orderInfo2;
            break;
        }
        if (orderInfo == null) {
            orderInfo = ModelFactory.eINSTANCE.createOrderInfo();
            orderInfo.setName(ORDER_INFO_NAME);
            orderInfoCollection.getOrderInfos().add((Object)orderInfo);
        } else {
            orderInfo.getGUIDs().clear();
        }
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            DescribableElement describableElement = (DescribableElement)this.get(n2);
            orderInfo.getGUIDs().add((Object)describableElement.getGuid());
            ++n2;
        }
        orderInfo.setTimestamp(System.currentTimeMillis());
        if (stringResource == null) {
            stringResource = new StringResource(null);
            stringResource.getContents().add((Object)orderInfoCollection);
        }
        try {
            stringResource.save(DEFAULT_SAVE_OPTIONS);
            string = stringResource.getString();
            this.editElement.setOrderingGuide(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public boolean canRemove(ContentElement contentElement) {
        return this.eGet().contains((Object)contentElement);
    }

    public Object remove(int n) {
        if (this.mixed) {
            if (!this.canRemove((ContentElement)this.get(n))) {
                return null;
            }
            Object object = super.remove(n);
            this.eGet().remove(object);
            return object;
        }
        return this.eGet().remove(n);
    }

    public boolean remove(Object object) {
        if (!this.canRemove((ContentElement)object)) {
            return false;
        }
        if (this.mixed) {
            if (super.remove(object)) {
                this.eGet().remove(object);
                return true;
            }
            return false;
        }
        return this.eGet().remove(object);
    }

    public boolean removeAll(Collection collection) {
        if (this.mixed) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!collection.contains(e) || !this.canRemove((ContentElement)e)) continue;
                iterator.remove();
                this.eGet().remove(e);
                bl = true;
            }
            return bl;
        }
        return this.eGet().removeAll(collection);
    }

    public void add(int n, Object object) {
        if (this.mixed) {
            super.add(n, object);
            this.eGet().add(object);
            this.changed = true;
        } else {
            this.eGet().add(n, object);
        }
    }

    public boolean add(Object object) {
        boolean bl = this.eGet().add(object);
        if (this.mixed && (bl = super.add(object))) {
            this.changed = true;
        }
        return bl;
    }

    public boolean addAll(Collection collection) {
        boolean bl = this.eGet().addAll(collection);
        if (this.mixed && (bl = super.addAll(collection))) {
            this.changed = true;
        }
        return bl;
    }

    public boolean addAll(int n, Collection collection) {
        if (this.mixed) {
            this.eGet().addAll(collection);
            boolean bl = super.addAll(n, collection);
            if (bl) {
                this.changed = true;
            }
        }
        return this.eGet().addAll(collection);
    }

    public Object set(int n, Object object) {
        if (this.mixed) {
            throw new UnsupportedOperationException();
        }
        return this.eGet().set(n, object);
    }

    public void clear() {
        if (this.mixed) {
            throw new UnsupportedOperationException();
        }
        this.eGet().clear();
    }

    public void move(int n, Object object) {
        if (this.mixed) {
            super.move(n, object);
            this.changed = true;
        } else {
            this.eGet().move(n, object);
        }
    }

    public Object move(int n, int n2) {
        if (this.mixed) {
            Object object = super.move(n, n2);
            this.changed = true;
            return object;
        }
        return this.eGet().move(n, n2);
    }

    public Object get(int n) {
        if (this.mixed) {
            return super.get(n);
        }
        return this.eGet().get(n);
    }

    public int size() {
        if (this.mixed) {
            return super.size();
        }
        return this.eGet().size();
    }

    public Iterator iterator() {
        if (this.mixed) {
            return super.iterator();
        }
        return this.eGet().iterator();
    }

    public boolean contains(Object object) {
        if (this.mixed) {
            return super.contains(object);
        }
        return this.eGet().contains(object);
    }

    public boolean containsAll(Collection collection) {
        if (this.mixed) {
            return super.containsAll(collection);
        }
        return this.eGet().containsAll(collection);
    }

    public Object[] toArray() {
        if (this.mixed) {
            return super.toArray();
        }
        return this.eGet().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        if (this.mixed) {
            return super.toArray(objectArray);
        }
        return this.eGet().toArray(objectArray);
    }

    public int indexOf(Object object) {
        if (this.mixed) {
            return super.indexOf(object);
        }
        return this.eGet().indexOf(object);
    }

    public int lastIndexOf(Object object) {
        if (this.mixed) {
            return super.lastIndexOf(object);
        }
        return this.eGet().lastIndexOf(object);
    }

    public boolean isMixed() {
        return this.mixed;
    }

    private EList eGet() {
        EList eList = null;
        Object object = ((ContentCategory)this.editElement).eGet(this.feature);
        if (object instanceof EList) {
            eList = (EList)object;
        }
        if (eList == null) {
            eList = new BasicEList();
        }
        return eList;
    }
}

