/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;

public class WrapperManager
implements IDisposable {
    private HashMap valueToWrapperMap;
    private AdapterFactory adapterFactory;

    public WrapperManager(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public Object getWrapper(Object object) {
        if (this.valueToWrapperMap != null) {
            return this.valueToWrapperMap.get(object);
        }
        return null;
    }

    public Collection getWrappers() {
        if (this.valueToWrapperMap != null) {
            return this.valueToWrapperMap.values();
        }
        return Collections.EMPTY_LIST;
    }

    protected IWrapperItemProvider createWrapper(Object object, Object object2, AdapterFactory adapterFactory) {
        return new DelegatingWrapperItemProvider(object, object2, null, -1, adapterFactory);
    }

    public void update(Collection collection) {
        IWrapperItemProvider iWrapperItemProvider;
        Set set;
        boolean bl = false;
        Set set2 = set = collection != null ? new HashSet(collection) : Collections.EMPTY_SET;
        if (this.valueToWrapperMap == null && !collection.isEmpty()) {
            this.valueToWrapperMap = new HashMap();
        }
        for (Object object : collection) {
            if (!this.valueToWrapperMap.containsKey(object)) {
                iWrapperItemProvider = this.createWrapper(object, this, this.adapterFactory);
                this.valueToWrapperMap.put(object, iWrapperItemProvider);
                bl = true;
            }
            set.remove(object);
        }
        if (!set.isEmpty()) {
            bl = true;
            for (Object object : set) {
                iWrapperItemProvider = (IWrapperItemProvider)this.valueToWrapperMap.remove(object);
                if (iWrapperItemProvider == null) continue;
                iWrapperItemProvider.dispose();
            }
        }
        if (bl) {
            Object object;
            int n = 0;
            object = collection.iterator();
            while (object.hasNext()) {
                ((IWrapperItemProvider)this.valueToWrapperMap.get(object.next())).setIndex(n);
                ++n;
            }
        }
    }

    public void dispose() {
        if (this.valueToWrapperMap != null) {
            Iterator iterator = this.valueToWrapperMap.values().iterator();
            while (iterator.hasNext()) {
                ((IDisposable)iterator.next()).dispose();
            }
            this.valueToWrapperMap.clear();
            this.valueToWrapperMap = null;
        }
    }
}

