/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.CircularDependencyCheck;
import org.eclipse.epf.library.edit.validation.CircularDependencyCheckFilter;
import org.eclipse.epf.library.edit.validation.DependencyInfoMgr;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

public final class DependencyChecker {
    private static final IStatus ERROR_STATUS = new Status(4, LibraryEditPlugin.getDefault().getId(), 0, "", null);
    public static boolean newCheck = true;
    public static boolean newCheckAct = true;

    public static IStatus checkCircularDependency(EObject eObject, final EStructuralFeature eStructuralFeature, Object object) {
        if (eStructuralFeature == UmaPackage.Literals.ACTIVITY__BREAKDOWN_ELEMENTS) {
            if (object instanceof Activity) {
                Activity activity = (Activity)eObject;
                VariabilityType variabilityType = activity.getVariabilityType();
                return DependencyChecker.checkCircularDependency(activity, (Activity)object, variabilityType);
            }
        } else if (eStructuralFeature == UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_BASED_ON_ELEMENT) {
            if (DependencyChecker.isCircularDependency((VariabilityElement)eObject, (VariabilityElement)object)) {
                return ERROR_STATUS;
            }
        } else if (eStructuralFeature == UmaPackage.Literals.DELIVERABLE__DELIVERED_WORK_PRODUCTS) {
            if (!DependencyChecker.checkCircularDeliverables((Deliverable)object, (Deliverable)eObject)) {
                return ERROR_STATUS;
            }
        } else if (eStructuralFeature.isMany()) {
            AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(object){
                private static final long serialVersionUID = 0L;

                protected Iterator getChildren(Object object) {
                    EObject eObject;
                    List list;
                    if (eStructuralFeature.getContainerClass().isInstance(object) && !(list = (List)(eObject = (EObject)object).eGet(eStructuralFeature)).isEmpty()) {
                        ArrayList arrayList = new ArrayList();
                        for (Object e : list) {
                            if (!eStructuralFeature.getContainerClass().isInstance(e)) continue;
                            arrayList.add(e);
                        }
                        return arrayList.iterator();
                    }
                    return Collections.EMPTY_LIST.iterator();
                }
            };
            while (abstractTreeIterator.hasNext()) {
                if (abstractTreeIterator.next() != eObject) continue;
                return ERROR_STATUS;
            }
        } else if (eStructuralFeature.getContainerClass().isInstance(object)) {
            Object object2;
            Object object3 = (EObject)object;
            do {
                if (object3 == eObject) {
                    return ERROR_STATUS;
                }
                object2 = object3.eGet(eStructuralFeature);
            } while ((object3 = eStructuralFeature.getContainerClass().isInstance(object2) ? (EObject)object2 : null) != null);
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkCircularDependency(Activity activity, Activity activity2) {
        if (DependencyChecker.isParent(activity, (BreakdownElement)activity2)) {
            Object[] objectArray = new Object[]{activity2.getName()};
            String string = NLS.bind((String)LibraryEditResources.activity_variability_error_msg1, (Object[])objectArray);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, string, null);
        }
        Process process = TngUtil.getOwningProcess((BreakdownElement)activity2);
        if (!newCheckAct && DependencyChecker.hasCyclicDependency(activity, process) || newCheckAct && DependencyChecker.sourceReachableByTarget((VariabilityElement)activity, (VariabilityElement)activity2)) {
            Object[] objectArray = new Object[]{activity.getName(), process.getName()};
            String string = NLS.bind((String)LibraryEditResources.apply_pattern_error_msg, (Object[])objectArray);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, string, null);
        }
        if (ProcessUtil.hasContributorOrReplacer(activity)) {
            Object[] objectArray = new Object[]{activity.getName(), process.getName()};
            String string = NLS.bind((String)LibraryEditResources.apply_pattern_error_msg1, (Object[])objectArray);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, string, null);
        }
        return Status.OK_STATUS;
    }

    private static boolean hasCyclicDependency(Activity activity, Process process) {
        AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(activity){
            private static final long serialVersionUID = 0L;

            protected Iterator getChildren(Object object) {
                if (object instanceof Activity) {
                    ArrayList arrayList = new ArrayList();
                    for (Object e : ((Activity)object).getBreakdownElements()) {
                        if (!(e instanceof VariabilityElement)) continue;
                        arrayList.add(e);
                    }
                    return arrayList.iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (abstractTreeIterator.hasNext()) {
            Process process2;
            VariabilityElement variabilityElement = (VariabilityElement)abstractTreeIterator.next();
            VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
            VariabilityType variabilityType = variabilityElement.getVariabilityType();
            if (variabilityElement2 == null || variabilityType != VariabilityType.EXTENDS_LITERAL || (process2 = TngUtil.getOwningProcess((BreakdownElement)variabilityElement2)) != process) continue;
            return true;
        }
        return false;
    }

    public static boolean isParent(Activity activity, BreakdownElement breakdownElement) {
        Activity activity2 = breakdownElement.getSuperActivities();
        while (activity2 != null) {
            if (activity2 == activity) {
                return true;
            }
            activity2 = activity2.getSuperActivities();
        }
        return false;
    }

    public static IStatus checkCircularDependency(Activity activity, Activity activity2, VariabilityType variabilityType) {
        return DependencyChecker.checkCircularDependency(activity, activity2, variabilityType, false);
    }

    public static IStatus checkCircularDependencyAfterFilterSelection(Activity activity, Activity activity2, VariabilityType variabilityType) {
        return DependencyChecker.checkCircularDependency(activity, activity2, variabilityType, true);
    }

    private static IStatus checkCircularDependency(Activity activity, Activity activity2, VariabilityType variabilityType, boolean bl) {
        if (activity2 instanceof Process && variabilityType == VariabilityType.REPLACES_LITERAL && !(activity instanceof Process)) {
            String string = LibraryEditResources.activity_variability_error_msg3;
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, string, null);
        }
        if (DependencyChecker.isParent(activity2, (BreakdownElement)activity)) {
            Object[] objectArray = new Object[]{activity.getName()};
            String string = NLS.bind((String)LibraryEditResources.activity_variability_error_msg1, (Object[])objectArray);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, string, null);
        }
        if (newCheckAct && bl) {
            IFilter iFilter = DependencyChecker.getCircularDependencyCheckFilter((VariabilityElement)activity);
            if (!iFilter.accept(activity2)) {
                Object[] objectArray = new Object[]{activity.getName(), activity2.getName()};
                String string = NLS.bind((String)LibraryEditResources.activity_variability_error_msg2, (Object[])objectArray);
                return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, string, null);
            }
            return Status.OK_STATUS;
        }
        if (DependencyChecker.isCircularDependency((VariabilityElement)activity, (VariabilityElement)activity2)) {
            Object[] objectArray = new Object[]{activity.getName(), activity2.getName()};
            String string = NLS.bind((String)LibraryEditResources.activity_variability_error_msg2, (Object[])objectArray);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, string, null);
        }
        if (ProcessUtil.hasContributorOrReplacer(activity2) && variabilityType == VariabilityType.EXTENDS_LITERAL) {
            Object[] objectArray = new Object[]{activity.getName(), activity2.getName()};
            String string = NLS.bind((String)LibraryEditResources.activity_variability_error_msg, (Object[])objectArray);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, string, null);
        }
        Process process = TngUtil.getOwningProcess((BreakdownElement)activity);
        if (process != null && DependencyChecker.hasCyclicDependency(activity2, process)) {
            Object[] objectArray = new Object[]{activity.getName(), activity2.getName()};
            String string = NLS.bind((String)LibraryEditResources.activity_variability_error_msg2, (Object[])objectArray);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, string, null);
        }
        return Status.OK_STATUS;
    }

    private static boolean isCircularDependency(VariabilityElement variabilityElement, VariabilityElement variabilityElement2) {
        VariabilityType variabilityType = variabilityElement2.getVariabilityType();
        while (variabilityType != VariabilityType.NA_LITERAL) {
            VariabilityElement variabilityElement3 = variabilityElement2.getVariabilityBasedOnElement();
            if (variabilityElement3 != null && variabilityElement3 == variabilityElement) {
                return true;
            }
            variabilityElement2 = variabilityElement3;
            variabilityType = variabilityElement3.getVariabilityType();
        }
        return false;
    }

    public static boolean checkCircularDeliverables(Deliverable deliverable, Deliverable deliverable2) {
        if (newCheck) {
            return !DependencyChecker.sourceReachableByTarget((VariabilityElement)deliverable, (VariabilityElement)deliverable2);
        }
        if (deliverable == deliverable2) {
            return false;
        }
        List list = deliverable.getDeliveredWorkProducts();
        if (list != null && list.size() > 0) {
            if (list.contains(deliverable2)) {
                return false;
            }
            for (Object e : list) {
                if (!(e instanceof Deliverable)) continue;
                return DependencyChecker.checkCircularDeliverables((Deliverable)e, deliverable2);
            }
        }
        return true;
    }

    public static boolean isAncessorOf(CustomCategory customCategory, DescribableElement describableElement) {
        AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(customCategory, false){
            private static final long serialVersionUID = 1L;

            protected Iterator getChildren(Object object) {
                if (object instanceof CustomCategory) {
                    return ((CustomCategory)object).getCategorizedElements().iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (abstractTreeIterator.hasNext()) {
            if (abstractTreeIterator.next() != describableElement) continue;
            return true;
        }
        return false;
    }

    public static boolean checkCircularForArtifacts(Artifact artifact, Collection collection) {
        HashSet hashSet = new HashSet();
        DependencyChecker.collectVariantSet(artifact, hashSet, VariabilityType.REPLACES_LITERAL);
        DependencyChecker.collectVariantSet(artifact, hashSet, VariabilityType.EXTENDS_LITERAL);
        if (!DependencyChecker.checkCircularForArtifacts1(artifact, collection, hashSet)) {
            return false;
        }
        return DependencyChecker.checkCircularForArtifacts2(artifact, collection);
    }

    private static boolean checkCircularForArtifacts1(Artifact artifact, Collection collection, HashSet hashSet) {
        if (collection == null) {
            return true;
        }
        for (Object e : collection) {
            if (!(e instanceof Artifact)) continue;
            Artifact artifact2 = (Artifact)e;
            if (hashSet.contains(artifact2)) {
                return false;
            }
            if (DependencyChecker.checkCircularForArtifacts1(artifact, artifact2.getContainedArtifacts(), hashSet)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkCircularForArtifacts2(Artifact artifact, Collection collection) {
        for (Object e : collection) {
            if (!(e instanceof Artifact) || !DependencyChecker.sourceIsOrAboveMe((Artifact)e, artifact)) continue;
            return false;
        }
        return true;
    }

    private static boolean sourceIsOrAboveMe(Artifact artifact, Artifact artifact2) {
        if (artifact == artifact2) {
            return true;
        }
        Artifact artifact3 = artifact2.getContainerArtifact();
        if (artifact3 instanceof Artifact && DependencyChecker.sourceIsOrAboveMe(artifact, artifact3)) {
            return true;
        }
        artifact3 = artifact2.getVariabilityBasedOnElement();
        return artifact3 instanceof Artifact && DependencyChecker.sourceIsOrAboveMe(artifact, artifact3);
    }

    private static void collectVariantSet(Artifact artifact, HashSet hashSet, VariabilityType variabilityType) {
        while (artifact != null) {
            Iterator iterator = TngUtil.getGeneralizers((VariabilityElement)artifact, variabilityType);
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
            artifact = artifact.getContainerArtifact();
        }
    }

    private static CircularDependencyCheck getCircularDependencyCheck(VariabilityElement variabilityElement, boolean bl, boolean bl2, boolean bl3) {
        MethodLibrary methodLibrary = UmaUtil.getMethodLibrary((EObject)variabilityElement);
        DependencyInfoMgr dependencyInfoMgr = new DependencyInfoMgr(methodLibrary);
        dependencyInfoMgr.setDndBit(bl3);
        return new CircularDependencyCheck(dependencyInfoMgr, variabilityElement, bl, bl2 || bl3);
    }

    private static boolean sourceReachableByTarget(VariabilityElement variabilityElement, VariabilityElement variabilityElement2) {
        return DependencyChecker.getCircularDependencyCheck(variabilityElement, false, false, false).reachableBy(variabilityElement2);
    }

    public static IFilter getCircularDependencyCheckFilter(VariabilityElement variabilityElement) {
        MethodLibrary methodLibrary = UmaUtil.getMethodLibrary((EObject)variabilityElement);
        DependencyInfoMgr dependencyInfoMgr = new DependencyInfoMgr(methodLibrary);
        return new CircularDependencyCheckFilter(dependencyInfoMgr, variabilityElement);
    }

    public static boolean checkCircularForMovingVariabilityElement(VariabilityElement variabilityElement, Collection collection) {
        return DependencyChecker.checkCircularForMovingVariabilityElement(variabilityElement, collection, false);
    }

    public static boolean checkCircularForMovingVariabilityElement(VariabilityElement variabilityElement, Collection collection, boolean bl) {
        if (!DependencyInfoMgr.VeToCheck(variabilityElement)) {
            return true;
        }
        CircularDependencyCheck circularDependencyCheck = DependencyChecker.getCircularDependencyCheck(variabilityElement, false, true, bl);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (circularDependencyCheck.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static IStatus checkCircularForApplyingVariabilityElement(VariabilityElement variabilityElement, VariabilityElement variabilityElement2, boolean bl) {
        boolean bl2 = DependencyChecker.checkCircularForMovingVariabilityElement(variabilityElement, Collections.singletonList(variabilityElement2), true);
        if (!bl2) {
            Object[] objectArray = new Object[]{variabilityElement2.getName(), variabilityElement.getName()};
            String string = NLS.bind((String)LibraryEditResources.variability_error_msg, (Object[])objectArray);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, string, null);
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkCircularDependencyAfterFilterSelection(VariabilityElement variabilityElement, VariabilityElement variabilityElement2) {
        IFilter iFilter = DependencyChecker.getCircularDependencyCheckFilter(variabilityElement);
        if (!iFilter.accept(variabilityElement2)) {
            Object[] objectArray = new Object[]{variabilityElement.getName(), variabilityElement2.getName()};
            String string = NLS.bind((String)LibraryEditResources.variability_error_msg, (Object[])objectArray);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, string, null);
        }
        return Status.OK_STATUS;
    }
}

