/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation.internal;

import java.io.File;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.AbstractStringValidator;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.osgi.util.NLS;

public class MethodPluginNameValidator
extends AbstractStringValidator {
    private MethodLibrary lib;
    private MethodPlugin plugin;

    public MethodPluginNameValidator(MethodLibrary methodLibrary, MethodPlugin methodPlugin) {
        this.lib = methodLibrary;
        this.plugin = methodPlugin;
    }

    public String isValid(String string) {
        String string2 = TngUtil.checkPluginName(string);
        if (string2 != null) {
            return string2;
        }
        Integer n = new Integer(255);
        if (!NameChecker.checkFilePathLength((MethodElement)this.lib, (MethodElement)this.plugin, string, n, null)) {
            string2 = NLS.bind((String)LibraryEditResources.filePathNameTooLong_msg, (Object[])new Object[]{n});
            return string2;
        }
        File file = new File(this.lib.eResource().getURI().toFileString()).getParentFile();
        String string3 = this.plugin != null ? TngUtil.getTypeText((EObject)this.plugin) : TngUtil.getTypeText("MethodPlugin");
        return TngUtil.checkName(file, this.lib.getMethodPlugins(), (NamedElement)this.plugin, string, string3, true);
    }
}

