/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RichTextAction
extends Action {
    protected IRichText richText;
    protected ToolItem toolItem;
    protected Collection<IAction> fMenuActions = new LinkedHashSet<IAction>();
    protected IMenuCreator menuCreator = new IMenuCreator(){
        private MenuManager dropDownMenuMgr;

        private void createDropDownMenuMgr() {
            if (this.dropDownMenuMgr == null) {
                this.dropDownMenuMgr = new MenuManager();
                for (IAction iAction : RichTextAction.this.getMenuActions()) {
                    this.dropDownMenuMgr.add(iAction);
                }
            }
        }

        public Menu getMenu(Control control) {
            this.createDropDownMenuMgr();
            return this.dropDownMenuMgr.createContextMenu(control);
        }

        public Menu getMenu(Menu menu) {
            this.createDropDownMenuMgr();
            Menu menu2 = new Menu(menu);
            IContributionItem[] iContributionItemArray = this.dropDownMenuMgr.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                IContributionItem iContributionItem;
                IContributionItem iContributionItem2 = iContributionItem = iContributionItemArray[n];
                if (iContributionItem instanceof ActionContributionItem) {
                    iContributionItem2 = new ActionContributionItem(((ActionContributionItem)iContributionItem).getAction());
                }
                iContributionItem2.fill(menu2, -1);
                ++n;
            }
            return menu2;
        }

        public void dispose() {
            if (this.dropDownMenuMgr != null) {
                this.dropDownMenuMgr.dispose();
                this.dropDownMenuMgr = null;
            }
        }
    };

    public RichTextAction(IRichText iRichText, int n) {
        super(null, n);
        this.richText = iRichText;
    }

    public boolean disableInReadOnlyMode() {
        return true;
    }

    public boolean disableInSourceMode() {
        return true;
    }

    public void setToolItem(ToolItem toolItem) {
        this.toolItem = toolItem;
    }

    public void run() {
        this.execute(this.richText);
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public Collection<IAction> getMenuActions() {
        return this.fMenuActions;
    }

    public void addActionToMenu(IAction iAction) {
        this.fMenuActions.add(iAction);
    }

    public abstract void execute(IRichText var1);
}

