/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.dialogs;

import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.FindReplaceAction;
import org.eclipse.epf.richtext.dialogs.BaseDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FindReplaceDialog
extends BaseDialog {
    private FindReplaceAction findReplaceAction;
    private boolean findOnly;
    private Text findText;
    private Text replaceText;
    private Button searchForwardRadioButton;
    private Button searchBackwardRadioButton;
    private Button caseSensitiveCheckbox;
    private Button wholeWordCheckbox;
    private Button findButton;
    private Button replaceButton;
    private Button replaceFindButton;
    private Button replaceAllButton;
    private Label statusLabel;

    public FindReplaceDialog(Shell shell, FindReplaceAction findReplaceAction, boolean bl) {
        super(shell);
        this.setShellStyle(0x860 | FindReplaceDialog.getDefaultOrientation());
        this.setBlockOnOpen(false);
        this.findReplaceAction = findReplaceAction;
        this.findOnly = bl;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 1;
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite3, 0);
        label.setText(RichTextResources.findLabel_text);
        this.findText = new Text(composite3, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        this.findText.setLayoutData((Object)gridData);
        this.findText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (FindReplaceDialog.this.findButton != null) {
                    FindReplaceDialog.this.findButton.setEnabled(FindReplaceDialog.this.findText.getText().trim().length() > 0);
                }
                if (FindReplaceDialog.this.replaceAllButton != null && !FindReplaceDialog.this.findOnly) {
                    FindReplaceDialog.this.replaceAllButton.setEnabled(FindReplaceDialog.this.findText.getText().trim().length() > 0);
                }
            }
        });
        Label label2 = new Label(composite3, 0);
        label2.setText(RichTextResources.replaceLabel_text);
        this.replaceText = new Text(composite3, 2048);
        this.replaceText.setLayoutData((Object)gridData);
        if (this.findOnly) {
            this.replaceText.setEnabled(false);
        } else {
            this.replaceText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    if (FindReplaceDialog.this.replaceButton != null) {
                        FindReplaceDialog.this.replaceButton.setEnabled(FindReplaceDialog.this.findReplaceAction.getFoundMatch());
                    }
                    if (FindReplaceDialog.this.replaceFindButton != null) {
                        FindReplaceDialog.this.replaceFindButton.setEnabled(FindReplaceDialog.this.findReplaceAction.getFoundMatch());
                    }
                }
            });
        }
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout(2, true));
        composite4.setLayoutData((Object)new GridData(768));
        Group group = new Group(composite4, 0);
        group.setText(RichTextResources.directionGroup_text);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        this.searchForwardRadioButton = new Button((Composite)group, 16);
        this.searchForwardRadioButton.setText(RichTextResources.forwardRadioButton_text);
        this.searchForwardRadioButton.setSelection(true);
        this.searchBackwardRadioButton = new Button((Composite)group, 16);
        this.searchBackwardRadioButton.setText(RichTextResources.backwardRadioButton_text);
        Group group2 = new Group(composite4, 0);
        group2.setText(RichTextResources.optionsGroup_text);
        group2.setLayout((Layout)new GridLayout(1, false));
        group2.setLayoutData((Object)new GridData(768));
        this.caseSensitiveCheckbox = new Button((Composite)group2, 32);
        this.caseSensitiveCheckbox.setText(RichTextResources.caseSensitiveCheckbox_text);
        this.wholeWordCheckbox = new Button((Composite)group2, 32);
        this.wholeWordCheckbox.setText(RichTextResources.wholeWordCheckbox_text);
        this.statusLabel = new Label(composite2, 0);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        super.getShell().setText(RichTextResources.findReplaceDialog_title);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1025, RichTextResources.findButton_text, true);
        this.findButton = super.getButton(1025);
        this.findButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FindReplaceDialog.this.findReplaceAction.run(1, FindReplaceDialog.this.getFindText(), FindReplaceDialog.this.getReplaceText(), FindReplaceDialog.this.getMatchDirection(), FindReplaceDialog.this.getMatchOptions());
                if (!FindReplaceDialog.this.findOnly) {
                    FindReplaceDialog.this.replaceButton.setEnabled(FindReplaceDialog.this.findReplaceAction.getFoundMatch());
                    FindReplaceDialog.this.replaceFindButton.setEnabled(FindReplaceDialog.this.findReplaceAction.getFoundMatch());
                }
                if (FindReplaceDialog.this.findReplaceAction.getFoundMatch()) {
                    FindReplaceDialog.this.statusLabel.setText("");
                } else {
                    FindReplaceDialog.this.statusLabel.setText(RichTextResources.FindReplace_Status_noMatch_label);
                }
                FindReplaceDialog.this.findButton.setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.createButton(composite, 1026, RichTextResources.replaceButton_text, false);
        this.replaceButton = super.getButton(1026);
        if (!this.findOnly) {
            this.replaceButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FindReplaceDialog.this.findReplaceAction.run(2, FindReplaceDialog.this.getFindText(), FindReplaceDialog.this.getReplaceText(), FindReplaceDialog.this.getMatchDirection(), FindReplaceDialog.this.getMatchOptions());
                    FindReplaceDialog.this.replaceButton.setFocus();
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
        }
        this.createButton(composite, 1027, RichTextResources.replaceFindButton_text, false);
        this.replaceFindButton = super.getButton(1027);
        if (!this.findOnly) {
            this.replaceFindButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FindReplaceDialog.this.findReplaceAction.run(3, FindReplaceDialog.this.getFindText(), FindReplaceDialog.this.getReplaceText(), FindReplaceDialog.this.getMatchDirection(), FindReplaceDialog.this.getMatchOptions());
                    FindReplaceDialog.this.replaceButton.setEnabled(FindReplaceDialog.this.findReplaceAction.getFoundMatch());
                    FindReplaceDialog.this.replaceFindButton.setEnabled(FindReplaceDialog.this.findReplaceAction.getFoundMatch());
                    FindReplaceDialog.this.replaceFindButton.setFocus();
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
        }
        this.createButton(composite, 1028, RichTextResources.replaceallButton_text, false);
        this.replaceAllButton = super.getButton(1028);
        if (!this.findOnly) {
            this.replaceAllButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FindReplaceDialog.this.findReplaceAction.run(4, FindReplaceDialog.this.getFindText(), FindReplaceDialog.this.getReplaceText(), FindReplaceDialog.this.getMatchDirection(), FindReplaceDialog.this.getMatchOptions());
                    FindReplaceDialog.this.replaceButton.setEnabled(false);
                    FindReplaceDialog.this.replaceFindButton.setEnabled(false);
                    FindReplaceDialog.this.replaceAllButton.setFocus();
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
        }
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.cancelButton = super.getButton(1);
        this.findButton.setEnabled(false);
        this.replaceButton.setEnabled(false);
        this.replaceFindButton.setEnabled(false);
        this.replaceAllButton.setEnabled(false);
    }

    public String getFindText() {
        return this.findText.getText();
    }

    public String getReplaceText() {
        return this.replaceText.getText();
    }

    public int getMatchDirection() {
        return this.searchForwardRadioButton.getSelection() ? 1 : -1;
    }

    public int getMatchOptions() {
        int n = 0;
        if (this.wholeWordCheckbox.getSelection()) {
            n |= 2;
        }
        if (this.caseSensitiveCheckbox.getSelection()) {
            n |= 4;
        }
        return n;
    }

    public boolean isFindOnly() {
        return this.findOnly;
    }

    public void setFindOnly(boolean bl) {
        this.findOnly = bl;
    }
}

