/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.configuration.internal;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.common.html.HTMLParser;
import org.eclipse.epf.search.GenerateSearchIndexException;
import org.eclipse.epf.search.SearchConfigurationException;
import org.eclipse.epf.search.SearchResources;
import org.eclipse.epf.search.SearchServiceException;
import org.eclipse.epf.search.analysis.TextAnalyzer;
import org.eclipse.epf.search.configuration.ConfigurationHitEntry;
import org.eclipse.epf.search.configuration.ConfigurationSearchQuery;

public class ConfigurationSearchService {
    public static final String BRIEF_DESCRIPTION_FIELD = "briefDescription";
    public static final String CONTENT_FIELD = "content";
    public static final String ID_FIELD = "id";
    public static final String MODIFIED_FIELD = "modified";
    public static final String NAME_FIELD = "name";
    public static final String ROLE_FIELD = "role";
    public static final String SUMMARY_FIELD = "summary";
    public static final String TYPE_FIELD = "type";
    public static final String URL_FIELD = "url";
    private HTMLParser parser;
    private String docDir = null;
    private String indexDir = null;

    public ConfigurationSearchService(String string) {
        String string2 = System.getProperty("user.home");
        int n = Math.abs(string.hashCode());
        String string3 = String.valueOf(string2) + File.separator + "rup" + File.separator + n + File.separator + "index";
        this.setDirs(string, string3);
    }

    public ConfigurationSearchService(String string, String string2) {
        this.setDirs(string, string2);
    }

    public void setDirs(String string, String string2) {
        this.docDir = string;
        this.indexDir = string2;
    }

    public ConfigurationHitEntry[] search(ConfigurationSearchQuery configurationSearchQuery) throws SearchServiceException {
        return this.search(configurationSearchQuery.getQueryString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurationHitEntry[] search(String string) throws SearchServiceException {
        ConfigurationHitEntry[] configurationHitEntryArray;
        IndexSearcher indexSearcher = null;
        try {
            indexSearcher = new IndexSearcher(this.indexDir);
            Query query = QueryParser.parse((String)string, (String)CONTENT_FIELD, (Analyzer)new TextAnalyzer());
            Hits hits = indexSearcher.search(query);
            ConfigurationHitEntry[] configurationHitEntryArray2 = new ConfigurationHitEntry[hits.length()];
            int n = 0;
            while (true) {
                if (n >= configurationHitEntryArray2.length) {
                    configurationHitEntryArray = configurationHitEntryArray2;
                    if (indexSearcher == null) return configurationHitEntryArray;
                    break;
                }
                Document document = hits.doc(n);
                configurationHitEntryArray2[n] = new ConfigurationHitEntry();
                configurationHitEntryArray2[n].setName(document.get(NAME_FIELD));
                configurationHitEntryArray2[n].setUrl(document.get(URL_FIELD));
                configurationHitEntryArray2[n].setBriefDesc(document.get(BRIEF_DESCRIPTION_FIELD));
                configurationHitEntryArray2[n].setId(document.get(ID_FIELD));
                configurationHitEntryArray2[n].setType(document.get(TYPE_FIELD));
                ++n;
            }
        }
        catch (Exception exception) {
            try {
                throw new SearchConfigurationException(exception);
            }
            catch (Throwable throwable) {
                if (indexSearcher == null) throw throwable;
                try {
                    indexSearcher.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            indexSearcher.close();
            return configurationHitEntryArray;
        }
        catch (IOException iOException) {}
        return configurationHitEntryArray;
    }

    public boolean indexExists() {
        File[] fileArray = new File(this.indexDir).listFiles();
        return fileArray != null && fileArray.length != 0;
    }

    public void index() throws SearchServiceException {
        this.index(null, false);
    }

    public void index(boolean bl) throws SearchServiceException {
        this.index(null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(IProgressMonitor iProgressMonitor, boolean bl) throws SearchServiceException {
        Class<ConfigurationSearchService> clazz = ConfigurationSearchService.class;
        synchronized (ConfigurationSearchService.class) {
            if (this.indexDir == null || this.docDir == null) {
                throw new IllegalStateException("Invalid indexDir or docDir");
            }
            if (!bl && this.indexExists()) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (iProgressMonitor != null) {
                iProgressMonitor.beginTask(SearchResources.indexConfigFilesTask_name, ConfigurationSearchService.getTotalDocsToIndex(this.docDir));
            }
            try {
                try {
                    this.deleteAllIndexDirs();
                    new File(this.indexDir).mkdirs();
                    IndexWriter indexWriter = new IndexWriter(this.indexDir, (Analyzer)new TextAnalyzer(), true);
                    indexWriter.maxFieldLength = 1000000;
                    this.parser = new HTMLParser();
                    this.indexDocs(new File(this.docDir), indexWriter, iProgressMonitor);
                    indexWriter.optimize();
                    indexWriter.close();
                }
                catch (Exception exception) {
                    throw new GenerateSearchIndexException(exception);
                }
            }
            finally {
                if (iProgressMonitor != null) {
                    iProgressMonitor.done();
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void deleteAllIndexDirs() {
        File file = new File(this.indexDir).getParentFile();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].getName().startsWith("index")) {
                    File[] fileArray2 = fileArray[n].listFiles();
                    int n2 = 0;
                    while (n2 < fileArray2.length) {
                        fileArray2[n2].delete();
                        ++n2;
                    }
                    fileArray[n].delete();
                }
                ++n;
            }
        }
    }

    public static int getTotalDocsToIndex(String string) {
        int n = 0;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return n;
        }
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (ConfigurationSearchService.isXMIDoc(fileArray[n2])) {
                ++n;
            } else if (fileArray[n2].isDirectory()) {
                n += ConfigurationSearchService.getTotalDocsToIndex(fileArray[n2].getAbsolutePath());
            }
            ++n2;
        }
        return n;
    }

    private static boolean isXMIDoc(File file) {
        return file.getPath().endsWith(".xmi");
    }

    private static boolean isHtmlOrTextDoc(File file) {
        String string = file.getPath();
        return string.endsWith(".html") || string.endsWith(".htm") || string.endsWith(".txt");
    }

    private void indexDocs(File file, IndexWriter indexWriter, IProgressMonitor iProgressMonitor) throws Exception {
        if (file.isDirectory()) {
            if (file.getName().equalsIgnoreCase("applet")) {
                return;
            }
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                this.indexDocs(new File(file, stringArray[n]), indexWriter, iProgressMonitor);
                ++n;
            }
        } else if (ConfigurationSearchService.isHtmlOrTextDoc(file)) {
            if (iProgressMonitor != null) {
                iProgressMonitor.subTask(file.getName());
                iProgressMonitor.worked(1);
            }
            if (this.shouldBeExcluded(file)) {
                return;
            }
            Document document = this.getHTMLDocument(file);
            indexWriter.addDocument(document);
        }
    }

    public boolean shouldBeExcluded(File file) {
        String string = file.getParentFile().getAbsolutePath();
        return this.docDir.startsWith(string);
    }

    public Document getHTMLDocument(File file) throws IOException, InterruptedException {
        Document document = new Document();
        document.add(Field.UnIndexed((String)URL_FIELD, (String)file.getPath().replace(File.pathSeparatorChar, '/')));
        document.add(Field.Keyword((String)MODIFIED_FIELD, (String)DateField.timeToString((long)file.lastModified())));
        try {
            this.parser.parse(file);
        }
        catch (Exception exception) {}
        document.add(Field.Text((String)CONTENT_FIELD, (String)this.parser.getText()));
        document.add(Field.UnIndexed((String)SUMMARY_FIELD, (String)this.parser.getSummary()));
        Properties properties = this.parser.getMetaTags();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            document.add(Field.Text((String)string, (String)properties.getProperty(string)));
        }
        if (document.getField(ROLE_FIELD) == null) {
            document.add(Field.Text((String)ROLE_FIELD, (String)"NORUPROLE"));
        }
        return document;
    }
}

