/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.epf.publishing.services.index.Def;
import org.eclipse.epf.publishing.services.index.FontObject;
import org.eclipse.epf.publishing.services.index.HelpMessages;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;
import org.eclipse.epf.publishing.services.index.MiscStatic;

public class DefinitionObject {
    private String indextitle = "Index - Basic Unified Process";
    private String see = ", See ";
    private String seealso = ", See also ";
    private String characterset = "utf-8";
    String keyWordSeparator = "|";
    String levelSeparatorReplace = ":";
    String wwwRoot = null;
    int stipLength = 0;
    String relativepath = null;
    String target = null;
    String specKeyWordFile = null;
    String mainResultFile = null;
    String indexResultFile = null;
    String indexTarget = null;
    String indexHeight = null;
    String keywordTarget = null;
    String keywordResultFile = null;
    String headerFile = null;
    String footerFile = null;
    String keyWordPrefix = Def.DefaultKeyWordPrefix;
    String keyWordLevelSeparator = Def.DefaultKeyWordLevelSeparator;
    boolean multidocumentkeyword = false;
    boolean showdocumenttitle = false;
    Vector stopDirsV = null;
    Hashtable fontDefinitions = null;
    Hashtable styleDefinitions = null;
    private File defFileRoot;

    DefinitionObject(String string, String string2, String string3) {
        this.setwwwRoot(string);
        this.defFileRoot = new File(string2).getParentFile();
        String string4 = MiscStatic.loadFile(string2, string3);
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "\t\n");
        this.stopDirsV = new Vector();
        this.fontDefinitions = new Hashtable(10);
        this.styleDefinitions = new Hashtable(10);
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken().trim();
            if (string5.equalsIgnoreCase(Def.LevelFont)) {
                this.asignFont(stringTokenizer);
                continue;
            }
            if (string5.equalsIgnoreCase(Def.LevelStyle)) {
                this.asignStyle(stringTokenizer);
                continue;
            }
            String string6 = stringTokenizer.nextToken().trim();
            if (string6 == null) {
                System.err.println("DefinitionObject:addValue\n" + HelpMessages.PARAMETER_MISSING_VALUE + string5);
                return;
            }
            this.asignValue(string5, string6);
        }
    }

    boolean enoughInput() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        if (this.wwwRoot == null) {
            stringBuffer.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.WWWRootParam);
            bl = false;
        }
        if (this.keywordResultFile == null) {
            stringBuffer.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.KeyWordResultFile);
            bl = false;
        }
        if (this.indexResultFile != null && this.mainResultFile == null) {
            stringBuffer.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.MainResultFile);
            bl = false;
        }
        if (this.indexResultFile != null && this.indexTarget == null) {
            stringBuffer.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.IndexTarget);
            bl = false;
        }
        if (this.indexResultFile != null && this.keywordTarget == null) {
            stringBuffer.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.KeyWordTarget);
            bl = false;
        }
        if (this.indexResultFile != null && this.indexHeight == null) {
            stringBuffer.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.IndexHeight);
            bl = false;
        }
        if (this.relativepath == null) {
            stringBuffer.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.RelPath);
            bl = false;
        }
        if (this.headerFile == null) {
            stringBuffer.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.HeaderFile);
            bl = false;
        }
        if (this.footerFile == null) {
            stringBuffer.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.FooterFile);
            bl = false;
        }
        FontObject fontObject = (FontObject)this.fontDefinitions.get(Def.DefaultFont);
        FontObject fontObject2 = (FontObject)this.styleDefinitions.get(Def.DefaultStyle);
        if (fontObject == null && fontObject2 == null) {
            stringBuffer.append(String.valueOf(HelpMessages.FONT_AND_STYLE_MISSING) + Def.DefaultFont + " " + Def.DefaultStyle);
            bl = false;
        }
        if (!bl) {
            stringBuffer.append("\n");
            System.err.println(stringBuffer);
        }
        return bl;
    }

    private void asignValue(String string, String string2) {
        if (string.equalsIgnoreCase(Def.MainResultFile)) {
            this.mainResultFile = string2;
        } else if (string.equalsIgnoreCase(Def.CharacterSet)) {
            this.characterset = string2;
        } else if (string.equalsIgnoreCase(Def.See)) {
            this.see = string2;
        } else if (string.equalsIgnoreCase(Def.SeeAlso)) {
            this.seealso = string2;
        } else if (string.equalsIgnoreCase(Def.IndexResultFile)) {
            this.indexResultFile = string2;
        } else if (string.equalsIgnoreCase(Def.KeyWordResultFile)) {
            this.keywordResultFile = string2;
        } else if (string.equalsIgnoreCase(Def.HeaderFile)) {
            this.headerFile = new File(this.defFileRoot, string2).getAbsolutePath();
        } else if (string.equalsIgnoreCase(Def.FooterFile)) {
            this.footerFile = new File(this.defFileRoot, string2).getAbsolutePath();
        } else if (string.equalsIgnoreCase(Def.RelPath)) {
            this.relativepath = string2;
        } else if (string.equalsIgnoreCase(Def.DefaultTargetParam)) {
            this.target = string2;
        } else if (string.equalsIgnoreCase(Def.KeyWordFile)) {
            this.specKeyWordFile = new File(this.defFileRoot, string2).getAbsolutePath();
        } else if (string.equalsIgnoreCase(Def.IndexTitle)) {
            this.indextitle = string2;
        } else if (string.equalsIgnoreCase(Def.KeyWordTarget)) {
            this.keywordTarget = string2;
        } else if (string.equalsIgnoreCase(Def.IndexTarget)) {
            this.indexTarget = string2;
        } else if (string.equalsIgnoreCase(Def.IndexHeight)) {
            this.indexHeight = string2;
        } else if (string.equalsIgnoreCase(Def.MultiDocKeyWord)) {
            this.multidocumentkeyword = string2.equalsIgnoreCase(Def.True);
        } else if (string.equalsIgnoreCase(Def.ShowDocTitle)) {
            this.showdocumenttitle = string2.equalsIgnoreCase(Def.True);
        } else if (string.equalsIgnoreCase(Def.LeaveDir)) {
            this.stopDirsV.addElement(string2);
        } else if (string.equalsIgnoreCase(Def.KeyWordPrefix)) {
            this.keyWordPrefix = string2;
        } else if (string.equalsIgnoreCase(Def.KeyWordLevelSeparator)) {
            this.keyWordLevelSeparator = string2;
        } else {
            System.err.println(String.valueOf(HelpMessages.INVALID_PARAMETER_NAME) + string);
        }
    }

    private void asignFont(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken().trim();
        Object object = string;
        if (!string.equalsIgnoreCase(Def.DefaultFont) && !string.equalsIgnoreCase(Def.HeadLineFont)) {
            object = new Integer(string);
        }
        String string2 = stringTokenizer.nextToken().trim();
        String string3 = stringTokenizer.nextToken().trim();
        String string4 = stringTokenizer.nextToken().trim();
        this.fontDefinitions.put(object, new FontObject(string2, string3, string4));
    }

    private void asignStyle(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken().trim();
        Object object = string;
        if (!string.equalsIgnoreCase(Def.DefaultStyle) && !string.equalsIgnoreCase(Def.HeadLineStyle)) {
            object = new Integer(string);
        }
        String string2 = stringTokenizer.nextToken().trim();
        this.styleDefinitions.put(object, new FontObject(string2));
    }

    boolean isInStopdir(String string) {
        int n = 0;
        while (n < this.stopDirsV.size()) {
            String string2 = (String)this.stopDirsV.elementAt(n);
            if (string.substring(KeyWordIndexHelper.defObj.getWwwRoot().length() + 1).compareTo(string2) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    String getIndexTitle() {
        return this.indextitle;
    }

    String getSee() {
        return this.see;
    }

    String getSeeAlso() {
        return this.seealso;
    }

    String getCharacterSet() {
        return this.characterset;
    }

    boolean getMulitDocumentKeyword() {
        return this.multidocumentkeyword;
    }

    boolean getShowDocumentTitle() {
        return this.showdocumenttitle;
    }

    String getKeyWordTarget() {
        return this.keywordTarget;
    }

    String getIndexTarget() {
        return this.indexTarget;
    }

    String getIndexHeight() {
        return this.indexHeight;
    }

    String getWwwRoot() {
        return this.wwwRoot;
    }

    int getWwwRootLength() {
        return this.stipLength;
    }

    String getTarget() {
        return this.target;
    }

    String getKeyWordFile() {
        return this.specKeyWordFile;
    }

    String getMainResultFile() {
        return this.mainResultFile;
    }

    String getIndexResultFile() {
        return this.indexResultFile;
    }

    String getKeywordResultFile() {
        return this.keywordResultFile;
    }

    String getRelativePath() {
        return this.relativepath;
    }

    String getHeaderFile() {
        return this.headerFile;
    }

    String getFooterFile() {
        return this.footerFile;
    }

    String getKeyWordPrefix() {
        return this.keyWordPrefix;
    }

    String getKeyWordLevelSeparator() {
        return this.keyWordLevelSeparator;
    }

    FontObject getFont(int n) {
        FontObject fontObject = (FontObject)this.fontDefinitions.get(new Integer(n));
        if (fontObject == null) {
            fontObject = (FontObject)this.fontDefinitions.get(Def.DefaultFont);
        }
        return fontObject;
    }

    FontObject getFont(Object object) {
        return (FontObject)this.fontDefinitions.get(object);
    }

    FontObject getStyleSheet(int n) {
        FontObject fontObject = (FontObject)this.styleDefinitions.get(new Integer(n));
        if (fontObject == null) {
            fontObject = (FontObject)this.styleDefinitions.get(Def.DefaultStyle);
        }
        return fontObject;
    }

    FontObject getStyleSheet(Object object) {
        return (FontObject)this.styleDefinitions.get(object);
    }

    void printStart(OutputStreamWriter outputStreamWriter, int n) {
        if (this.getStyleSheet(Def.DefaultStyle) == null) {
            FontObject fontObject = this.getFont(n);
            if (fontObject == null) {
                fontObject = this.getFont(Def.DefaultFont);
            }
            this.printStart(outputStreamWriter, fontObject);
        } else {
            FontObject fontObject = this.getStyleSheet(n);
            if (fontObject == null) {
                fontObject = this.getStyleSheet(Def.DefaultStyle);
            }
            this.printStart(outputStreamWriter, fontObject);
        }
    }

    void printStart(OutputStreamWriter outputStreamWriter, FontObject fontObject) {
        if (outputStreamWriter == null) {
            System.out.println("DefinitionObject:printStart\n" + HelpMessages.BAD_OUTPUT_STREAM);
            return;
        }
        if (fontObject != null && fontObject.getStyleSheet() == null) {
            MiscStatic.print(outputStreamWriter, "<FONT FACE=\"" + fontObject.getName() + "\" SIZE=\"" + fontObject.getSize() + "\" >\n");
            if (fontObject.isItalic()) {
                MiscStatic.print(outputStreamWriter, "<I>");
            }
            if (fontObject.isBold()) {
                MiscStatic.print(outputStreamWriter, "<B>");
            }
        } else {
            MiscStatic.print(outputStreamWriter, "<P CLASS=\"" + fontObject.getStyleSheet() + "\">\n");
        }
    }

    void printEnd(OutputStreamWriter outputStreamWriter, int n) {
        if (outputStreamWriter == null) {
            System.out.println("DefinitionObject:printEnd\n" + HelpMessages.BAD_OUTPUT_STREAM);
            return;
        }
        if (this.getStyleSheet(Def.DefaultStyle) == null) {
            FontObject fontObject = this.getFont(n);
            if (fontObject == null) {
                fontObject = this.getFont(Def.DefaultFont);
            }
            this.printEnd(outputStreamWriter, fontObject);
        } else {
            this.printEnd(outputStreamWriter, null);
        }
    }

    void printEnd(OutputStreamWriter outputStreamWriter, FontObject fontObject) {
        if (outputStreamWriter == null) {
            System.out.println("DefinitionObject:printEnd\n" + HelpMessages.BAD_OUTPUT_STREAM);
            return;
        }
        if (fontObject != null && fontObject.getStyleSheet() == null) {
            if (fontObject.isBold()) {
                MiscStatic.print(outputStreamWriter, "</B>");
            }
            if (fontObject.isItalic()) {
                MiscStatic.print(outputStreamWriter, "</I>");
            }
            MiscStatic.print(outputStreamWriter, "</FONT>\n");
        } else {
            MiscStatic.print(outputStreamWriter, "</P>\n");
        }
    }

    public void setwwwRoot(String string) {
        try {
            File file = new File(string);
            this.wwwRoot = String.valueOf(file.getCanonicalPath()) + "/";
            this.wwwRoot = this.wwwRoot.replace('\\', '/');
            this.stipLength = this.wwwRoot.length() - 1;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void setRelativePath(String string) {
        this.relativepath = string;
    }

    public void setIndexTitle(String string) {
        this.indextitle = string;
    }
}

