/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.services;

import com.ibm.icu.text.SimpleDateFormat;
import commonj.sdo.Type;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.epf.common.serviceability.VersionUtil;
import org.eclipse.epf.dataexchange.util.ContentProcessor;
import org.eclipse.epf.dataexchange.util.ILogger;
import org.eclipse.epf.export.xml.ExportXMLResources;
import org.eclipse.epf.export.xml.services.ExportResourceHandler;
import org.eclipse.epf.export.xml.services.FeatureManager;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.xml.uma.BreakdownElement;
import org.eclipse.epf.xml.uma.ContentCategoryPackage;
import org.eclipse.epf.xml.uma.ContentPackage;
import org.eclipse.epf.xml.uma.DocumentRoot;
import org.eclipse.epf.xml.uma.MethodElement;
import org.eclipse.epf.xml.uma.MethodLibrary;
import org.eclipse.epf.xml.uma.MethodPackage;
import org.eclipse.epf.xml.uma.MethodPlugin;
import org.eclipse.epf.xml.uma.Process;
import org.eclipse.epf.xml.uma.ProcessComponent;
import org.eclipse.epf.xml.uma.ProcessPackage;
import org.eclipse.epf.xml.uma.Section;
import org.eclipse.epf.xml.uma.UmaFactory;
import org.eclipse.epf.xml.uma.UmaPackage;
import org.eclipse.epf.xml.uma.VariabilityType;
import org.eclipse.epf.xml.uma.WorkBreakdownElement;
import org.eclipse.epf.xml.uma.WorkOrder;
import org.eclipse.epf.xml.uma.WorkOrderType;
import org.eclipse.epf.xml.uma.util.UmaResourceFactoryImpl;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLLibrary {
    private String filePath;
    private ILogger logger;
    private ContentProcessor contentProc = null;
    private MethodLibrary rootObject;
    private Map contentCategoryPkgMap = new HashMap();
    private Map elementsMap = new HashMap();
    private Map<String, String> guidToPlugNameMap;

    public XMLLibrary(ContentProcessor contentProcessor, ILogger iLogger, String string) {
        this.contentProc = contentProcessor;
        this.logger = iLogger;
        this.filePath = string;
    }

    public EDataObject getRoot() {
        return this.rootObject;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String[] getPluginIds() {
        EList eList = this.rootObject.getMethodPlugin();
        String[] stringArray = new String[eList.size()];
        int n = 0;
        while (n < eList.size()) {
            stringArray[n] = ((MethodPlugin)eList.get(n)).getId();
            ++n;
        }
        return stringArray;
    }

    public EDataObject createLibrary(String string, String string2) {
        MethodLibrary methodLibrary = UmaFactory.eINSTANCE.createMethodLibrary();
        String string3 = "";
        for (String string4 : VersionUtil.getAllToolIDs()) {
            String string5 = VersionUtil.getVersions((String)string4).getMinToolVersionForCurrentXMLSchemaVersion().getToolVersion().toString();
            if (string3.length() > 0) {
                string3 = String.valueOf(string3) + ";";
            }
            string3 = String.valueOf(string3) + string4 + "=" + string5;
        }
        if (string3.length() > 0) {
            methodLibrary.setTool(string3);
        }
        return this.create(string, string2, (MethodElement)methodLibrary);
    }

    public void load() throws Exception {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        URI uRI = URI.createFileURI((String)new File(this.filePath).getAbsolutePath());
        Resource resource = new UmaResourceFactoryImpl().createResource(uRI);
        resourceSetImpl.getResources().add((Object)resource);
        resource.load(new HashMap());
        DocumentRoot documentRoot = (DocumentRoot)resource.getContents().get(0);
        for (Object e : documentRoot.eContents()) {
            if (!(e instanceof MethodLibrary)) continue;
            this.rootObject = (MethodLibrary)e;
            break;
        }
    }

    private MethodLibrary create(String string, String string2, MethodElement methodElement) {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        File file = new File(this.filePath);
        URI uRI = URI.createFileURI((String)file.getAbsolutePath());
        Resource resource = new UmaResourceFactoryImpl().createResource(uRI);
        resourceSetImpl.getResources().add((Object)resource);
        this.setElement(string, (EDataObject)methodElement);
        if (methodElement != null) {
            resource.getContents().add((Object)methodElement);
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("ENCODING", "UTF-8");
            resource.save(hashMap);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (methodElement instanceof MethodLibrary) {
            this.rootObject = (MethodLibrary)methodElement;
        }
        return this.rootObject;
    }

    public EDataObject getContentCategoryPackage(String string) {
        ContentCategoryPackage contentCategoryPackage = (ContentCategoryPackage)this.contentCategoryPkgMap.get(string);
        if (contentCategoryPackage != null) {
            return contentCategoryPackage;
        }
        MethodPlugin methodPlugin = (MethodPlugin)this.getElement(string);
        if (methodPlugin == null) {
            this.logger.logWarning(NLS.bind((String)ExportXMLResources.xmlLibrary_no_plugin, (Object)string));
            return null;
        }
        contentCategoryPackage = UmaFactory.eINSTANCE.createContentCategoryPackage();
        contentCategoryPackage.setName("ContentCategories");
        this.setElement(EcoreUtil.generateUUID(), (EDataObject)contentCategoryPackage);
        methodPlugin.getMethodPackage().add((Object)contentCategoryPackage);
        this.contentCategoryPkgMap.put(string, contentCategoryPackage);
        return contentCategoryPackage;
    }

    public void save() throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ENCODING", "UTF-8");
        Resource resource = this.rootObject.eResource();
        resource.save(hashMap);
    }

    public EDataObject open() {
        return this.rootObject;
    }

    public EDataObject getElement(String string) {
        return (EDataObject)this.elementsMap.get(string);
    }

    public EDataObject getElement(Object object) {
        if (object instanceof MethodElement) {
            return this.getElement(((MethodElement)object).getId());
        }
        return null;
    }

    public String getElementId(EDataObject eDataObject) {
        if (eDataObject instanceof MethodElement) {
            return ((MethodElement)eDataObject).getId();
        }
        if (eDataObject instanceof WorkOrder) {
            return ((WorkOrder)eDataObject).getId();
        }
        return null;
    }

    private void setElement(String string, EDataObject eDataObject) {
        if (!this.elementsMap.containsKey(string)) {
            if (eDataObject instanceof MethodElement) {
                ((MethodElement)eDataObject).setId(string);
            }
            this.elementsMap.put(string, eDataObject);
        }
    }

    public EDataObject createElement(EDataObject eDataObject, String string, String string2, String string3, String string4) {
        EDataObject eDataObject2;
        block17: {
            eDataObject2 = this.getElement(string4);
            if (eDataObject2 == null) {
                if (FeatureManager.INSTANCE.isUnneededRmcFeature(string)) {
                    return null;
                }
                EStructuralFeature eStructuralFeature = FeatureManager.INSTANCE.getXmlFeature(eDataObject.eClass(), string, string3);
                if (eStructuralFeature == null) {
                    this.logger.logWarning(NLS.bind((String)ExportXMLResources.xmlLibrary_no_feature, (Object)eDataObject.eClass().getName(), (Object)string));
                    return null;
                }
                EClass eClass = FeatureManager.INSTANCE.getXmlEClass(string2);
                if (eClass == null) {
                    this.logger.logWarning(NLS.bind((String)ExportXMLResources.xmlLibrary_no_class, (Object)string2));
                    return null;
                }
                eDataObject2 = (EDataObject)EcoreUtil.create((EClass)eClass);
                this.setElement(string4, eDataObject2);
                if (eDataObject2 instanceof WorkOrder) {
                    return eDataObject2;
                }
                if (eStructuralFeature.isMany()) {
                    List list = (List)eDataObject.eGet(eStructuralFeature);
                    try {
                        if (eStructuralFeature instanceof EAttribute) {
                            list.add(string4);
                            this.addToContainer((EObject)eDataObject, (EObject)eDataObject2);
                            break block17;
                        }
                        if (eStructuralFeature instanceof EReference) {
                            try {
                                list.add(eDataObject2);
                            }
                            catch (RuntimeException runtimeException) {
                                runtimeException.printStackTrace();
                            }
                            break block17;
                        }
                        this.logger.logWarning(NLS.bind((String)ExportXMLResources.xmlLibrary_error_create_element, (Object)eStructuralFeature.getName()));
                    }
                    catch (RuntimeException runtimeException) {
                        this.logger.logError(NLS.bind((String)ExportXMLResources.xmlLibrary_error_set_value, (Object)eDataObject2, (Object)eDataObject), (Throwable)runtimeException);
                    }
                } else if (eStructuralFeature instanceof EAttribute) {
                    eDataObject.eSet(eStructuralFeature, (Object)string4);
                    this.addToContainer((EObject)eDataObject, (EObject)eDataObject2);
                } else if (eStructuralFeature instanceof EReference) {
                    eDataObject.eSet(eStructuralFeature, (Object)eDataObject2);
                } else {
                    this.logger.logWarning(NLS.bind((String)ExportXMLResources.xmlLibrary_error_create_element, (Object)eStructuralFeature.getName()));
                }
            }
        }
        return eDataObject2;
    }

    private void addToContainer(EObject eObject, EObject eObject2) {
        if (eObject == null) {
            return;
        }
        if (eObject instanceof ContentPackage) {
            ((ContentPackage)eObject).getContentElement().add((Object)eObject2);
        } else if (eObject instanceof ProcessPackage) {
            ((ProcessPackage)eObject).getProcessElement().add((Object)eObject2);
        } else {
            this.addToContainer(eObject.eContainer(), eObject2);
        }
    }

    public void setAtributeFeatureValue(EDataObject eDataObject, String string, Object object) throws Exception {
        if (eDataObject == null || string == null || object == null) {
            return;
        }
        if (object instanceof List || object instanceof EDataObject) {
            if (string.equals("methodElementProperty")) {
                this.setMepFeatureValue(eDataObject, string, object);
                return;
            }
            this.logger.logWarning(NLS.bind((String)ExportXMLResources.xmlLibrary_invalid_feature_value, (Object)string, (Object)object));
            return;
        }
        EStructuralFeature eStructuralFeature = FeatureManager.INSTANCE.getXmlFeature(eDataObject.eClass(), string);
        if (eStructuralFeature == null) {
            if (!(eDataObject instanceof WorkOrder)) {
                Object[] objectArray = new Object[]{string, eDataObject, object};
                this.logger.logWarning(NLS.bind((String)ExportXMLResources.xmlLibrary_error_set_value_2, (Object[])objectArray));
            }
            return;
        }
        if (eStructuralFeature == UmaPackage.eINSTANCE.getGuidanceDescription_Attachment()) {
            if (object != null) {
                object = this.contentProc.resolveAttachmentResources((Object)eDataObject, object.toString().trim());
            }
            eDataObject.eSet(eStructuralFeature, object);
        }
        if (eStructuralFeature instanceof EAttribute) {
            try {
                if (eStructuralFeature.getName().equals("variabilityType")) {
                    object = VariabilityType.get((String)object.toString());
                } else if (eStructuralFeature.getName().equals("linkType")) {
                    object = WorkOrderType.get((String)object.toString());
                } else if (object instanceof Date) {
                    object = this.getXmlDate((Date)object);
                } else if (this.contentProc != null && eDataObject instanceof MethodElement && object instanceof String) {
                    object = this.contentProc.resolveResourceFiles((Object)((MethodElement)eDataObject), (String)object);
                } else if (object instanceof java.net.URI) {
                    org.eclipse.epf.uma.MethodPlugin methodPlugin = ExportResourceHandler.getSourcePlugin((MethodElement)eDataObject);
                    object = String.valueOf(methodPlugin.getName()) + "/" + ((java.net.URI)object).getPath();
                    if (this.contentProc != null) {
                        this.contentProc.copyResource((String)object, (EObject)eDataObject, methodPlugin);
                    }
                }
                eDataObject.eSet(eStructuralFeature, object);
            }
            catch (RuntimeException runtimeException) {
                Object[] objectArray = new Object[]{string, eDataObject, object};
                this.logger.logError(NLS.bind((String)ExportXMLResources.xmlLibrary_error_set_value_2, (Object[])objectArray), (Throwable)runtimeException);
            }
        } else {
            System.out.println(ExportXMLResources.xmlLibrary_error_set_value_3);
        }
    }

    private void setMepFeatureValue(EDataObject eDataObject, String string, Object object) {
        List list = (List)object;
        if (list == null || list.isEmpty()) {
            return;
        }
        EStructuralFeature eStructuralFeature = FeatureManager.INSTANCE.getXmlFeature(eDataObject.eClass(), string);
        List list2 = (List)eDataObject.eGet(eStructuralFeature);
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof MethodElementProperty) {
                MethodElementProperty methodElementProperty = (MethodElementProperty)e;
                EClass eClass = FeatureManager.INSTANCE.getXmlEClass("MethodElementProperty");
                org.eclipse.epf.xml.uma.MethodElementProperty methodElementProperty2 = (org.eclipse.epf.xml.uma.MethodElementProperty)EcoreUtil.create((EClass)eClass);
                methodElementProperty2.setValue(methodElementProperty.getValue());
                methodElementProperty2.setName(methodElementProperty.getName());
                list2.add(methodElementProperty2);
            }
            ++n;
        }
    }

    public void setReferenceValue(EDataObject eDataObject, String string, String string2, Type type) throws Exception {
        EDataObject eDataObject2;
        if (eDataObject == null || string == null || string2 == null) {
            return;
        }
        if (FeatureManager.INSTANCE.isUnneededRmcFeature(string)) {
            return;
        }
        EStructuralFeature eStructuralFeature = FeatureManager.INSTANCE.getXmlFeature(eDataObject.eClass(), string, type.getName());
        if (eStructuralFeature == null) {
            Object[] objectArray = new Object[]{string, eDataObject, string2};
            this.logger.logWarning(NLS.bind((String)ExportXMLResources.xmlLibrary_error_set_reference, (Object[])objectArray));
            return;
        }
        String string3 = eStructuralFeature.getEType().getName();
        if (string3.equals("String")) {
            if (eStructuralFeature.isMany()) {
                List list = (List)eDataObject.eGet(eStructuralFeature);
                if (!list.contains(string2)) {
                    list.add(string2);
                }
            } else {
                eDataObject.eSet(eStructuralFeature, (Object)string2);
            }
        } else if (eStructuralFeature == UmaPackage.eINSTANCE.getActivity_BreakdownElement()) {
            EDataObject eDataObject3 = this.getElement(string2);
            if (eDataObject3 instanceof BreakdownElement) {
                EObject eObject = eDataObject3.eContainer();
                List list = (List)eDataObject.eGet(eStructuralFeature);
                if (!list.contains(eDataObject3)) {
                    list.add(eDataObject3);
                }
                if (eObject instanceof ProcessPackage && eObject.eContainer() instanceof ProcessComponent && ((ProcessPackage)eObject).getProcessElement().size() == 0) {
                    ((ProcessPackage)eObject.eContainer()).getMethodPackage().remove((Object)eObject);
                }
            }
        } else if (eStructuralFeature == UmaPackage.eINSTANCE.getWorkBreakdownElement_Predecessor() && (eDataObject2 = this.getElement(string2)) instanceof WorkOrder) {
            ((WorkBreakdownElement)eDataObject).getPredecessor().add((Object)eDataObject2);
        }
    }

    public Object getXmlDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String string = simpleDateFormat.format(date);
        string = string.replace(' ', 'T');
        EDataType eDataType = XMLTypePackage.eINSTANCE.getDateTime();
        return XMLTypeFactory.eINSTANCE.createFromString(eDataType, string);
    }

    private String getString(Object object) {
        String string = "";
        if (object instanceof MethodElement) {
            MethodElement methodElement = (MethodElement)object;
            string = String.valueOf(methodElement.getType().getName()) + ":" + methodElement.getName();
        } else if (object != null) {
            string = object.toString();
        }
        return string;
    }

    public void fixLibraryForImport() {
        this.fixGuid((MethodElement)this.rootObject);
        if (this.rootObject instanceof MethodLibrary) {
            Iterator iterator = this.rootObject.getMethodPlugin().iterator();
            while (iterator.hasNext()) {
                this.fixPlugin((MethodPlugin)iterator.next());
            }
        } else if (this.rootObject instanceof MethodPlugin) {
            this.fixPlugin((MethodPlugin)this.rootObject);
        }
    }

    public void fixLibraryForExport() {
        ArrayList arrayList = new ArrayList();
        TreeIterator treeIterator = this.rootObject.eAllContents();
        while (treeIterator.hasNext()) {
            Process process;
            Object e = treeIterator.next();
            if (!(e instanceof ProcessComponent) || (process = ((ProcessComponent)e).getProcess()) != null) continue;
            arrayList.add(e);
        }
        while (arrayList.size() > 0) {
            treeIterator = (EObject)arrayList.remove(0);
            EcoreUtil.remove((EObject)treeIterator);
        }
    }

    public void fixTaskDescriptorsForExport(Map<String, TaskDescriptor> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, TaskDescriptor> entry : map.entrySet()) {
            String string = entry.getKey();
            TaskDescriptor taskDescriptor = entry.getValue();
            org.eclipse.epf.xml.uma.TaskDescriptor taskDescriptor2 = (org.eclipse.epf.xml.uma.TaskDescriptor)this.elementsMap.get(string);
            assert (taskDescriptor2 != null);
            if (taskDescriptor2 == null) continue;
            List list = taskDescriptor.getSelectedSteps();
            int n = 0;
            while (n < list.size()) {
                org.eclipse.epf.uma.MethodElement methodElement = (org.eclipse.epf.uma.MethodElement)list.get(n);
                Section section = (Section)this.elementsMap.get(methodElement.getGuid());
                assert (section != null);
                if (section != null) {
                    section = (Section)EcoreUtil.copy((EObject)section);
                    taskDescriptor2.getStep().add((Object)section);
                }
                ++n;
            }
        }
    }

    public List getReferencedPlugins() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!(this.rootObject instanceof MethodLibrary)) {
            return arrayList;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (MethodPlugin methodPlugin : this.rootObject.getMethodPlugin()) {
            String string = methodPlugin.getId();
            arrayList2.add(string);
            if (arrayList.contains(string)) {
                arrayList.remove(string);
            }
            for (String string2 : methodPlugin.getReferencedMethodPlugin()) {
                if (arrayList2.contains(string2) || arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private void fixGuid(MethodElement methodElement) {
        Object object;
        if (methodElement == null) {
            return;
        }
        String string = methodElement.getId();
        if (string == null || string.equals("")) {
            string = EcoreUtil.generateUUID();
            methodElement.setId(string);
            object = NLS.bind((String)ExportXMLResources.xmlLibrary_new_id, (Object)this.getString(methodElement), (Object)string);
            this.logger.logWarning((String)object);
        } else {
            object = this.getElement(string);
            if (!(object == null || object == methodElement || object instanceof Section && methodElement instanceof Section)) {
                this.logger.logWarning(NLS.bind((String)ExportXMLResources.xmlLibrary_id_not_unique, (Object)string));
            }
            this.setElement(string, (EDataObject)methodElement);
        }
        for (Object e : methodElement.eContents()) {
            if (!(e instanceof MethodElement)) continue;
            this.fixGuid((MethodElement)e);
        }
    }

    private void fixPlugin(MethodPlugin methodPlugin) {
        ArrayList<EObject> arrayList = new ArrayList<EObject>();
        Object object = methodPlugin.eAllContents();
        while (object.hasNext()) {
            EObject eObject = (EObject)object.next();
            if (!this.isProcess(eObject)) continue;
            arrayList.add(eObject);
        }
        if (arrayList.size() > 0) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                this.fixProcess((Process)object.next());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean isProcess(EObject var1_1) {
        if (!(var1_1 instanceof Process)) {
            return false;
        }
        if (!((var1_1 = var1_1.eContainer()) instanceof ProcessComponent)) ** GOTO lbl7
        return true;
lbl-1000:
        // 1 sources

        {
            if (!(var1_1 instanceof ProcessComponent)) continue;
            return false;
lbl7:
            // 2 sources

            ** while ((var1_1 = var1_1.eContainer()) != null && var1_1 instanceof ProcessPackage)
        }
lbl8:
        // 1 sources

        return true;
    }

    private void fixProcess(Process process) {
        EDataObject eDataObject = (EDataObject)process.eContainer();
        ProcessComponent processComponent = null;
        if (eDataObject instanceof ProcessComponent) {
            return;
        }
        if (!(eDataObject instanceof ProcessPackage)) {
            String string = NLS.bind((String)ExportXMLResources.xmlLibrary_error_process_wrong_container, (Object)process.getName(), (Object)eDataObject.getType().getName());
            this.logger.logWarning(string);
            return;
        }
        processComponent = UmaFactory.eINSTANCE.createProcessComponent();
        String string = this.getTargetParentId(process.getId());
        if (string == null) {
            string = EcoreUtil.generateUUID();
        }
        processComponent.setId(string);
        processComponent.setName(process.getName());
        ((ProcessPackage)eDataObject).getProcessElement().remove((Object)process);
        ((ProcessPackage)eDataObject).getMethodPackage().add((Object)processComponent);
        processComponent.setProcess(process);
    }

    private String getTargetParentId(String string) {
        org.eclipse.epf.uma.MethodElement methodElement;
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null && (methodElement = iLibraryManager.getMethodElement(string)) != null && (methodElement = methodElement.eContainer()) instanceof org.eclipse.epf.uma.MethodElement) {
            return methodElement.getGuid();
        }
        return null;
    }

    public List getAllProcesses(MethodPackage methodPackage) {
        ArrayList arrayList = new ArrayList();
        this._iteratePackageForProcesses(methodPackage, arrayList);
        return arrayList;
    }

    private void _iteratePackageForProcesses(MethodPackage methodPackage, List list) {
        Object object;
        if (methodPackage instanceof ProcessComponent && (object = ((ProcessComponent)methodPackage).getProcess()) != null && !list.contains(object)) {
            list.add(object);
        }
        object = methodPackage.getMethodPackage().iterator();
        while (object.hasNext()) {
            this._iteratePackageForProcesses((MethodPackage)object.next(), list);
        }
    }

    protected void storeExtraInfo(List<org.eclipse.epf.uma.MethodPlugin> list) {
        if (list == null) {
            return;
        }
        EStructuralFeature eStructuralFeature = FeatureManager.INSTANCE.getXmlFeature(this.rootObject.eClass(), "methodElementProperty");
        List list2 = (List)this.rootObject.eGet(eStructuralFeature);
        EClass eClass = FeatureManager.INSTANCE.getXmlEClass("MethodElementProperty");
        org.eclipse.epf.xml.uma.MethodElementProperty methodElementProperty = (org.eclipse.epf.xml.uma.MethodElementProperty)EcoreUtil.create((EClass)eClass);
        methodElementProperty.setValue("0");
        list2.add(methodElementProperty);
        for (org.eclipse.epf.uma.MethodPlugin methodPlugin : list) {
            methodElementProperty = (org.eclipse.epf.xml.uma.MethodElementProperty)EcoreUtil.create((EClass)eClass);
            methodElementProperty.setValue(methodPlugin.getGuid());
            list2.add(methodElementProperty);
            methodElementProperty = (org.eclipse.epf.xml.uma.MethodElementProperty)EcoreUtil.create((EClass)eClass);
            methodElementProperty.setValue(methodPlugin.getName());
            list2.add(methodElementProperty);
        }
    }

    public Map<String, String> getGuidToPlugNameMap() {
        if (this.guidToPlugNameMap == null) {
            this.recallExtraInfo();
        }
        return this.guidToPlugNameMap;
    }

    private void recallExtraInfo() {
        try {
            EStructuralFeature eStructuralFeature = FeatureManager.INSTANCE.getXmlFeature(this.rootObject.eClass(), "methodElementProperty");
            List list = (List)this.rootObject.eGet(eStructuralFeature);
            if (list == null || list.isEmpty()) {
                return;
            }
            this.guidToPlugNameMap = new HashMap<String, String>();
            org.eclipse.epf.xml.uma.MethodElementProperty methodElementProperty = (org.eclipse.epf.xml.uma.MethodElementProperty)list.get(0);
            if (methodElementProperty.getValue().equals("0")) {
                int n = 1;
                while (n < list.size()) {
                    String string = ((org.eclipse.epf.xml.uma.MethodElementProperty)list.get(n)).getValue();
                    String string2 = ((org.eclipse.epf.xml.uma.MethodElementProperty)list.get(n + 1)).getValue();
                    this.guidToPlugNameMap.put(string, string2);
                    n += 2;
                }
            }
        }
        catch (Exception exception) {
            this.guidToPlugNameMap = new HashMap<String, String>();
            exception.printStackTrace();
        }
    }
}

