/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.export.services.PluginExportData;
import org.eclipse.epf.export.xml.ExportXMLPlugin;
import org.eclipse.epf.export.xml.ExportXMLResources;
import org.eclipse.epf.export.xml.preferences.ExportXMLPreferences;
import org.eclipse.epf.export.xml.services.ExportXMLData;
import org.eclipse.epf.export.xml.services.ExportXMLService;
import org.eclipse.epf.export.xml.wizards.SelectConfigPage;
import org.eclipse.epf.export.xml.wizards.SelectExportTypePage;
import org.eclipse.epf.export.xml.wizards.SelectPluginPage;
import org.eclipse.epf.export.xml.wizards.SelectXMLFilePage;
import org.eclipse.epf.export.xml.wizards.ViewExportSummaryPage;
import org.eclipse.epf.export.xml.wizards.ViewPluginInfoPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportXMLWizard
extends Wizard
implements IImportWizard {
    private SelectExportTypePage selectExportTypePage;
    protected SelectPluginPage selectPluginPage;
    protected ViewPluginInfoPage viewPluginInfoPage;
    protected ViewExportSummaryPage viewExportSummaryPage;
    protected SelectConfigPage selectConfigPage;
    protected SelectXMLFilePage selectXMLFilePage;
    protected ExportXMLData xmlData = new ExportXMLData();
    protected PluginExportData pluginData = new PluginExportData();
    protected ConfigurationExportData configData = new ConfigurationExportData();

    public ExportXMLWizard() {
        this.setWindowTitle(ExportXMLResources.exportXMLWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        this.selectExportTypePage = new SelectExportTypePage();
        this.selectPluginPage = new SelectPluginPage(this.pluginData);
        this.viewPluginInfoPage = new ViewPluginInfoPage(this.pluginData);
        this.viewExportSummaryPage = new ViewExportSummaryPage(this.pluginData);
        this.selectConfigPage = new SelectConfigPage(this.configData);
        this.selectXMLFilePage = new SelectXMLFilePage();
        this.addPage((IWizardPage)this.selectExportTypePage);
        this.addPage((IWizardPage)this.selectPluginPage);
        this.addPage((IWizardPage)this.viewPluginInfoPage);
        this.addPage((IWizardPage)this.viewExportSummaryPage);
        this.addPage((IWizardPage)this.selectConfigPage);
        this.addPage((IWizardPage)this.selectXMLFilePage);
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        composite.getShell().setImage(ExportXMLPlugin.getDefault().getSharedImage("full/obj16/XMLFile.gif"));
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.selectXMLFilePage && this.selectXMLFilePage.isPageComplete();
    }

    public boolean performFinish() {
        boolean bl;
        String string = this.selectXMLFilePage.getPath();
        File file = new File(string);
        if (file.exists() && !(bl = ExportXMLPlugin.getDefault().getMsgDialog().displayPrompt(ExportXMLResources.exportXMLWizard_title, ExportXMLResources.bind((String)ExportXMLResources.overwriteText_msg, (Object[])new String[]{string})))) {
            return false;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                ExportXMLService exportXMLService = null;
                try {
                    try {
                        iProgressMonitor.beginTask(ExportXMLResources.exportingXML_text, -1);
                        ExportXMLWizard.this.xmlData.setXMLFile(ExportXMLWizard.this.selectXMLFilePage.getPath());
                        exportXMLService = new ExportXMLService(ExportXMLWizard.this.xmlData);
                        exportXMLService.doExport(iProgressMonitor);
                        ExportXMLPreferences.setExportType(ExportXMLWizard.this.xmlData.getExportType());
                        ExportXMLPreferences.setXMLFile(ExportXMLWizard.this.xmlData.getXMLFile());
                    }
                    catch (Exception exception) {
                        throw new InvocationTargetException(exception);
                    }
                }
                finally {
                    iProgressMonitor.done();
                    if (exportXMLService != null) {
                        exportXMLService.dispose();
                    }
                }
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            ExportXMLPlugin.getDefault().getMsgDialog().displayError(ExportXMLResources.exportXMLWizard_title, NLS.bind((String)ExportXMLResources.exportXMLWizard_error, (Object)throwable.getMessage()), throwable);
            return false;
        }
        String string2 = ExportXMLResources.exportXMLWizard_reviewLog;
        MsgBox.prompt((String)string2, (int)32);
        return true;
    }
}

