/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.prefs.PreferenceUtil;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ConfigurationContributionItem
extends ContributionItem {
    private static Combo configCombo;
    private static ComboViewer configComboViewer;
    protected ToolItem item;
    protected CoolItem coolItem;
    protected ILibraryServiceListener libSvcListener;
    protected IStructuredContentProvider contentProvider;
    protected ILabelProvider labelProvider;
    protected ISelectionChangedListener postSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ConfigurationContributionItem.performSelectionChanged();
        }
    };

    public ConfigurationContributionItem(IAction iAction) {
    }

    public void fill(ToolBar toolBar, int n) {
        this.item = new ToolItem(toolBar, 2);
        Control control = this.createControl((Composite)toolBar);
        this.item.setControl(control);
        this.item.setWidth(240);
    }

    public void fill(CoolBar coolBar, int n) {
        Control control = this.createControl((Composite)coolBar);
        this.coolItem = n >= 0 ? new CoolItem(coolBar, 4, n) : new CoolItem(coolBar, 4);
        this.coolItem.setData((Object)this);
        this.coolItem.setControl(control);
        Point point = control.computeSize(-1, -1);
        this.coolItem.setMinimumSize(point);
        this.coolItem.setPreferredSize(point);
        this.coolItem.setSize(point);
    }

    public void fill(Composite composite) {
        this.createControl(composite);
    }

    private Control createControl(Composite composite) {
        configCombo = new Combo(composite, 12);
        configCombo.setVisibleItemCount(10);
        configCombo.setEnabled(true);
        configComboViewer = new ComboViewer(configCombo);
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll((Collection)Arrays.asList(LibraryServiceUtil.getMethodConfigurations((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary())));
                Collections.sort(arrayList, Comparators.DEFAULT_COMPARATOR);
                if (LibraryService.getInstance().getCurrentMethodConfiguration() == null) {
                    arrayList.add(0, LibraryUIResources.selectConfigLabel_text);
                }
                return arrayList.toArray();
            }
        };
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public String getText(Object object) {
                if (object instanceof String) {
                    return (String)object;
                }
                if (object instanceof MethodConfiguration) {
                    return ((MethodConfiguration)object).getName();
                }
                return object.toString();
            }
        };
        configComboViewer.setContentProvider((IContentProvider)this.contentProvider);
        configComboViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        configComboViewer.setInput((Object)LibraryService.getInstance().getCurrentMethodLibrary());
        String string = PreferenceUtil.getSavedLastConfig();
        MethodConfiguration methodConfiguration = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)string);
        if (methodConfiguration != null) {
            configComboViewer.setSelection((ISelection)new StructuredSelection((Object)methodConfiguration));
        } else {
            configComboViewer.setSelection((ISelection)new StructuredSelection((Object)LibraryUIResources.selectConfigLabel_text));
        }
        configComboViewer.addPostSelectionChangedListener(this.postSelectionChangedListener);
        configComboViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ConfigurationContributionItem.this.dispose();
            }
        });
        this.libSvcListener = new ILibraryServiceListener(){

            public void configurationSet(MethodConfiguration methodConfiguration) {
                ConfigurationContributionItem.selectConfiguration(methodConfiguration);
            }

            public void libraryClosed(MethodLibrary methodLibrary) {
                configComboViewer.setInput(null);
            }

            public void libraryCreated(MethodLibrary methodLibrary) {
                configComboViewer.setInput((Object)methodLibrary);
                ConfigurationContributionItem.selectConfiguration(null);
            }

            public void libraryOpened(MethodLibrary methodLibrary) {
                configComboViewer.setInput((Object)methodLibrary);
                configComboViewer.setSelection((ISelection)new StructuredSelection((Object)LibraryUIResources.selectConfigLabel_text), true);
                ConfigurationContributionItem.refresh();
            }

            public void libraryReopened(MethodLibrary methodLibrary) {
                if (methodLibrary != configComboViewer.getInput()) {
                    configComboViewer.setInput((Object)methodLibrary);
                    ConfigurationContributionItem.refresh();
                }
            }

            public void librarySet(MethodLibrary methodLibrary) {
                if (methodLibrary != configComboViewer.getInput()) {
                    configComboViewer.setInput((Object)methodLibrary);
                    if (methodLibrary == null) {
                        ConfigurationContributionItem.selectConfiguration(null);
                    } else {
                        ConfigurationContributionItem.refresh();
                    }
                }
            }
        };
        LibraryService.getInstance().addListener(this.libSvcListener);
        return configCombo;
    }

    public void setVisibile(boolean bl) {
        if (bl) {
            LibraryService.getInstance().addListener(this.libSvcListener);
        } else {
            LibraryService.getInstance().removeListener(this.libSvcListener);
        }
        super.setVisible(bl);
    }

    private static MethodConfiguration getSelectedConfig() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)configComboViewer.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof MethodConfiguration) {
            return (MethodConfiguration)object;
        }
        return null;
    }

    private static String getCurrentSelectedConfigName() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)configComboViewer.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object != null && object instanceof MethodConfiguration) {
            return ((MethodConfiguration)object).getName();
        }
        if (object instanceof String) {
            return (String)object;
        }
        return "";
    }

    private static void performSelectionChanged() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() != null) {
            MethodConfiguration methodConfiguration = ConfigurationContributionItem.getSelectedConfig();
            if (methodConfiguration != LibraryService.getInstance().getCurrentMethodConfiguration()) {
                LibraryService.getInstance().setCurrentMethodConfiguration(methodConfiguration);
            }
            PreferenceUtil.saveSelectedConfigIntoPersistence((String)ConfigurationContributionItem.getCurrentSelectedConfigName());
            ConfigurationContributionItem.refresh();
        }
    }

    public void dispose() {
        if (this.libSvcListener != null) {
            LibraryService.getInstance().removeListener(this.libSvcListener);
        }
        if (configComboViewer != null) {
            configComboViewer.removePostSelectionChangedListener(this.postSelectionChangedListener);
        }
        super.dispose();
    }

    private static void refresh() {
        configComboViewer.refresh();
    }

    private static void selectConfiguration(MethodConfiguration methodConfiguration) {
        if (methodConfiguration != null && methodConfiguration == ConfigurationContributionItem.getSelectedConfig()) {
            return;
        }
        if (methodConfiguration != null) {
            configComboViewer.setSelection((ISelection)new StructuredSelection((Object)methodConfiguration));
        } else {
            ConfigurationContributionItem.refresh();
            configComboViewer.setSelection((ISelection)new StructuredSelection((Object)LibraryUIResources.selectConfigLabel_text), true);
        }
    }
}

