/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.io.File;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.epf.persistence.IFileInfo;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.osgi.util.NLS;
import sun.security.action.GetPropertyAction;

public class FileManager
implements IFileManager {
    public static final String PLUGIN_ID = FileManager.class.getPackage().getName();
    private static FileManager instance = null;
    private static String tmpdir;
    private boolean validateEditInitialized = false;

    public static String getTempDir() {
        if (tmpdir == null) {
            GetPropertyAction getPropertyAction = new GetPropertyAction("java.io.tmpdir");
            tmpdir = AccessController.doPrivileged(getPropertyAction);
        }
        return tmpdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final FileManager getInstance() {
        if (instance != null) return instance;
        Class<FileManager> clazz = FileManager.class;
        synchronized (FileManager.class) {
            if (instance != null) return instance;
            instance = new FileManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected FileManager() {
    }

    public static IResource getResourceForLocation(String string) {
        IFile iFile;
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(string);
        if (file.isFile()) {
            IResource iResource;
            iFile = iWorkspaceRoot.getFileForLocation((IPath)path);
            if (iFile == null && (iResource = FileManager.getResourceForLocation(file.getParent())) != null) {
                try {
                    iResource.refreshLocal(1, null);
                }
                catch (CoreException coreException) {}
                iFile = iWorkspaceRoot.getFileForLocation((IPath)path);
            }
        } else {
            iFile = iWorkspaceRoot.getContainerForLocation((IPath)path);
        }
        return iFile;
    }

    public static boolean refresh(IResource iResource) throws CoreException {
        if (!iResource.exists()) {
            ArrayList<IContainer> arrayList = new ArrayList<IContainer>();
            IContainer iContainer = iResource.getParent();
            while (!iContainer.exists()) {
                arrayList.add(0, iContainer);
                iContainer = iContainer.getParent();
            }
            if (iContainer.exists()) {
                iContainer.refreshLocal(1, null);
            }
            if (!arrayList.isEmpty()) {
                for (IFolder iFolder : arrayList) {
                    if (iFolder.exists()) {
                        iFolder.refreshLocal(1, null);
                        continue;
                    }
                    return false;
                }
            }
        }
        iResource.refreshLocal(1, null);
        return true;
    }

    private static boolean refresh(String string) throws CoreException {
        IResource iResource = FileManager.getResourceForLocation(string);
        if (iResource != null) {
            return FileManager.refresh(iResource);
        }
        return false;
    }

    public boolean refresh(Resource resource) {
        try {
            return FileManager.refresh(resource.getURI().toFileString());
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean move(String string, String string2) {
        return this.move(string, string2, false);
    }

    /*
     * Unable to fully structure code
     */
    public boolean move(String var1_1, String var2_2, boolean var3_3) {
        block22: {
            try {
                block23: {
                    FileManager.refresh(var1_1);
                    var4_4 = null;
                    var5_6 = ResourcesPlugin.getWorkspace().getRoot();
                    var6_7 = new Path(var2_2);
                    if (new File(var1_1).isFile()) {
                        var4_4 = var5_6.getFileForLocation((IPath)var6_7);
                        if (var4_4 == null) {
                            var4_4 = var5_6.getContainerForLocation((IPath)var6_7);
                        }
                    } else {
                        var4_4 = var5_6.getContainerForLocation((IPath)var6_7);
                        if (var4_4 == null) {
                            var4_4 = var5_6.getFileForLocation((IPath)var6_7);
                        }
                    }
                    if (var4_4 != null) {
                        if (var4_4.exists()) {
                            var4_4.refreshLocal(0, null);
                            if (var4_4.exists()) {
                                throw new MultiFileIOException(NLS.bind((String)PersistenceResources.moveError_msg, (Object)var1_1, (Object)var2_2));
                            }
                        }
                        var7_8 = new ArrayList();
                        var8_9 = var4_4.getParent();
                        while (!var8_9.exists()) {
                            var7_8.add(0, var8_9);
                            var8_9 = var8_9.getParent();
                        }
                        if (!var7_8.isEmpty()) {
                            var8_9.refreshLocal(1, null);
                            for (IFolder var10_12 : var7_8) {
                                if (!var10_12.exists()) {
                                    var10_12.create(true, true, null);
                                    continue;
                                }
                                var10_12.refreshLocal(1, null);
                            }
                        }
                        var6_7 = var4_4.getFullPath();
                    } else if (Platform.getLocation().isPrefixOf((IPath)var6_7)) {
                        var6_7 = new Path(var6_7.toOSString().substring(Platform.getLocation().toOSString().length()));
                    }
                    var7_8 = new Path(var1_1);
                    var8_9 = var5_6.getFileForLocation((IPath)var7_8);
                    var4_4 = var8_9 != null && var8_9.exists() != false ? var8_9 : var5_6.getContainerForLocation((IPath)var7_8);
                    if (var4_4 == null) break block22;
                    try {
                        var4_4.move((IPath)var6_7, true, null);
                        break block23;
                    }
                    catch (ResourceException var9_11) {
                        PersistencePlugin.getDefault().getLog().log(var9_11.getStatus());
                        if (var3_3) {
                            throw var9_11;
                        }
                        var10_13 = false;
                        var11_14 = var9_11.getStatus().getChildren();
                        var12_15 = 0;
                        ** while (var12_15 < var11_14.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var13_16 = var11_14[var12_15];
                        if (var13_16.getCode() == 273 && var13_16.getMessage() == Messages.localstore_deleteProblem) {
                            var14_17 = MessageFormat.format("Warning while moving ''{0}'' to ''{1}'': {2}", new Object[]{var1_1, var2_2, var13_16.getMessage()});
                            PersistencePlugin.getDefault().getLogger().logWarning(var14_17);
                        } else {
                            var10_13 = true;
                        }
                        ++var12_15;
                        continue;
                    }
lbl61:
                    // 1 sources

                    if (var10_13 || !new File(var2_2).exists()) {
                        return false;
                    }
                }
                return true;
            }
            catch (CoreException var4_5) {
                PersistencePlugin.getDefault().getLogger().logError((Throwable)var4_5);
                if (!MultiFileSaveUtil.DEBUG) break block22;
                var4_5.printStackTrace();
            }
        }
        return false;
    }

    public boolean rename(File file, File file2) {
        return this.move(file.getAbsolutePath(), file2.getAbsolutePath());
    }

    public void deleteResource(String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IResource iResource = FileManager.getResourceForLocation(string);
        if (iResource != null) {
            iResource.delete(true, iProgressMonitor);
        }
    }

    public boolean delete(String string) {
        try {
            this.deleteResource(string, null);
            return true;
        }
        catch (CoreException coreException) {
            CommonPlugin.INSTANCE.log((Object)coreException);
            if (MultiFileSaveUtil.DEBUG) {
                coreException.printStackTrace();
            }
            return false;
        }
    }

    private static boolean fromCC(IStatus iStatus) {
        String string = iStatus.getPlugin();
        return string != null && string.toLowerCase().indexOf("clearcase") != -1;
    }

    public IStatus checkModify(String[] stringArray, Object object) {
        IFile iFile;
        String string;
        IStatus iStatus = null;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IFile[] iFileArray = new IFile[stringArray.length];
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            try {
                FileManager.refresh(string);
            }
            catch (CoreException coreException) {
                PersistencePlugin.getDefault().getLogger().logError((Throwable)coreException);
            }
            iFile = iWorkspace.getRoot().getFileForLocation((IPath)new Path(string));
            if (iFile == null) {
                arrayList.add(string);
            } else {
                iFileArray[n] = iFile;
            }
            ++n;
        }
        if (!arrayList.isEmpty()) {
            return new Status(2, PLUGIN_ID, 2, NLS.bind((String)PersistenceResources.fileNotFoundError_msg, arrayList), null);
        }
        if (!this.validateEditInitialized) {
            iStatus = iWorkspace.validateEdit(iFileArray, object);
            this.validateEditInitialized = true;
            if (iStatus.isOK()) {
                iStatus = iWorkspace.validateEdit(iFileArray, object);
            }
        } else {
            iStatus = iWorkspace.validateEdit(iFileArray, object);
        }
        if (iStatus.isOK()) {
            MultiStatus multiStatus = new MultiStatus(PLUGIN_ID, 0, PersistenceResources.modifyFilesError_msg, null);
            int n2 = 0;
            while (n2 < iFileArray.length) {
                iFile = iFileArray[n2];
                try {
                    iFile.refreshLocal(0, null);
                }
                catch (CoreException coreException) {
                    CommonPlugin.INSTANCE.log((Object)coreException);
                }
                if (iFile.isReadOnly()) {
                    String string2 = iFile.getLocation().toOSString();
                    String string3 = MessageFormat.format(PersistenceResources.FileManager_fileReadOnly, string2);
                    multiStatus.add((IStatus)new ResourceStatus(4, 0, iFile.getFullPath(), string3, null));
                }
                ++n2;
            }
            if (!multiStatus.isOK()) {
                return multiStatus;
            }
        } else if (FileManager.fromCC(iStatus)) {
            String string4 = PersistenceResources.modifyFilesError_msg;
            string = new MultiStatus(PLUGIN_ID, iStatus.getCode(), string4, null);
            string.add(iStatus);
            return string;
        }
        if (iStatus instanceof MultiStatus) {
            MultiStatus multiStatus = (MultiStatus)iStatus;
            int n3 = 0;
            while (n3 < multiStatus.getChildren().length) {
                iFile = multiStatus.getChildren()[n3];
                multiStatus.getChildren()[n3] = FileManager.toStatusWithLocalPath((IStatus)iFile);
                ++n3;
            }
        } else {
            iStatus = FileManager.toStatusWithLocalPath(iStatus);
        }
        return iStatus;
    }

    private static IStatus toStatusWithLocalPath(IStatus iStatus) {
        if (iStatus instanceof IResourceStatus && iStatus.getCode() == 279) {
            IResourceStatus iResourceStatus = (IResourceStatus)iStatus;
            IPath iPath = iResourceStatus.getPath();
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
            String string = iFile.getLocation().toOSString();
            String string2 = MessageFormat.format(PersistenceResources.FileManager_fileReadOnly, string);
            return new ResourceStatus(iStatus.getSeverity(), iStatus.getCode(), iResourceStatus.getPath(), string2, iStatus.getException());
        }
        return iStatus;
    }

    public IStatus checkModify(String string, Object object) {
        return this.checkModify(new String[]{string}, object);
    }

    public boolean isTeamPrivate(String string) {
        IResource iResource = FileManager.getResourceForLocation(string);
        return iResource != null && iResource.isTeamPrivateMember();
    }

    public static IFile getFile(URI uRI, URIConverter uRIConverter) {
        URI uRI2;
        IFile iFile = null;
        if ("platform".equals(uRI.scheme()) && uRI.segmentCount() > 2) {
            if ("resource".equals(uRI.segment(0))) {
                IPath iPath = new Path(URI.decode((String)uRI.path())).removeFirstSegments(1);
                iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
            }
        } else if (uRI.isFile() && !uRI.isRelative()) {
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uRI.toFileString()));
        } else if (uRIConverter != null && !uRI.equals((Object)(uRI2 = uRIConverter.normalize(uRI)))) {
            iFile = FileManager.getFile(uRI2, uRIConverter);
        }
        return iFile;
    }

    public static String toFileString(URI uRI, URIConverter uRIConverter) {
        if (uRI.isFile()) {
            return uRI.toFileString();
        }
        IFile iFile = FileManager.getFile(uRI, uRIConverter);
        return iFile != null ? iFile.getLocation().toOSString() : null;
    }

    public static String toFileString(URI uRI) {
        return FileManager.toFileString(uRI, null);
    }

    public IFileInfo getFileInfo(Resource resource) {
        IFile iFile = WorkspaceSynchronizer.getFile((Resource)resource);
        return iFile != null ? new FileInfo(iFile) : null;
    }

    public static class FileInfo
    implements IFileInfo {
        private IFile file;

        private FileInfo(IFile iFile) {
            this.file = iFile;
        }

        public long getModificationStamp() {
            return this.file.getModificationStamp();
        }

        public boolean isSynchronized() {
            return this.file.isSynchronized(0);
        }

        public File getFile() {
            IPath iPath = this.file.getLocation();
            return iPath != null ? this.file.getLocation().toFile() : null;
        }
    }
}

