/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.epf.common.serviceability.EPFVersions;
import org.eclipse.epf.common.serviceability.VersionUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.uma.MethodElement;

public class MultiFileXMISaveImpl
extends XMISaveImpl {
    public static final String SAVE_SEPARATELY_CLASS_SET = "SAVE_SEPARATELY_CLASS_SET";
    public static final String SAVE_ALL = "SAVE_ALL";
    public static final String SAVE_TOGETHER_CLASS_SET = "SAVE_TOGETHER_CLASS_SET";
    public static final String BACK_UP_BEFORE_SAVE = "BACK_UP_BEFORE_SAVE";
    public static final String DISCARD_UNRESOLVED_REFERENCES = "DISCARD_UNRESOLVED_REFERENCES";
    static final String MODIFIED_RESOURCE_SET = "MODIFIED_RESOURCE_SET";
    static final String TX_RECORD = "TX_RECORD";
    public static final String MULTI_FILE = "MULTI_FILE";
    public static final String REFRESH_NEW_RESOURCE = "REFRESH_NEW_RESOURCE";
    public static final String CHECK_MODIFY = "CHECK_MODIFY";
    private Set saveSeparatelyClassSet;
    private Map options;

    public MultiFileXMISaveImpl(XMLHelper xMLHelper) {
        super(xMLHelper);
    }

    XMLHelper getXMLHelper() {
        return this.helper;
    }

    protected void init(XMLResource xMLResource, Map map) {
        super.init(xMLResource, map);
        this.saveSeparatelyClassSet = (Set)map.get(SAVE_SEPARATELY_CLASS_SET);
        this.options = map;
        Object object = xMLResource.getResourceSet();
        if (object == null) {
            object = new MultiFileResourceSetImpl();
            object.getResources().add((Object)xMLResource);
        }
    }

    boolean canSaveSeparately(Object object) {
        return MultiFileSaveUtil.hasOwnResource(object, this.saveSeparatelyClassSet);
    }

    private String getUmaHREF(Resource resource, InternalEObject internalEObject) {
        if (internalEObject.eIsProxy() && internalEObject.eProxyURI().scheme().equals("uma")) {
            return internalEObject.eProxyURI().toString();
        }
        String string = null;
        if (internalEObject instanceof MethodElement) {
            string = this.helper.getHREF((EObject)internalEObject);
        }
        if (string == null) {
            PersistencePlugin.getDefault().getLogger().logError("Could not find resource descriptor for resource " + resource + "\n  object: " + internalEObject);
            return MultiFileSaveUtil.getHREF(resource, internalEObject);
        }
        return string;
    }

    protected void saveHref(EObject eObject, EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment() && !this.toDOM) {
            String string = this.helper.getHREF(eObject);
            if (string != null) {
                String string2;
                if (this.escapeURI != null) {
                    string = this.escapeURI.convert(string);
                }
                String string3 = this.helper.getQName(eStructuralFeature);
                this.doc.startElement(string3);
                EClass eClass = eObject.eClass();
                EClass eClass2 = (EClass)eStructuralFeature.getEType();
                if (this.saveTypeInfo ? this.xmlTypeInfo.shouldSaveType(eClass, eClass2, eStructuralFeature) : eClass != eClass2 && eClass2.isAbstract()) {
                    this.saveTypeAttribute(eClass);
                }
                if ((string2 = this.helper.getID(eObject)) != null) {
                    this.doc.addAttribute(this.idAttributeName, string2);
                }
                this.doc.addAttribute("href", string);
                if (this.eObjectToExtensionMap != null) {
                    this.processAttributeExtensions(eObject);
                    if (this.processElementExtensions(eObject)) {
                        this.doc.endElement();
                    } else {
                        this.doc.endEmptyElement();
                    }
                } else {
                    this.doc.endEmptyElement();
                }
            }
            return;
        }
        super.saveHref(eObject, eStructuralFeature);
    }

    protected boolean saveFeatures(EObject eObject) {
        block9: {
            InternalEObject internalEObject;
            MultiFileXMIResourceImpl multiFileXMIResourceImpl;
            block10: {
                try {
                    Object object;
                    multiFileXMIResourceImpl = (MultiFileXMIResourceImpl)eObject.eResource();
                    if (multiFileXMIResourceImpl == null) break block9;
                    EObject eObject2 = eObject.eContainer();
                    internalEObject = (InternalEObject)eObject;
                    if (!(eObject instanceof MethodElement) || !this.canSaveSeparately(eObject) || eObject2 == null) break block10;
                    boolean bl = multiFileXMIResourceImpl == eObject2.eResource();
                    MethodElement methodElement = (MethodElement)eObject;
                    URI uRI = MultiFileSaveUtil.createURI(methodElement, multiFileXMIResourceImpl.getResourceSet());
                    if (bl) {
                        if (!internalEObject.eIsProxy()) {
                            multiFileXMIResourceImpl = (MultiFileXMIResourceImpl)MultiFileSaveUtil.save(eObject, uRI, this.options);
                        }
                    } else {
                        MultiFileURIConverter multiFileURIConverter;
                        object = MultiFileSaveUtil.getResourceManager(eObject2.eResource());
                        if (object != null && object.getResourceDescriptor(methodElement.getGuid()) == null && (multiFileURIConverter = (MultiFileURIConverter)multiFileXMIResourceImpl.getResourceSet().getURIConverter()).findResourceDescriptor(methodElement.getGuid()) == null) {
                            MultiFileSaveUtil.registerWithResourceManager((ResourceManager)object, methodElement, multiFileXMIResourceImpl.getFinalURI());
                        }
                    }
                    object = this.getUmaHREF(multiFileXMIResourceImpl, internalEObject);
                    this.doc.addAttribute("href", (String)object);
                    this.endSaveFeatures(eObject, 0, null);
                    return true;
                }
                catch (RuntimeException runtimeException) {
                    CommonPlugin.INSTANCE.log((Object)runtimeException);
                    if (MultiFileSaveUtil.DEBUG) {
                        runtimeException.printStackTrace();
                        System.err.println("ERROR saving feature: " + eObject);
                        System.err.println("  Feature resource: " + eObject.eResource());
                    }
                    throw runtimeException;
                }
            }
            if (!(eObject instanceof ResourceManager) || this.helper.getResource() == multiFileXMIResourceImpl) break block9;
            String string = this.getUmaHREF(multiFileXMIResourceImpl, internalEObject);
            this.doc.addAttribute("href", string);
            this.endSaveFeatures(eObject, 0, null);
            return true;
        }
        return super.saveFeatures(eObject);
    }

    public void addNamespaceDeclarations() {
        super.addNamespaceDeclarations();
        if (!this.toDOM) {
            for (String string : VersionUtil.getAllToolIDs()) {
                EPFVersions ePFVersions = VersionUtil.getVersions((String)string);
                String string2 = ePFVersions.getNsURI();
                this.doc.addAttribute("xmlns:" + string, string2);
                String string3 = ePFVersions.getMinToolVersionForCurrentLibraryVersion().getToolVersion().toString();
                this.doc.addAttribute(String.valueOf(string) + ":version", string3);
            }
        }
    }

    public static boolean checkModifyRequired(Map map) {
        Object v = map.get(CHECK_MODIFY);
        return v != null ? Boolean.valueOf(v.toString()) : false;
    }

    public static class MyEscape
    extends XMLSaveImpl.Escape {
        public MyEscape() {
            this.setMappingLimit(0x10FFFF);
        }
    }
}

