/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.migration.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.mapping.ecore2xml.Ecore2XMLPackage;
import org.eclipse.emf.mapping.ecore2xml.Ecore2XMLRegistry;
import org.eclipse.emf.mapping.ecore2xml.impl.Ecore2XMLRegistryImpl;
import org.eclipse.emf.mapping.ecore2xml.util.Ecore2XMLExtendedMetaData;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIHelperImpl;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.migration.UMA2UMAResourceHandler;
import org.eclipse.epf.persistence.migration.internal.UMA2UMAResourceHandler0;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.UmaUtil;

public class Migrator {
    private static final String[] NS_URIs = new String[]{"http:///com/ibm/uma.ecore", "http:///com/ibm/uma.ecore", "http://www.ibm.com/uma/1.0.2/uma.ecore"};
    private static final URI[] ECORE2XML_URIs = new URI[]{URI.createURI((String)"platform:/plugin/com.ibm.rpm.library.persistence/migration/uma.ecore2xml"), URI.createURI((String)"platform:/plugin/com.ibm.rpm.library.persistence/migration/uma2.ecore2xml"), URI.createURI((String)"platform:/plugin/com.ibm.rpm.library.persistence/migration/uma3.ecore2xml")};
    public static final String OLD_UMA_NS_URI = "http:///com/ibm/uma.ecore";
    public static final String UMA_NS_URI = "http://www.ibm.com/uma/1.0.2/uma.ecore";
    private ExtendedMetaData[] extendedMetaDatas;
    private UMA2UMAResourceHandler0 resourceHandler;
    public HashMap oldPathToNewURIMap = new HashMap();
    public Collection anyTypeFeatureValues = new ArrayList();

    private static final ExtendedMetaData getExtendedMetaData(String string, URI uRI) {
        EPackageRegistryImpl ePackageRegistryImpl = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        ePackageRegistryImpl.put((Object)string, (Object)UmaPackage.eINSTANCE);
        Ecore2XMLRegistryImpl ecore2XMLRegistryImpl = new Ecore2XMLRegistryImpl(Ecore2XMLRegistry.INSTANCE);
        ecore2XMLRegistryImpl.put((Object)string, EcoreUtil.getObjectByType((Collection)new ResourceSetImpl().getResource(uRI, true).getContents(), (EClassifier)Ecore2XMLPackage.eINSTANCE.getXMLMap()));
        return new Ecore2XMLExtendedMetaData((EPackage.Registry)ePackageRegistryImpl, (Ecore2XMLRegistry)ecore2XMLRegistryImpl){

            public EClassifier getType(EPackage ePackage, String string) {
                EClassifier eClassifier = super.getType(ePackage, string);
                if (eClassifier == null) {
                    EList eList = ePackage.getEClassifiers();
                    int n = 0;
                    int n2 = eList.size();
                    while (n < n2) {
                        EClassifier eClassifier2 = (EClassifier)eList.get(n);
                        if (string.equals(eClassifier2.getName())) {
                            return eClassifier2;
                        }
                        ++n;
                    }
                }
                return eClassifier;
            }
        };
    }

    public Migrator() {
        this(NS_URIs, ECORE2XML_URIs);
    }

    public Migrator(String[] stringArray, URI[] uRIArray) {
        int n = uRIArray.length;
        this.extendedMetaDatas = new ExtendedMetaData[n];
        int n2 = 0;
        while (n2 < uRIArray.length) {
            this.extendedMetaDatas[n2] = Migrator.getExtendedMetaData(stringArray[n2], uRIArray[n2]);
            ++n2;
        }
        this.resourceHandler = new UMA2UMAResourceHandler0();
    }

    private static void updateStatus(IProgressMonitor iProgressMonitor, String string) {
        if (iProgressMonitor != null) {
            iProgressMonitor.setTaskName(string);
        } else {
            System.out.println(string);
        }
    }

    public void migrate(String string, IProgressMonitor iProgressMonitor) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("Technique");
        MigratorResourceSet migratorResourceSet = new MigratorResourceSet();
        int n = 0;
        while (n < this.extendedMetaDatas.length) {
            migratorResourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            if (n < 2) {
                migratorResourceSet.getLoadOptions().put("RESOURCE_HANDLER", this.resourceHandler);
            }
            migratorResourceSet.getLoadOptions().put("EXTENDED_META_DATA", this.extendedMetaDatas[n]);
            if (n == 0) {
                this.resourceHandler.savePresentationURIFor(hashSet);
            } else {
                this.resourceHandler.savePresentationURIFor(null);
            }
            Migrator.updateStatus(iProgressMonitor, PersistenceResources.loadLibraryTask_name);
            ((MultiFileResourceSetImpl)migratorResourceSet).loadLibrary(string);
            MethodLibrary methodLibrary = migratorResourceSet.getMethodLibrary();
            if (methodLibrary == null) {
                return;
            }
            Migrator.updateStatus(iProgressMonitor, PersistenceResources.loadResourcesTask_name);
            TreeIterator treeIterator = methodLibrary.eAllContents();
            while (treeIterator.hasNext()) {
                Object object;
                URI uRI;
                EObject eObject = (EObject)treeIterator.next();
                if (eObject instanceof Guideline && n > 0 && (uRI = this.resourceHandler.getPresentationURI((object = (Guideline)eObject).getGuid())) != null) {
                    ContentDescription contentDescription = (ContentDescription)((MultiFileResourceSetImpl)migratorResourceSet).getEObject(uRI, true);
                    object.setPresentation(contentDescription);
                }
                if (!(eObject instanceof MethodElement)) continue;
                try {
                    object = eObject.eCrossReferences().iterator();
                    while (object.hasNext()) {
                        object.next();
                    }
                }
                catch (Exception exception) {
                    CommonPlugin.INSTANCE.log((Object)exception);
                    System.err.println("Error iterate thru cross references of element: " + eObject);
                }
            }
            if (n == 0) {
                Migrator.migrateProcessContentDescriptions(iProgressMonitor, methodLibrary);
                Migrator.updateStatus(iProgressMonitor, PersistenceResources.moveDataTask_name);
            }
            if (n < 2) {
                this.resourceHandler.moveData();
                this.resourceHandler.clearMoveInfos();
            }
            if (n == this.extendedMetaDatas.length - 1) {
                Migrator.migrateProcesses(iProgressMonitor, methodLibrary);
                this.restoreReferences(migratorResourceSet);
            }
            Migrator.updateStatus(iProgressMonitor, PersistenceResources.saveLibraryTask_name);
            migratorResourceSet.save(null, true);
            migratorResourceSet.reset();
            ++n;
        }
        try {
            File file = new File(new File(string).getParentFile(), "resmgr.xmi");
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void restoreReferences(MultiFileResourceSetImpl multiFileResourceSetImpl) {
        for (AnyTypeFeatureValue anyTypeFeatureValue : this.anyTypeFeatureValues) {
            if (anyTypeFeatureValue.ownerId == null || anyTypeFeatureValue.valueId == null) continue;
            EObject eObject = multiFileResourceSetImpl.getEObject(anyTypeFeatureValue.ownerId);
            EObject eObject2 = multiFileResourceSetImpl.getEObject(anyTypeFeatureValue.valueId);
            UMA2UMAResourceHandler.setValue(eObject, anyTypeFeatureValue.feature, eObject2);
        }
        this.anyTypeFeatureValues.clear();
    }

    private static void migrateProcesses(IProgressMonitor iProgressMonitor, MethodLibrary methodLibrary) {
        Migrator.updateStatus(iProgressMonitor, PersistenceResources.fixPresentationNameTask_name);
        String[][] stringArray = MultiFileResourceSetImpl.PROCESS_PACKAGE_PATHS;
        for (MethodPlugin methodPlugin : methodLibrary.getMethodPlugins()) {
            ArrayList<MethodPackage> arrayList = new ArrayList<MethodPackage>();
            int n = 0;
            while (n < stringArray.length) {
                MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])stringArray[n]);
                if (methodPackage != null) {
                    arrayList.add(methodPackage);
                }
                ++n;
            }
            for (MethodPackage methodPackage : arrayList) {
                for (EObject eObject : methodPackage.getChildPackages()) {
                    if (!(eObject instanceof ProcessComponent)) continue;
                    Process process = ((ProcessComponent)eObject).getProcess();
                    if (process != null) {
                        Migrator.fixPresentationName((BreakdownElement)process);
                        continue;
                    }
                    String string = String.valueOf(Migrator.class.getName()) + ": invalid ProcessComponent (with no Process): " + eObject + "\n  ProcessComponent's resource URI: " + (eObject.eResource() != null ? eObject.eResource().getURI() : null) + "\n  Parent package: " + methodPackage + "\n  Parent package's resource URI: " + (methodPackage.eResource() != null ? methodPackage.eResource().getURI() : null);
                    CommonPlugin.INSTANCE.log((Object)string);
                    System.err.println(string);
                }
            }
        }
    }

    private static void migrateProcessContentDescriptions(IProgressMonitor iProgressMonitor, MethodLibrary methodLibrary) {
        Migrator.updateStatus(iProgressMonitor, PersistenceResources.migrateContentDescriptionsTask_name);
        String[][] stringArray = MultiFileResourceSetImpl.PROCESS_PACKAGE_PATHS;
        for (MethodPlugin methodPlugin : methodLibrary.getMethodPlugins()) {
            ArrayList<MethodPackage> arrayList = new ArrayList<MethodPackage>();
            int n = 0;
            while (n < stringArray.length) {
                MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])stringArray[n]);
                if (methodPackage != null) {
                    arrayList.add(methodPackage);
                }
                ++n;
            }
            for (MethodPackage methodPackage : arrayList) {
                for (Object e : methodPackage.getChildPackages()) {
                    if (!(e instanceof ProcessComponent)) continue;
                    Process process = ((ProcessComponent)e).getProcess();
                    Migrator.migrateContentDescription((BreakdownElement)process);
                }
            }
        }
    }

    private static void migrateContentDescription(BreakdownElement breakdownElement) {
        Object object;
        if (ContentDescriptionFactory.hasPresentation((MethodElement)breakdownElement)) {
            object = breakdownElement.getPresentation();
            EClass eClass = ContentDescriptionFactory.getContentDescriptionEClass((DescribableElement)breakdownElement);
            if (eClass != object) {
                ContentDescription contentDescription = ContentDescriptionFactory.createContentDescription((DescribableElement)breakdownElement);
                contentDescription.setMainDescription(object.getMainDescription());
                contentDescription.setKeyConsiderations(object.getKeyConsiderations());
                contentDescription.getSections().addAll(object.getSections());
                breakdownElement.setPresentation(contentDescription);
            }
        }
        if (breakdownElement instanceof Activity) {
            object = ((Activity)breakdownElement).getBreakdownElements().iterator();
            while (object.hasNext()) {
                Migrator.migrateContentDescription((BreakdownElement)object.next());
            }
        }
    }

    private static void fixPresentationName(BreakdownElement breakdownElement) {
        if (breakdownElement.getPresentationName() == null || breakdownElement.getPresentationName().trim().length() == 0) {
            breakdownElement.setPresentationName(breakdownElement.getName());
        }
        if (breakdownElement instanceof Activity) {
            Iterator iterator = ((Activity)breakdownElement).getBreakdownElements().iterator();
            while (iterator.hasNext()) {
                Migrator.fixPresentationName((BreakdownElement)iterator.next());
            }
        }
    }

    private static class AnyTypeFeatureValue {
        String ownerId;
        EObject owner;
        EStructuralFeature feature;
        String valueId;
        AnyType value;
        int index;

        private AnyTypeFeatureValue() {
        }
    }

    class MigratorResourceSet
    extends MultiFileResourceSetImpl {
        MigratorResourceSet() {
        }

        public URIConverter getURIConverter() {
            if (this.uriConverter == null) {
                this.uriConverter = new MigratorURIConverter(this);
            }
            return this.uriConverter;
        }

        private void loadOldResourceManager(String string) throws IOException {
            String string2 = String.valueOf(new File(string).getParent()) + File.separator;
            File file = new File(string2, "resmgr.xmi");
            ResourceManager resourceManager = null;
            MultiFileURIConverter multiFileURIConverter = (MultiFileURIConverter)this.getURIConverter();
            if (file.exists()) {
                XMIResourceImpl xMIResourceImpl = new XMIResourceImpl(URI.createFileURI((String)file.getAbsolutePath()));
                xMIResourceImpl.load(null);
                if (!xMIResourceImpl.getContents().isEmpty()) {
                    Object object = xMIResourceImpl.getContents().get(0);
                    if (object instanceof ResourceManager) {
                        resourceManager = (ResourceManager)object;
                    } else {
                        System.err.println("Invalid ResourceManager file: " + file);
                    }
                }
            }
            ((MigratorURIConverter)multiFileURIConverter).setOldResourceManager(resourceManager);
        }

        public MethodLibrary loadLibrary(String string) throws Exception {
            this.loadOldResourceManager(string);
            return this.loadLibraryWithoutReset(string);
        }

        protected EObject findEObjectInUnloadedResources(String string) {
            EObject eObject = null;
            if (this.getResourceManager() != null) {
                eObject = super.findEObjectInUnloadedResources(string);
            }
            if (eObject == null) {
                URI uRI = ((MigratorURIConverter)this.getURIConverter()).getURIFromOldResourceManager(string);
                Resource resource = super.getResource(uRI, true);
                return resource.getEObject(string);
            }
            return null;
        }

        public EObject getEObject(URI uRI, boolean bl) {
            EObject eObject = super.getEObject(uRI, bl);
            if (eObject == null && "uma".equalsIgnoreCase(uRI.scheme()) && !uRI.hasFragment()) {
                eObject = super.getEObject(uRI.authority());
            }
            if (eObject == null || eObject.eIsProxy()) {
                throw new RuntimeException("Could not load object with URI '" + uRI + "' (normalized URI: '" + this.getURIConverter().normalize(uRI) + "').\nPlease see log file for more details.");
            }
            return eObject;
        }

        public EObject superGetEObject(URI uRI, boolean bl) {
            URI uRI2;
            block7: {
                try {
                    uRI2 = this.getURIConverter().normalize(uRI);
                    if (uRI2 != null) break block7;
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }
            Resource resource = null;
            resource = this.getResource(uRI2.trimFragment(), bl);
            if (resource != null) {
                String string = uRI2.fragment();
                if (string == null || string.length() == 0) {
                    return PersistenceUtil.getMethodElement(resource);
                }
                return resource.getEObject(string);
            }
            return null;
        }

        public Resource createResource(URI uRI) {
            MultiFileXMIResourceImpl multiFileXMIResourceImpl = new MultiFileXMIResourceImpl(uRI){

                protected XMLHelper createXMLHelper() {
                    return new MultiFileXMIHelperImpl(this){

                        public void setValue(EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n) {
                            boolean bl = this.logError;
                            try {
                                try {
                                    this.logError = false;
                                    super.setValue(eObject, eStructuralFeature, object, n);
                                }
                                catch (RuntimeException runtimeException) {
                                    if (!(object instanceof AnyType) || !(eObject instanceof MethodElement)) {
                                        throw runtimeException;
                                    }
                                    AnyTypeFeatureValue anyTypeFeatureValue = new AnyTypeFeatureValue();
                                    anyTypeFeatureValue.ownerId = ((MethodElement)eObject).getGuid();
                                    anyTypeFeatureValue.feature = eStructuralFeature;
                                    anyTypeFeatureValue.valueId = (String)UMA2UMAResourceHandler.getSingleValue(((AnyType)object).getAnyAttribute(), "guid");
                                    anyTypeFeatureValue.index = n;
                                    ((MigratorResourceSet)(this).MigratorResourceSet.this).Migrator.this.anyTypeFeatureValues.add(anyTypeFeatureValue);
                                    this.logError = bl;
                                }
                            }
                            finally {
                                this.logError = bl;
                            }
                        }

                        public List setManyReference(XMLHelper.ManyReference manyReference, String string) {
                            List list = super.setManyReference(manyReference, string);
                            if (list == null) {
                                return null;
                            }
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                IllegalValueException illegalValueException;
                                Object e = iterator.next();
                                if (!(e instanceof IllegalValueException) || !((illegalValueException = (IllegalValueException)e).getValue() instanceof AnyType) || !(illegalValueException.getObject() instanceof MethodElement)) continue;
                                AnyTypeFeatureValue anyTypeFeatureValue = new AnyTypeFeatureValue();
                                anyTypeFeatureValue.ownerId = ((MethodElement)illegalValueException.getObject()).getGuid();
                                anyTypeFeatureValue.feature = illegalValueException.getFeature();
                                anyTypeFeatureValue.valueId = (String)UMA2UMAResourceHandler.getSingleValue(((AnyType)illegalValueException.getValue()).getAnyAttribute(), "guid");
                                anyTypeFeatureValue.index = -1;
                                ((MigratorResourceSet)(this).MigratorResourceSet.this).Migrator.this.anyTypeFeatureValues.add(anyTypeFeatureValue);
                                iterator.remove();
                            }
                            if (list.isEmpty()) {
                                return null;
                            }
                            return list;
                        }
                    };
                }
            };
            multiFileXMIResourceImpl.setTrackingModification(true);
            this.getResources().add((Object)multiFileXMIResourceImpl);
            return multiFileXMIResourceImpl;
        }
    }

    class MigratorURIConverter
    extends MultiFileURIConverter {
        private ResourceManager oldResMgr;

        public MigratorURIConverter(MultiFileResourceSetImpl multiFileResourceSetImpl) {
            super(multiFileResourceSetImpl);
        }

        public URI normalize(URI uRI) {
            String string;
            URI uRI2 = super.normalize(uRI);
            if (uRI2 == null && "uma".equalsIgnoreCase(uRI.scheme()) && this.oldResMgr != null && (uRI2 = this.getURIFromOldResourceManager(string = uRI.authority())) != null) {
                uRI2 = uRI.hasFragment() ? uRI2.appendFragment(uRI.fragment()) : uRI2.appendFragment(string);
            }
            return uRI2;
        }

        public URI getURIFromOldResourceManager(String string) {
            if (this.oldResMgr == null) {
                return null;
            }
            ResourceDescriptor resourceDescriptor = this.oldResMgr.getResourceDescriptor(string);
            if (resourceDescriptor != null) {
                URI uRI = resourceDescriptor.getResolvedURI();
                URI uRI2 = (URI)Migrator.this.oldPathToNewURIMap.get(uRI.toFileString());
                if (uRI2 != null) {
                    uRI = uRI2;
                }
                return uRI;
            }
            return null;
        }

        public void dispose() {
            if (this.oldResMgr != null) {
                this.oldResMgr.dispose();
                this.oldResMgr = null;
            }
            super.dispose();
        }

        public void setOldResourceManager(ResourceManager resourceManager) {
            this.oldResMgr = resourceManager;
        }

        public ResourceManager getOldResourceManager() {
            return this.oldResMgr;
        }

        public void setURIMapping(EObject eObject, URI uRI, Set set) {
            ResourceDescriptor resourceDescriptor;
            MigratorURIConverter migratorURIConverter;
            ResourceManager resourceManager;
            if (eObject instanceof MethodElement && (resourceManager = (migratorURIConverter = (MigratorURIConverter)((MultiFileResourceSetImpl)eObject.eResource().getResourceSet()).getURIConverter()).getOldResourceManager()) != null && (resourceDescriptor = resourceManager.getResourceDescriptor(((MethodElement)eObject).getGuid())) != null) {
                Migrator.this.oldPathToNewURIMap.put(resourceDescriptor.getResolvedURI().toFileString(), uRI);
            }
            super.setURIMapping(eObject, uRI, set);
        }
    }
}

