/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma.edit.domain;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.epf.uma.MethodElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceableAdapterFactoryEditingDomain
extends AdapterFactoryEditingDomain {
    private HashMap copyToOriginalMap = null;
    private Map originalToClipboardMap = null;
    private Map<EObject, EObject> clipboardToOriginalMap;

    public TraceableAdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack) {
        super(adapterFactory, commandStack);
    }

    public TraceableAdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack, Map map) {
        super(adapterFactory, commandStack, map);
    }

    public TraceableAdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack, ResourceSet resourceSet) {
        super(adapterFactory, commandStack, resourceSet);
    }

    public Map getCopyToOriginalMap() {
        if (this.copyToOriginalMap == null) {
            this.copyToOriginalMap = new HashMap();
        }
        return this.copyToOriginalMap;
    }

    public Map getOriginalToClipboardMap() {
        if (this.originalToClipboardMap == null) {
            this.originalToClipboardMap = new HashMap();
        }
        return this.originalToClipboardMap;
    }

    public void addCopyInfo(Collection collection, CopyCommand.Helper helper) {
        if (this.isNewCopy(collection, helper)) {
            this.addNewCopy(collection, helper);
            return;
        }
        this.chainCopy(collection, helper);
    }

    private void addNewCopy(Collection collection, CopyCommand.Helper helper) {
        if (this.originalToClipboardMap == null) {
            this.originalToClipboardMap = new HashMap();
        }
        if (this.clipboardToOriginalMap == null) {
            this.clipboardToOriginalMap = new HashMap<EObject, EObject>();
        }
        for (EObject eObject : helper.keySet()) {
            EObject eObject2 = (EObject)helper.get((Object)eObject);
            this.originalToClipboardMap.put(eObject, eObject2);
            this.clipboardToOriginalMap.put(eObject2, eObject);
        }
    }

    private void chainCopy(Collection collection, CopyCommand.Helper helper) {
        if (this.originalToClipboardMap != null) {
            if (this.copyToOriginalMap == null) {
                this.copyToOriginalMap = new HashMap();
            }
            for (Object k : this.originalToClipboardMap.keySet()) {
                Object v = this.originalToClipboardMap.get(k);
                Object object = helper.get(v);
                if (object == null || !(k instanceof MethodElement)) continue;
                this.copyToOriginalMap.put(object, k);
            }
        }
    }

    private boolean isNewCopy(Collection collection, CopyCommand.Helper helper) {
        if (this.originalToClipboardMap == null) {
            return true;
        }
        for (Object e : helper.keySet()) {
            if (this.originalToClipboardMap.containsValue(e)) continue;
            return true;
        }
        return false;
    }

    public void resetCopyMaps() {
        if (this.originalToClipboardMap != null) {
            this.originalToClipboardMap.clear();
            this.originalToClipboardMap = null;
        }
        if (this.clipboardToOriginalMap != null) {
            this.clipboardToOriginalMap.clear();
            this.clipboardToOriginalMap = null;
        }
        if (this.copyToOriginalMap != null) {
            this.copyToOriginalMap.clear();
            this.copyToOriginalMap = null;
        }
    }

    public Map<EObject, EObject> getClipboardToOriginalMap() {
        return this.clipboardToOriginalMap;
    }
}

