/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.library.layout.LayoutResources;
import org.osgi.framework.BundleContext;

public class LibraryPlugin
extends AbstractPlugin {
    private static final String LAYOUT_PATH = "layout/";
    public static final String LAYOUT_XSL_PATH = "layout/xsl/";
    private static final String LAYOUT_CSS_PATH = "layout/css/";
    public static final String LAYOUT_SCRIPTS_FOLDER = "scripts";
    public static final String LAYOUT_SCRIPTS_PATH = "layout/scripts/";
    private static LibraryPlugin plugin;
    private String layoutPath;
    private String layoutXslPath;
    private String layoutCssPath;

    public LibraryPlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        try {
            URL uRL = new URL(super.getInstallURL(), LAYOUT_PATH);
            this.layoutPath = FileLocator.resolve((URL)uRL).getPath();
            uRL = new URL(super.getInstallURL(), LAYOUT_XSL_PATH);
            this.layoutXslPath = FileLocator.resolve((URL)uRL).getPath();
            uRL = new URL(super.getInstallURL(), LAYOUT_CSS_PATH);
            this.layoutCssPath = FileLocator.resolve((URL)uRL).getPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        plugin = null;
        LayoutResources.clear();
    }

    public static LibraryPlugin getDefault() {
        return plugin;
    }

    public String getLayoutPath() {
        return this.layoutPath;
    }

    public String getLayoutXslPath() {
        return this.layoutXslPath;
    }

    public String getLayoutCssPath() {
        return this.layoutCssPath;
    }
}

