/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.jface.viewers.Viewer;

public class ProcessConfigurator
extends ConfigurationFilter {
    private boolean checkOwningProcess;

    public ProcessConfigurator(MethodConfiguration methodConfiguration, Viewer viewer) {
        super(methodConfiguration, viewer);
    }

    public ProcessConfigurator(MethodConfiguration methodConfiguration, Viewer viewer, boolean bl) {
        this(methodConfiguration, viewer);
        this.checkOwningProcess = bl;
    }

    public void setMethodConfiguration(MethodConfiguration methodConfiguration) {
        this.methodConfig = methodConfiguration;
    }

    public boolean accept(Object object) {
        if (this.methodConfig == null) {
            return true;
        }
        if (object instanceof BreakdownElement) {
            DefaultElementRealizer defaultElementRealizer = new DefaultElementRealizer(this.methodConfig);
            return this.accept((BreakdownElement)object, defaultElementRealizer);
        }
        return super.accept(object);
    }

    protected boolean accept(BreakdownElement breakdownElement, final ElementRealizer elementRealizer) {
        if (breakdownElement instanceof Milestone || breakdownElement instanceof TeamProfile) {
            return true;
        }
        if (breakdownElement instanceof Activity) {
            return ProcessUtil.accept((Activity)((Activity)breakdownElement), (IFilter)new IFilter(){

                public boolean accept(Object object) {
                    return object instanceof MethodElement ? elementRealizer.inConfig((MethodElement)object) : true;
                }
            }, (boolean)this.checkOwningProcess);
        }
        if (breakdownElement instanceof Descriptor) {
            MethodElement methodElement = ProcessUtil.getAssociatedElement((Descriptor)((Descriptor)breakdownElement));
            if (methodElement == null || methodElement.eIsProxy()) {
                return true;
            }
            methodElement = ConfigurationHelper.getCalculatedElement(methodElement, elementRealizer);
            return elementRealizer.inConfig(methodElement);
        }
        return super.accept(breakdownElement);
    }
}

