/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.io.File;
import java.io.PrintStream;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.layout.BrowsingLayoutSettings;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.osgi.util.NLS;

public class DefaultContentValidator
implements IContentValidator {
    protected PrintStream info;
    protected PrintStream warning;
    protected PrintStream error;
    protected String pubDir;

    public DefaultContentValidator() {
        this(null);
    }

    public DefaultContentValidator(String string) {
        this.pubDir = string;
        this.info = System.out;
        this.warning = System.out;
        this.error = System.err;
    }

    public void setPublishDir(String string) {
        this.pubDir = string;
    }

    public String getPublishDir() {
        return this.pubDir;
    }

    public boolean showBrokenLinks() {
        return true;
    }

    public LinkInfo validateLink(MethodElement methodElement, String string, String string2, MethodConfiguration methodConfiguration, String string3) {
        LinkInfo linkInfo = new LinkInfo(methodElement, this, this.pubDir, string3);
        linkInfo.validateLink(string, string2, methodConfiguration);
        return linkInfo;
    }

    public void logInfo(MethodElement methodElement, String string) {
        this.info.println(NLS.bind((String)LibraryResources.DefaultContentValidator_MSG1, (Object)(String.valueOf(methodElement == null ? "" : LibraryUtil.getTypeName(methodElement)) + ": " + string)));
        this.info.flush();
    }

    public void logWarning(MethodElement methodElement, String string) {
        this.warning.println(NLS.bind((String)LibraryResources.DefaultContentValidator_MSG4, (Object)(String.valueOf(methodElement == null ? "" : LibraryUtil.getTypeName(methodElement)) + ": " + string)));
        this.warning.flush();
    }

    public void logError(MethodElement methodElement, String string, Throwable throwable) {
        this.error.println(NLS.bind((String)LibraryResources.DefaultContentValidator_MSG7, (Object)(String.valueOf(methodElement == null ? "" : LibraryUtil.getTypeName(methodElement)) + ": " + string)));
        if (throwable != null) {
            throwable.printStackTrace(this.error);
        }
        this.error.flush();
    }

    public void logInfo(String string) {
        this.logInfo(null, string);
    }

    public void logWarning(String string) {
        this.logWarning(null, string);
    }

    public void logError(String string, Throwable throwable) {
        this.logError(null, string, throwable);
    }

    public void logMissingReference(MethodElement methodElement, MethodElement methodElement2) {
        this.logWarning(methodElement, NLS.bind((String)LibraryResources.DefaultContentValidator_MSG10, (Object)LibraryUtil.getTypeName(methodElement2)));
    }

    public void logMissingReference(MethodElement methodElement, String string, String string2) {
        this.logWarning(methodElement, NLS.bind((String)LibraryResources.DefaultContentValidator_MSG11, (Object)string));
    }

    public void logMissingResource(MethodElement methodElement, File file, String string) {
        String string2 = file != null ? NLS.bind((String)LibraryResources.DefaultContentValidator_MSG12, (Object)file.getPath(), (Object)string) : NLS.bind((String)LibraryResources.DefaultContentValidator_MSG15, (Object)string);
        this.logWarning(methodElement, string2);
    }

    public void logInvalidExternalLink(MethodElement methodElement, String string, String string2) {
        String string3 = string2 != null && string2.length() > 0 ? NLS.bind((String)LibraryResources.DefaultContentValidator_MSG19, (Object)string, (Object)string2) : NLS.bind((String)LibraryResources.DefaultContentValidator_MSG17, (Object)string);
        this.logWarning(methodElement, string3);
    }

    public boolean isDiscarded(MethodElement methodElement, Object object, MethodElement methodElement2) {
        return false;
    }

    public void dispose() {
    }

    public void addReferencedElement(MethodElement methodElement, MethodElement methodElement2) {
    }

    public void setDiscardedElement(MethodElement methodElement) {
    }

    public boolean showExtraInfoForDescriptors() {
        return BrowsingLayoutSettings.INSTANCE.isShowExtraInfoForDescriptors();
    }

    public boolean showRelatedDescriptors() {
        return true;
    }

    public String getDefaultActivityTab() {
        return null;
    }
}

