/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.preferences;

import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class LibraryPreferences {
    public static final String SAVED_METHOD_LIRARY_URI = "savedMethodLibraryURI";
    public static final String SAVED_METHOD_LIRARY_TYPE = "savedMethodLibraryType";
    public static final String DISCARD_UNRESOLVED_REFERENCES = "discardUnresolvedReferences";
    public static final String USE_NEW_EXTENDS_SEMANTICS = "useNewExtendsSemantics";
    public static final String ROLE_DIAGRAM_HORIZONTAL_SPACING = "roleDiagramHorizontalSpacing";
    public static final String ROLE_DIAGRAM_VERTICAL_SPACING = "roleDiagramVerticalSpacing";
    public static final String ROLE_DIAGRAM_MAX_TEXT_LINES = "roleDiagramElementLabelTextLines";
    private static final boolean DEFAULT_DISCARD_UNRESOLVED_REFERENCES = false;
    private static final boolean DEFAULT_USE_NEW_EXTENDS_SEMANTICS = false;
    private static final int DEFAULT_ROLE_DIAGRAM_HORIZONTAL_SPACING = 70;
    private static final int DEFAULT_ROLE_DIAGRAM_VERTICAL_SPACING = 30;
    private static final int DEFAULT_ROLE_DIAGRAM_MAX_TEXT_LINES = 3;
    private static IPreferenceStore prefStore = LibraryPlugin.getDefault().getPreferenceStore();

    static {
        prefStore.setDefault(DISCARD_UNRESOLVED_REFERENCES, false);
        prefStore.setDefault(USE_NEW_EXTENDS_SEMANTICS, false);
        prefStore.setDefault(ROLE_DIAGRAM_HORIZONTAL_SPACING, 70);
        prefStore.setDefault(ROLE_DIAGRAM_VERTICAL_SPACING, 30);
        prefStore.setDefault(ROLE_DIAGRAM_MAX_TEXT_LINES, 3);
    }

    public static String getSavedMethodLibraryURI() {
        return prefStore.getString(SAVED_METHOD_LIRARY_URI);
    }

    public static void setSavedMethodLibraryURI(String string) {
        prefStore.setValue(SAVED_METHOD_LIRARY_URI, string);
    }

    public static String getSavedMethodLibraryType() {
        return prefStore.getString(SAVED_METHOD_LIRARY_TYPE);
    }

    public static void setSavedMethodLibraryType(String string) {
        prefStore.setValue(SAVED_METHOD_LIRARY_TYPE, string);
    }

    public static boolean getDefaultDiscardUnresolvedReferences() {
        return false;
    }

    public static boolean getDiscardUnresolvedReferences() {
        return prefStore.getBoolean(DISCARD_UNRESOLVED_REFERENCES);
    }

    public static void setDiscardUnresolvedReferences(boolean bl) {
        prefStore.setValue(DISCARD_UNRESOLVED_REFERENCES, bl);
    }

    public static boolean getDefaultUseNewExtendsSemantics() {
        return false;
    }

    public static boolean getUseNewExtendsSemantics() {
        return prefStore.getBoolean(USE_NEW_EXTENDS_SEMANTICS);
    }

    public static void setUseNewExtendsSemantics(boolean bl) {
        prefStore.setValue(USE_NEW_EXTENDS_SEMANTICS, bl);
    }

    public static int getDefaultRoleDiagramHorizontalSpacing() {
        return 70;
    }

    public static int getRoleDiagramHorizontalSpacing() {
        int n = prefStore.getInt(ROLE_DIAGRAM_HORIZONTAL_SPACING);
        return n > 0 ? n : 70;
    }

    public static void setRoleDiagramHorizontalSpacing(int n) {
        prefStore.setValue(ROLE_DIAGRAM_HORIZONTAL_SPACING, n);
    }

    public static int getDefaultRoleDiagramVerticalSpacing() {
        return 30;
    }

    public static int getRoleDiagramVerticalSpacing() {
        int n = prefStore.getInt(ROLE_DIAGRAM_VERTICAL_SPACING);
        return n > 0 ? n : 30;
    }

    public static void setRoleDiagramVerticalSpacing(int n) {
        prefStore.setValue(ROLE_DIAGRAM_VERTICAL_SPACING, n);
    }

    public static int getDefaultRoleDiagramMaximumTextLines() {
        return 3;
    }

    public static int getRoleDiagramMaximumTextLines() {
        int n = prefStore.getInt(ROLE_DIAGRAM_MAX_TEXT_LINES);
        return n > 0 ? n : 3;
    }

    public static void setRoleDiagramMaximumTextLines(int n) {
        prefStore.setValue(ROLE_DIAGRAM_MAX_TEXT_LINES, n);
    }
}

