/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.project;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.project.MethodLibraryProjectNature;
import org.eclipse.epf.uma.MethodLibrary;

public class MethodLibraryProject {
    public static IProject createProject(String string, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        File file;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject iProject = MethodLibraryProject.findProject(string);
        if (iProject != null) {
            iProject.delete(9, iProgressMonitor);
        }
        if (string2 == null) {
            file = new File(string);
            string2 = file.getName();
        }
        if ((iProject = iWorkspace.getRoot().getProject(string2)).exists()) {
            iProject.delete(9, iProgressMonitor);
        }
        file = iWorkspace.newProjectDescription(string2);
        file.setNatureIds(MethodLibraryProjectNature.NATURE_IDS);
        Path path = new Path(string);
        if (!Platform.getLocation().isPrefixOf((IPath)path)) {
            file.setLocation((IPath)path);
        }
        iProject.create((IProjectDescription)file, iProgressMonitor);
        return iProject;
    }

    public static IProject createProject(String string, IProgressMonitor iProgressMonitor) throws CoreException {
        return MethodLibraryProject.createProject(string, null, iProgressMonitor);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMethodLibraryProject(IProject iProject) {
        boolean bl;
        block13: {
            String[] stringArray;
            IProjectDescription iProjectDescription;
            if (iProject == null) return false;
            bl = false;
            if (!iProject.isOpen()) {
                iProject.open(128, (IProgressMonitor)new NullProgressMonitor());
                bl = true;
            }
            if ((iProjectDescription = iProject.getDescription()) == null || !Arrays.asList(stringArray = iProjectDescription.getNatureIds()).contains(MethodLibraryProjectNature.NATURE_ID)) break block13;
            if (!bl) return true;
            try {
                iProject.close((IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            catch (CoreException coreException) {}
            return true;
            catch (CoreException coreException) {
                try {
                    if (!bl) return false;
                }
                catch (Throwable throwable) {
                    if (!bl) throw throwable;
                    try {
                        iProject.close((IProgressMonitor)new NullProgressMonitor());
                        throw throwable;
                    }
                    catch (CoreException coreException2) {}
                    throw throwable;
                }
                try {
                    iProject.close((IProgressMonitor)new NullProgressMonitor());
                    return false;
                }
                catch (CoreException coreException3) {}
                return false;
            }
        }
        if (!bl) return false;
        try {
            iProject.close((IProgressMonitor)new NullProgressMonitor());
            return false;
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static IProject findProject(String string) {
        if (string == null) {
            return null;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
        try {
            int n = 0;
            while (n < iProjectArray.length) {
                IProject iProject = iProjectArray[n];
                if (new File(string).compareTo(iProject.getLocation().toFile()) == 0 && MethodLibraryProject.isMethodLibraryProject(iProject)) {
                    return iProject;
                }
                if (new File(string).compareTo(iProject.getLocation().toFile()) == 0) {
                    return iProject;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
        return null;
    }

    public static IProject findProject(MethodLibrary methodLibrary) {
        return MethodLibraryProject.findProject(MethodLibraryProject.getLibraryPath(methodLibrary));
    }

    public static IProject openProject(String string, IProgressMonitor iProgressMonitor) throws CoreException {
        return MethodLibraryProject.openProject(string, null, iProgressMonitor);
    }

    public static IProject openProject(String string, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        String[] stringArray;
        IProjectDescription iProjectDescription;
        Path path = new Path(String.valueOf(string) + File.separator + ".project");
        try {
            iProjectDescription = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
        }
        catch (CoreException coreException) {
            iProjectDescription = null;
        }
        IProject iProject = null;
        if (iProjectDescription == null) {
            iProject = MethodLibraryProject.createProject(string, string2, iProgressMonitor);
        } else {
            if (string2 != null) {
                iProjectDescription.setName(string2);
            }
            if (!(iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iProjectDescription.getName())).exists()) {
                iProject = MethodLibraryProject.createProject(string, iProject.getName(), iProgressMonitor);
            } else if (new File(string).compareTo(iProject.getLocation().toFile()) != 0) {
                iProject = MethodLibraryProject.createProject(string, iProgressMonitor);
            }
        }
        if (!iProject.isOpen()) {
            iProject.open(128, iProgressMonitor);
        }
        if (iProjectDescription == null) {
            iProjectDescription = iProject.getDescription();
        }
        if (!Arrays.asList(stringArray = iProjectDescription.getNatureIds()).contains(MethodLibraryProjectNature.NATURE_ID)) {
            iProjectDescription.setNatureIds(MethodLibraryProjectNature.NATURE_IDS);
            iProject.setDescription(iProjectDescription, 3, iProgressMonitor);
        }
        return iProject;
    }

    public static void closeProject(String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = MethodLibraryProject.findProject(string);
        if (iProject != null && !iProject.getWorkspace().isTreeLocked() && iProject.isOpen()) {
            iProject.close(iProgressMonitor);
        }
    }

    public static void closeProject(MethodLibrary methodLibrary, IProgressMonitor iProgressMonitor) throws CoreException {
        MethodLibraryProject.closeProject(MethodLibraryProject.getLibraryPath(methodLibrary), iProgressMonitor);
    }

    public static boolean deleteProject(String string, IProgressMonitor iProgressMonitor) {
        IProject iProject = MethodLibraryProject.findProject(string);
        if (iProject != null) {
            try {
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                iProject.delete(9, iProgressMonitor);
            }
            catch (CoreException coreException) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)coreException);
                return false;
            }
        }
        return true;
    }

    public static boolean deleteProject(MethodLibrary methodLibrary, IProgressMonitor iProgressMonitor) {
        return MethodLibraryProject.deleteProject(MethodLibraryProject.getLibraryPath(methodLibrary), iProgressMonitor);
    }

    private static String getLibraryPath(MethodLibrary methodLibrary) {
        return new File(methodLibrary.eResource().getURI().toFileString()).getParent();
    }
}

