/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.services;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.command.ActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.osgi.util.NLS;

public class LibraryModificationHelper {
    ActionManager actionMgr = null;

    public ActionManager getActionManager() {
        if (this.actionMgr != null) {
            return this.actionMgr;
        }
        this.actionMgr = new ActionManager(){

            public boolean doAction(int n, EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n2) {
                if (LibraryModificationHelper.canUpdate(eObject)) {
                    return super.doAction(n, eObject, eStructuralFeature, object, n2);
                }
                return false;
            }

            protected void save(Resource resource) {
            }
        };
        return this.actionMgr;
    }

    public void dispose() {
        if (this.actionMgr != null) {
            this.actionMgr.dispose();
            this.actionMgr = null;
        }
    }

    public static boolean canUpdate(EObject eObject) {
        IStatus iStatus = TngUtil.checkEdit((EObject)eObject, null);
        if (iStatus.isOK()) {
            return true;
        }
        String string = NLS.bind((String)LibraryResources.LibraryModificationHelper_cannotUpdate, (Object)TngUtil.getTypeText((EObject)eObject), (Object)eObject.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name()));
        LibraryPlugin.getDefault().getMsgDialog().displayWarning(LibraryResources.warningDlg_title, string, TngUtil.getMessage((IStatus)iStatus));
        return false;
    }

    public boolean isSaveNeeded() {
        return this.actionMgr != null && this.actionMgr.isSaveNeeded();
    }

    public void save() {
        if (this.actionMgr == null) {
            return;
        }
        try {
            Collection collection = this.actionMgr.getModifiedResources();
            ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = this.getPersister(collection);
            for (Resource resource : collection) {
                try {
                    failSafeMethodLibraryPersister.save(resource);
                }
                catch (Exception exception) {
                    String string = NLS.bind((String)LibraryResources.errorDlg_saveError, (Object)(resource.getURI().isFile() ? resource.getURI().toFileString() : resource.getURI().toString()));
                    LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.errorDlg_title, string, (Throwable)exception);
                }
            }
            try {
                failSafeMethodLibraryPersister.commit();
                this.actionMgr.saveIsDone();
            }
            catch (Exception exception) {
                try {
                    failSafeMethodLibraryPersister.rollback();
                }
                catch (Throwable throwable) {
                    try {
                        LibraryService.getInstance().reopenCurrentMethodLibrary();
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                    }
                }
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ILibraryPersister.FailSafeMethodLibraryPersister getPersister(Collection collection) {
        for (Resource resource : collection) {
            ILibraryPersister iLibraryPersister;
            ResourceSet resourceSet = resource.getResourceSet();
            if (!(resourceSet instanceof ILibraryResourceSet) || (iLibraryPersister = ((ILibraryResourceSet)resourceSet).getPersister()) == null) continue;
            return iLibraryPersister.getFailSafePersister();
        }
        return null;
    }
}

