/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.AssociationHelper;

public class PluginReferenceChecker {
    public static boolean hasCircularConflictWithPlugin(MethodPlugin methodPlugin) {
        for (Object e : methodPlugin.getBases()) {
            if (DependencyChecker.checkCircularDependency((EObject)methodPlugin, (EStructuralFeature)UmaPackage.Literals.METHOD_PLUGIN__BASES, e).isOK()) continue;
            return true;
        }
        return false;
    }

    public static List getApplicableBasePlugins(MethodPlugin methodPlugin) {
        List list = ModelStorage.getBaseModels();
        List list2 = PluginReferenceChecker.getDescendants(methodPlugin);
        for (MethodPlugin methodPlugin2 : list2) {
            if (methodPlugin.getBases().contains(methodPlugin2)) continue;
            list.remove(methodPlugin2);
        }
        return list;
    }

    private static List getDescendants(MethodPlugin methodPlugin) {
        ArrayList arrayList = new ArrayList();
        ArrayList<MethodPlugin> arrayList2 = new ArrayList<MethodPlugin>();
        arrayList2.add(methodPlugin);
        PluginReferenceChecker.getDescendants(arrayList, arrayList2);
        return arrayList;
    }

    private static List getDescendants(List list, List list2) {
        if (list2.isEmpty()) {
            return list;
        }
        ArrayList arrayList = new ArrayList();
        for (Object object : list2) {
            List list3 = AssociationHelper.getPluginDirectExtensions((MethodPlugin)object);
            arrayList.addAll(list3);
        }
        list.addAll(list2);
        ArrayList arrayList2 = new ArrayList();
        for (List list3 : arrayList) {
            if (list.contains(list3)) continue;
            arrayList2.add(list3);
        }
        return PluginReferenceChecker.getDescendants(list, arrayList2);
    }

    public static void printPluginList(String string, List list) {
        System.out.print("$$$ " + string + ": [");
        for (MethodPlugin methodPlugin : list) {
            System.out.print(String.valueOf(methodPlugin.getName()) + ", ");
        }
        System.out.println("]");
    }
}

