/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingContentProvider;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.jface.viewers.IStructuredSelection;

class ProjectAndSourceFolderContentProvider
extends JavaBrowsingContentProvider {
    ProjectAndSourceFolderContentProvider(JavaBrowsingPart browsingPart) {
        super(false, browsingPart);
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            this.startReadInDisplayThread();
            if (element instanceof IStructuredSelection) {
                Assert.isLegal((boolean)false);
                Object[] result = new Object[]{};
                Class<?> clazz = null;
                Iterator iter = ((IStructuredSelection)element).iterator();
                while (iter.hasNext()) {
                    Object item = iter.next();
                    if (clazz == null) {
                        clazz = item.getClass();
                    }
                    if (clazz == item.getClass()) {
                        result = ProjectAndSourceFolderContentProvider.concatenate(result, this.getChildren(item));
                        continue;
                    }
                    Object[] objectArray = NO_CHILDREN;
                    return objectArray;
                }
                Object[] objectArray = result;
                return objectArray;
            }
            if (element instanceof IStructuredSelection) {
                Assert.isLegal((boolean)false);
                Object[] result = new Object[]{};
                Iterator iter = ((IStructuredSelection)element).iterator();
                while (iter.hasNext()) {
                    result = ProjectAndSourceFolderContentProvider.concatenate(result, this.getChildren(iter.next()));
                }
                Object[] objectArray = result;
                return objectArray;
            }
            if (element instanceof IJavaProject) {
                Object[] objectArray = this.getPackageFragmentRoots((IJavaProject)element);
                return objectArray;
            }
            if (element instanceof IPackageFragmentRoot) {
                Object[] objectArray = NO_CHILDREN;
                return objectArray;
            }
            Object[] objectArray = super.getChildren(element);
            return objectArray;
        }
        catch (JavaModelException javaModelException) {
            Object[] objectArray = NO_CHILDREN;
            return objectArray;
        }
        finally {
            this.finishedReadInDisplayThread();
        }
    }

    protected Object[] getPackageFragmentRoots(IJavaProject project) throws JavaModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> list = new ArrayList<IPackageFragmentRoot>(roots.length);
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (!this.isProjectPackageFragmentRoot(root)) {
                list.add(root);
            }
            ++i;
        }
        return list.toArray();
    }

    public boolean hasChildren(Object element) {
        return element instanceof IJavaProject && super.hasChildren(element);
    }
}

