/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class AbstractCleanUp
implements ICleanUp {
    private Map fOptions;
    private final boolean fCanReinitialize;

    public AbstractCleanUp() {
        this(null);
    }

    public AbstractCleanUp(Map options) {
        this.fOptions = options;
        this.fCanReinitialize = options == null;
    }

    protected int getNumberOfProblems(IProblem[] problems, int problemId) {
        int result = 0;
        int i = 0;
        while (i < problems.length) {
            if (problems[i].getID() == problemId) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public RefactoringStatus checkPreConditions(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.done();
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkPostConditions(IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.done();
        }
        return new RefactoringStatus();
    }

    public void initialize(Map settings) throws CoreException {
        if (this.fCanReinitialize) {
            this.fOptions = settings;
        }
    }

    protected boolean isEnabled(String key) {
        Assert.isNotNull((Object)key);
        Object value = this.fOptions.get(key);
        return "true" == value || "true".equals(value);
    }

    public boolean needsFreshAST(CompilationUnit compilationUnit) {
        return false;
    }

    public IFix createFix(ICompilationUnit unit) throws CoreException {
        return null;
    }
}

