/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;

public class ImageUtil {
    private static HashMap<String, BufferedImage> imageCache = new HashMap();

    private ImageUtil() {
    }

    public static BufferedImage getBufferedImage(String string, Component component) {
        if (string == null || component == null) {
            return null;
        }
        BufferedImage bufferedImage = imageCache.get(string);
        if (bufferedImage != null) {
            return bufferedImage;
        }
        Image image = component.getToolkit().getImage(string);
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        bufferedImage = new BufferedImage(image.getWidth(component), image.getHeight(component), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, component);
        imageCache.put(string, bufferedImage);
        return bufferedImage;
    }

    public static boolean waitForImage(Image image, Component component) {
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        return !mediaTracker.isErrorAny();
    }

    public static void drawText(Graphics2D graphics2D, String string, Font font, Color color, int n, int n2) {
        if (string == null || string.length() == 0) {
            return;
        }
        graphics2D.setColor(color);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        textLayout.draw(graphics2D, n, n2);
    }

    public static void drawText(Graphics2D graphics2D, String string, Font font, Color color, int n, int n2, float f, int n3) {
        if (string == null || string.length() == 0) {
            return;
        }
        float f2 = f - 10.0f;
        graphics2D.setColor(color);
        Point2D.Float float_ = new Point2D.Float(n, n2);
        HashMap<TextAttribute, Font> hashMap = new HashMap<TextAttribute, Font>();
        hashMap.put(TextAttribute.FONT, font);
        AttributedCharacterIterator attributedCharacterIterator = new AttributedString(string, hashMap).getIterator();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
        int n4 = 1;
        while (n4 <= n3) {
            TextLayout textLayout = lineBreakMeasurer.nextLayout(f2);
            if (textLayout == null) break;
            float_.y += textLayout.getAscent();
            float f3 = 0.0f;
            if (textLayout.isLeftToRight()) {
                f3 = f - textLayout.getAdvance();
            }
            textLayout.draw(graphics2D, float_.x + f3 / 2.0f, float_.y);
            float_.y += textLayout.getDescent() + textLayout.getLeading() - 1.0f;
            ++n4;
        }
    }
}

