/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.services.ConfigurationImportService;
import org.eclipse.epf.importing.wizards.ImportUIPreferences;
import org.eclipse.epf.importing.wizards.SelectConfigSpecsToImportPage;
import org.eclipse.epf.importing.wizards.SelectConfigsToImport;
import org.eclipse.epf.importing.wizards.SelectImportConfigurationSource;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryService;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.Services;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportConfigurationWizard
extends Wizard
implements IImportWizard {
    public boolean okToComplete = false;
    protected SelectImportConfigurationSource page1;
    protected SelectConfigsToImport configPage;
    protected SelectConfigSpecsToImportPage specsPage;
    protected ConfigurationImportData data = new ConfigurationImportData();
    protected ConfigurationImportService service = new ConfigurationImportService(this.data);

    public ImportConfigurationWizard() {
        this.setWindowTitle(ImportResources.importConfigWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        ILibraryManager iLibraryManager;
        IFileManager iFileManager = Services.getFileManager();
        if (LibraryService.getInstance().getCurrentMethodLibrary() != null) {
            iFileManager.checkModify(LibraryService.getInstance().getCurrentMethodLibrary().eResource().getURI().toFileString(), (Object)MsgBox.getDefaultShell());
        }
        if ((iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager()) != null && iLibraryManager.isMethodLibraryReadOnly()) {
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.importConfigWizard_title, ImportResources.ImportConfigurationWizard_readonly);
            return;
        }
        SaveAllEditorsPage.addPageIfNeeded((Wizard)this, (boolean)true, null, null, (ImageDescriptor)ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportLibraryConfiguration.gif"));
        this.page1 = new SelectImportConfigurationSource(this.data, this.service);
        this.addPage((IWizardPage)this.page1);
        this.configPage = new SelectConfigsToImport(this.service);
        this.addPage((IWizardPage)this.configPage);
        this.specsPage = new SelectConfigSpecsToImportPage(this.data);
        this.addPage((IWizardPage)this.specsPage);
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        composite.getShell().setImage(LibraryUIImages.IMG_METHOD_CONFIGURATON);
    }

    public boolean canFinish() {
        return this.okToComplete;
    }

    public boolean performFinish() {
        LibraryBackupUtil.promptBackupCurrentLibrary(null, (ILibraryService)LibraryService.getInstance());
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    try {
                        iProgressMonitor.beginTask(ImportResources.ImportConfigurationWizard_MSG1, -1);
                        ImportConfigurationWizard.this.service.performImport(iProgressMonitor);
                    }
                    catch (Exception exception) {
                        throw new InvocationTargetException(exception);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.ImportConfigurationWizard_error, throwable.getMessage());
            return false;
        }
        ImportUIPreferences.addImportConfigDir(this.data.llData.getParentFolder());
        return true;
    }
}

