/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.xmi;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epf.library.ui.wizards.OpenLibraryWizardPage;
import org.eclipse.epf.library.ui.xmi.XMILibraryUIResources;
import org.eclipse.epf.library.xmi.preferences.XMILibraryPreferences;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OpenXMILibraryWizardPage
extends OpenLibraryWizardPage {
    private Combo locationCombo;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            OpenXMILibraryWizardPage.this.setPageComplete(OpenXMILibraryWizardPage.this.isPageComplete());
            OpenXMILibraryWizardPage.this.getWizard().getContainer().updateButtons();
        }
    };

    public OpenXMILibraryWizardPage(String string) {
        super(string);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        OpenXMILibraryWizardPage.createLabel((Composite)composite2, (String)XMILibraryUIResources.locationLabel_text);
        this.locationCombo = OpenXMILibraryWizardPage.createCombobox((Composite)composite2);
        this.locationCombo.addModifyListener(this.modifyListener);
        this.locationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OpenXMILibraryWizardPage.this.setPageComplete(OpenXMILibraryWizardPage.this.isPageComplete());
                OpenXMILibraryWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        final Shell shell = composite.getShell();
        Button button = OpenXMILibraryWizardPage.createButton((Composite)composite2, (String)XMILibraryUIResources.browseButton_text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    DirectoryDialog directoryDialog = new DirectoryDialog(shell, 0);
                    directoryDialog.setFilterPath(OpenXMILibraryWizardPage.this.getLibraryPath());
                    String string = directoryDialog.open();
                    if (string != null) {
                        OpenXMILibraryWizardPage.this.locationCombo.add(string, 0);
                        OpenXMILibraryWizardPage.this.locationCombo.setText(string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.setPageComplete(true);
        this.setControl((Control)composite2);
    }

    public void onEnterPage(Object object) {
        if (this.getLibraryPath().length() == 0) {
            this.locationCombo.removeModifyListener(this.modifyListener);
            this.locationCombo.setText(XMILibraryPreferences.getDefaultLibraryPath());
            this.locationCombo.addModifyListener(this.modifyListener);
        }
    }

    public boolean isPageComplete() {
        return this.getLibraryPath().length() > 0;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public String getLibraryPath() {
        return this.locationCombo.getText().trim();
    }

    public Map getSelections() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        File file = new File(this.getLibraryPath());
        hashMap.put("library.path", file.getAbsolutePath());
        return hashMap;
    }
}

