/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.commands;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.epf.authoring.gef.commands.DiagramModifyCommand;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;

public class CreateNodeCommand
extends DiagramModifyCommand {
    private Point loc;
    private Node node;
    private Diagram diagram;
    private static final String LABEL = AuthoringUIResources.gef_createNodeCommand_label;

    public CreateNodeCommand(Node node, Diagram diagram, Point point) {
        super(LABEL);
        this.node = node;
        this.diagram = diagram;
        this.loc = point.getCopy();
        this.setDiagram(diagram);
    }

    public void undo() {
        this.node.setLocation(null);
        this.node.setDiagram(null);
        this.diagram.getNodes().remove((Object)this.node);
    }

    protected void doExecute() {
        this.node.setLocation(this.loc);
        this.node.setDiagram(this.diagram);
        if (this.node instanceof NamedNode) {
            this.diagram.setDefaultName((NamedNode)this.node);
        }
        this.diagram.getNodes().add((Object)this.node);
    }

    public boolean canExecute() {
        if (this.diagram instanceof Diagram && this.diagram.isReadOnly()) {
            return false;
        }
        return super.canExecute();
    }
}

