/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.epf.authoring.gef.commands.ChangeBoundsCommand;
import org.eclipse.epf.authoring.gef.edit.ActivityDetailDiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.DiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.LinkEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart;
import org.eclipse.epf.authoring.gef.edit.RoleTaskCompositeEditPart;
import org.eclipse.epf.authoring.gef.edit.WorkProductCompositeEditPart;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DiagramUpdateService {
    private DefaultEditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;
    protected static final int HORIZ_PIX_PADDING = 30;
    protected static final int VERT_PIX_PADDING = 20;

    public DiagramUpdateService(GraphicalViewer graphicalViewer, DefaultEditDomain defaultEditDomain, ActionRegistry actionRegistry) {
        this.graphicalViewer = graphicalViewer;
        this.editDomain = defaultEditDomain;
        this.actionRegistry = actionRegistry;
    }

    private GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public void cleanUpDiagram() {
        ActivityDetailDiagramEditPart activityDetailDiagramEditPart;
        List list;
        if (this.getGraphicalViewer().getContents() instanceof ActivityDetailDiagramEditPart && !(list = (activityDetailDiagramEditPart = (ActivityDetailDiagramEditPart)this.getGraphicalViewer().getContents()).getRecentlyAddedParts()).isEmpty()) {
            AbstractGraphicalEditPart abstractGraphicalEditPart;
            Comparator comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    int n = 0;
                    if (object instanceof RoleTaskCompositeEditPart) {
                        if (!(object2 instanceof RoleTaskCompositeEditPart)) {
                            n = -1;
                        }
                    } else if (object2 instanceof RoleTaskCompositeEditPart) {
                        n = 1;
                    }
                    return n;
                }
            };
            Object[] objectArray = list.toArray();
            Arrays.sort(objectArray, comparator);
            int n = 0;
            while (n < objectArray.length) {
                abstractGraphicalEditPart = (AbstractGraphicalEditPart)objectArray[n];
                this.adjustSize(abstractGraphicalEditPart);
                ++n;
            }
            n = 0;
            while (n < objectArray.length) {
                abstractGraphicalEditPart = (AbstractGraphicalEditPart)objectArray[n];
                this.cleanUp(abstractGraphicalEditPart);
                ++n;
            }
            n = 0;
            while (n < objectArray.length) {
                abstractGraphicalEditPart = (AbstractGraphicalEditPart)objectArray[n];
                this.reduceLinkLength(abstractGraphicalEditPart);
                ++n;
            }
            this.packDiagram();
            activityDetailDiagramEditPart.clearRecentlyAddedParts();
            this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection());
        }
    }

    private void cleanUp(AbstractGraphicalEditPart abstractGraphicalEditPart) {
        if (!(abstractGraphicalEditPart instanceof WorkProductCompositeEditPart)) {
            List list;
            int n;
            Object object;
            Object object2;
            List list2 = abstractGraphicalEditPart.getSourceConnections();
            if (list2.size() > 0) {
                int n2 = 0;
                while (n2 < list2.size()) {
                    ChangeBoundsCommand changeBoundsCommand;
                    object2 = (LinkEditPart)((Object)list2.get(n2));
                    object = (AbstractGraphicalEditPart)object2.getTarget();
                    int n3 = object.getFigure().getBounds().width;
                    n = abstractGraphicalEditPart.getFigure().getPreferredSize().width;
                    if (n3 < n) {
                        changeBoundsCommand = new ChangeBoundsCommand((Node)abstractGraphicalEditPart.getModel(), object.getFigure().getBounds().getLocation(), n3);
                        this.getCommandStack().execute((Command)changeBoundsCommand);
                        int n4 = object.getFigure().getPreferredSize().height;
                        object.getFigure().setPreferredSize(new Dimension(n3, n4));
                        object.getFigure().setSize(new Dimension(n3, n4));
                    }
                    this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection(new Object[]{abstractGraphicalEditPart, object}));
                    changeBoundsCommand = this.getActionRegistry().getAction((Object)"align_vertical_to_first_selection");
                    changeBoundsCommand.run();
                    ++n2;
                }
            }
            if ((list = abstractGraphicalEditPart.getTargetConnections()).size() > 0) {
                int n5 = 0;
                while (n5 < list.size()) {
                    object = (LinkEditPart)((Object)list.get(n5));
                    AbstractGraphicalEditPart abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)object.getSource();
                    n = abstractGraphicalEditPart2.getFigure().getBounds().width;
                    int n6 = abstractGraphicalEditPart.getFigure().getPreferredSize().width;
                    if (n < n6) {
                        ChangeBoundsCommand changeBoundsCommand = new ChangeBoundsCommand((Node)abstractGraphicalEditPart.getModel(), abstractGraphicalEditPart2.getFigure().getBounds().getLocation(), n);
                        this.getCommandStack().execute((Command)changeBoundsCommand);
                        int n7 = abstractGraphicalEditPart2.getFigure().getPreferredSize().height;
                        abstractGraphicalEditPart2.getFigure().setPreferredSize(new Dimension(n, n7));
                        abstractGraphicalEditPart2.getFigure().setSize(new Dimension(n, n7));
                    }
                    this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection(new Object[]{abstractGraphicalEditPart, abstractGraphicalEditPart2}));
                    IAction iAction = this.getActionRegistry().getAction((Object)"align_vertical_to_first_selection");
                    iAction.run();
                    ++n5;
                }
            }
            if (abstractGraphicalEditPart instanceof NodeContainerEditPart) {
                object2 = abstractGraphicalEditPart.getChildren();
                int n8 = 0;
                while (n8 < object2.size()) {
                    AbstractGraphicalEditPart abstractGraphicalEditPart3 = (AbstractGraphicalEditPart)object2.get(n8);
                    this.cleanUp(abstractGraphicalEditPart3);
                    ++n8;
                }
            }
        }
    }

    private boolean reduceLinkLength(AbstractGraphicalEditPart abstractGraphicalEditPart) {
        boolean bl = false;
        if (abstractGraphicalEditPart instanceof WorkProductCompositeEditPart) {
            AbstractGraphicalEditPart abstractGraphicalEditPart2 = null;
            int n = 2;
            if (abstractGraphicalEditPart.getTargetConnections().size() > 0) {
                abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)((LinkEditPart)((Object)abstractGraphicalEditPart.getTargetConnections().get(0))).getSource();
                n = 1;
            } else if (abstractGraphicalEditPart.getSourceConnections().size() > 0) {
                abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)((LinkEditPart)((Object)abstractGraphicalEditPart.getSourceConnections().get(0))).getTarget();
                n = 4;
            }
            if (abstractGraphicalEditPart2 != null) {
                if (!(abstractGraphicalEditPart2.getParent() instanceof DiagramEditPart)) {
                    abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)abstractGraphicalEditPart2.getParent();
                }
                Rectangle rectangle = abstractGraphicalEditPart.getFigure().getBounds();
                Rectangle rectangle2 = abstractGraphicalEditPart2.getFigure().getBounds();
                int n2 = -1;
                if ((n & 1) == 1 || (n & 2) == 2) {
                    n2 = 1;
                }
                Rectangle rectangle3 = rectangle.getCopy();
                rectangle3.y = n2 == 1 ? rectangle2.y + rectangle2.height + 20 : rectangle2.y - 20 - rectangle.height;
                Point point = new Point(rectangle3.x, rectangle3.y);
                abstractGraphicalEditPart.getFigure().setLocation(point);
                ChangeBoundsCommand changeBoundsCommand = new ChangeBoundsCommand((Node)abstractGraphicalEditPart.getModel(), point, rectangle.width);
                this.getCommandStack().execute((Command)changeBoundsCommand);
            }
        }
        return bl;
    }

    private void adjustSize(AbstractGraphicalEditPart abstractGraphicalEditPart) {
        if (abstractGraphicalEditPart instanceof WorkProductCompositeEditPart) {
            this.adjustSize((NodeContainerEditPart)abstractGraphicalEditPart, 1);
        } else if (abstractGraphicalEditPart instanceof NodeContainerEditPart) {
            this.adjustSize((NodeContainerEditPart)abstractGraphicalEditPart, 50);
        }
    }

    private void adjustSize(NodeContainerEditPart nodeContainerEditPart, int n) {
        Dimension dimension;
        Object object;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        List list = nodeContainerEditPart.getChildren();
        int n8 = 0;
        while (n8 < list.size()) {
            if (n7 == 0) {
                ++n4;
            }
            if (n7 < n) {
                object = (AbstractGraphicalEditPart)list.get(n8);
                dimension = object.getFigure().getPreferredSize();
                n5 += dimension.width;
                if (dimension.height > n3) {
                    n3 = dimension.height;
                }
                ++n8;
                ++n7;
                continue;
            }
            if (n5 > n2) {
                n2 = n5;
            }
            n6 += n3;
            n3 = 0;
            n5 = 0;
            n7 = 0;
        }
        if (n5 > n2) {
            n2 = n5;
        }
        n8 = (n6 += n3) + 20 * n4;
        object = new ChangeBoundsCommand((Node)nodeContainerEditPart.getModel(), nodeContainerEditPart.getFigure().getBounds().getLocation(), n2 += 30 * Math.min(n, list.size()));
        this.getCommandStack().execute((Command)object);
        nodeContainerEditPart.getFigure().setPreferredSize(new Dimension(n2, n8));
        ((Node)nodeContainerEditPart.getModel()).setHeight(n8);
        nodeContainerEditPart.getFigure().setSize(new Dimension(n2, n8));
        nodeContainerEditPart.getFigure().getLayoutManager().layout(nodeContainerEditPart.getFigure());
        if (nodeContainerEditPart instanceof WorkProductCompositeEditPart && list.size() > 0) {
            dimension = (GraphicalEditPart)list.get(list.size() - 1);
            Point point = dimension.getFigure().getBounds().getBottom();
            Point point2 = nodeContainerEditPart.getFigure().getBounds().getBottom();
            int n9 = point2.y - point.y - 10;
            nodeContainerEditPart.getFigure().setPreferredSize(new Dimension(n2, n8 - n9));
            ((Node)nodeContainerEditPart.getModel()).setHeight(n8 - n9);
            nodeContainerEditPart.getFigure().setSize(new Dimension(n2, n8 - n9));
        }
    }

    protected void enumerateConnectedParts(AbstractGraphicalEditPart abstractGraphicalEditPart, List list) {
        if (!list.contains(abstractGraphicalEditPart)) {
            if (!(abstractGraphicalEditPart.getParent() instanceof DiagramEditPart)) {
                if (!list.contains(abstractGraphicalEditPart.getParent())) {
                    list.add(abstractGraphicalEditPart.getParent());
                }
            } else {
                list.add(abstractGraphicalEditPart);
            }
            AbstractGraphicalEditPart abstractGraphicalEditPart2 = null;
            List list2 = abstractGraphicalEditPart.getChildren();
            int n = 0;
            while (n < list2.size()) {
                AbstractGraphicalEditPart abstractGraphicalEditPart3 = (AbstractGraphicalEditPart)list2.get(n);
                this.enumerateConnectedParts(abstractGraphicalEditPart3, list);
                ++n;
            }
            n = 0;
            while (n < abstractGraphicalEditPart.getTargetConnections().size()) {
                abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)((LinkEditPart)((Object)abstractGraphicalEditPart.getTargetConnections().get(n))).getSource();
                this.enumerateConnectedParts(abstractGraphicalEditPart2, list);
                ++n;
            }
            n = 0;
            while (n < abstractGraphicalEditPart.getSourceConnections().size()) {
                abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)((LinkEditPart)((Object)abstractGraphicalEditPart.getSourceConnections().get(n))).getTarget();
                this.enumerateConnectedParts(abstractGraphicalEditPart2, list);
                ++n;
            }
        }
    }

    private void packDiagram() {
        List list;
        int n;
        ActivityDetailDiagramEditPart activityDetailDiagramEditPart = (ActivityDetailDiagramEditPart)this.getGraphicalViewer().getContents();
        int n2 = 0;
        ArrayList<AbstractGraphicalEditPart> arrayList = new ArrayList<AbstractGraphicalEditPart>();
        ArrayList arrayList2 = new ArrayList();
        List list2 = activityDetailDiagramEditPart.getRecentlyAddedParts();
        int n3 = 0;
        while (n3 < list2.size()) {
            AbstractGraphicalEditPart abstractGraphicalEditPart = (AbstractGraphicalEditPart)list2.get(n3);
            n = 0;
            int n4 = 0;
            while (n4 < arrayList2.size() && n == 0) {
                list = (List)arrayList2.get(n4);
                if (list.contains(abstractGraphicalEditPart)) {
                    n = 1;
                    break;
                }
                ++n4;
            }
            if (n == 0) {
                ArrayList arrayList3 = new ArrayList();
                this.enumerateConnectedParts(abstractGraphicalEditPart, arrayList3);
                if (arrayList3.size() == 1) {
                    arrayList.add(abstractGraphicalEditPart);
                } else {
                    arrayList2.add(arrayList3);
                }
            }
            ++n3;
        }
        while (arrayList2.size() > 0) {
            List list3 = (List)arrayList2.get(0);
            int n5 = this.getVerticalMinPart((List)list3).getFigure().getBounds().y;
            n = 0;
            while (n < arrayList2.size()) {
                List list4 = (List)arrayList2.get(n);
                int n6 = this.getVerticalMinPart((List)list4).getFigure().getBounds().y;
                if (n6 < n5) {
                    list3 = list4;
                    n5 = n6;
                }
                ++n;
            }
            n = n2 + 1;
            int n7 = n - n5;
            int n8 = this.getHorizontalMinPart((List)list3).getFigure().getBounds().x;
            int n9 = 30 - n8;
            int n10 = 0;
            while (n10 < list3.size()) {
                AbstractGraphicalEditPart abstractGraphicalEditPart = (AbstractGraphicalEditPart)list3.get(n10);
                Rectangle rectangle = abstractGraphicalEditPart.getFigure().getBounds();
                ChangeBoundsCommand changeBoundsCommand = new ChangeBoundsCommand((Node)abstractGraphicalEditPart.getModel(), new Point(rectangle.x + n9, rectangle.y + n7), rectangle.width);
                this.getCommandStack().execute((Command)changeBoundsCommand);
                abstractGraphicalEditPart.getFigure().setLocation(new Point(rectangle.x + n9, rectangle.y + n7));
                ++n10;
            }
            n10 = this.getVerticalMaxPart(list3).getFigure().getBounds().bottom();
            n2 = n10 + 40;
            arrayList2.remove(list3);
        }
        int n11 = 30;
        int n12 = 0;
        while (n12 < arrayList.size()) {
            n = n2 + 1;
            AbstractGraphicalEditPart abstractGraphicalEditPart = (AbstractGraphicalEditPart)arrayList.get(n12);
            list = abstractGraphicalEditPart.getFigure().getBounds();
            ChangeBoundsCommand changeBoundsCommand = new ChangeBoundsCommand((Node)abstractGraphicalEditPart.getModel(), new Point(n11, n), ((Rectangle)list).width);
            this.getCommandStack().execute((Command)changeBoundsCommand);
            abstractGraphicalEditPart.getFigure().setLocation(new Point(n11, n));
            n11 += ((Rectangle)list).width + 30;
            ++n12;
        }
    }

    private AbstractGraphicalEditPart getVerticalMinPart(List list) {
        AbstractGraphicalEditPart abstractGraphicalEditPart = list.size() > 0 ? (AbstractGraphicalEditPart)list.get(0) : null;
        int n = 0;
        while (n < list.size()) {
            AbstractGraphicalEditPart abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)list.get(n);
            if (abstractGraphicalEditPart2.getFigure().getBounds().y < abstractGraphicalEditPart.getFigure().getBounds().y) {
                abstractGraphicalEditPart = abstractGraphicalEditPart2;
            }
            ++n;
        }
        return abstractGraphicalEditPart;
    }

    private AbstractGraphicalEditPart getHorizontalMinPart(List list) {
        AbstractGraphicalEditPart abstractGraphicalEditPart = list.size() > 0 ? (AbstractGraphicalEditPart)list.get(0) : null;
        int n = 0;
        while (n < list.size()) {
            AbstractGraphicalEditPart abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)list.get(n);
            if (abstractGraphicalEditPart2.getFigure().getBounds().x < abstractGraphicalEditPart.getFigure().getBounds().x) {
                abstractGraphicalEditPart = abstractGraphicalEditPart2;
            }
            ++n;
        }
        return abstractGraphicalEditPart;
    }

    private AbstractGraphicalEditPart getVerticalMaxPart(List list) {
        AbstractGraphicalEditPart abstractGraphicalEditPart = list.size() > 0 ? (AbstractGraphicalEditPart)list.get(0) : null;
        int n = 0;
        while (n < list.size()) {
            AbstractGraphicalEditPart abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)list.get(n);
            if (abstractGraphicalEditPart2.getFigure().getBounds().bottom() > abstractGraphicalEditPart.getFigure().getBounds().bottom()) {
                abstractGraphicalEditPart = abstractGraphicalEditPart2;
            }
            ++n;
        }
        return abstractGraphicalEditPart;
    }
}

