/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.DescriptorProcessFilter;
import org.eclipse.epf.authoring.ui.properties.OBSRelationSection;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.FilterHelper;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.CompositeRoleWrapperItemProvider;
import org.eclipse.epf.library.edit.process.RoleDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.AddRoleToTeamCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CompositeRole;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TeamProfileRoleSection
extends OBSRelationSection {
    List roleList = null;

    public void createControls(Composite composite, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(composite, tabbedPropertySheetPage);
    }

    protected void initContentProvider() {
        this.contentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<RoleDescriptor> arrayList = new ArrayList<RoleDescriptor>();
                List list = ((TeamProfile)TeamProfileRoleSection.this.element).getTeamRoles();
                for (RoleDescriptor roleDescriptor : list) {
                    if (roleDescriptor.getSuperActivities() != null && roleDescriptor.getSuperActivities() != null) continue;
                    arrayList.add(roleDescriptor);
                }
                return TeamProfileRoleSection.this.getFilteredList(arrayList).toArray();
            }
        };
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
    }

    protected void init() {
        super.init();
        this.element = (TeamProfile)this.element;
        this.setTabData(PropertiesResources.TeamProfile_Role_SectionTitle, PropertiesResources.TeamProfile_Role_SectionDescription, PropertiesResources.TeamProfile_Role_Table1);
        this.showAddFromProcessButton = true;
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof TeamProfile) {
                super.refresh();
                this.element = (TeamProfile)this.getElement();
                this.viewer.refresh();
            }
        }
        catch (Exception exception) {
            this.logger.logError("Error refreshing Team Profile role section ", (Throwable)exception);
        }
    }

    private boolean isPartOfTeam(Role role, TeamProfile teamProfile) {
        List list = teamProfile.getTeamRoles();
        ArrayList<Role> arrayList = new ArrayList<Role>();
        for (RoleDescriptor roleDescriptor : list) {
            arrayList.add(roleDescriptor.getRole());
        }
        return arrayList.contains(role);
    }

    private void add(List list) {
        if (list != null) {
            ArrayList<Role> arrayList = new ArrayList<Role>();
            for (Object e : list) {
                if (!(e instanceof Role) || this.isPartOfTeam((Role)e, (TeamProfile)this.element)) continue;
                arrayList.add((Role)e);
            }
            if (!arrayList.isEmpty()) {
                AddRoleToTeamCommand addRoleToTeamCommand = new AddRoleToTeamCommand((TeamProfile)this.element, arrayList);
                this.actionMgr.execute((IResourceAwareCommand)addRoleToTeamCommand);
            }
        }
    }

    private void addFromProcess(List list) {
        if (list != null) {
            for (Object e : list) {
                Activity activity;
                MessageFormat messageFormat;
                CompositeRole compositeRole;
                if (e instanceof CompositeRole) {
                    compositeRole = ProcessUtil.createCompositeRole((CompositeRole)((CompositeRole)e));
                    this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)compositeRole, -1);
                    this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), e, -1);
                    continue;
                }
                if (!(e instanceof RoleDescriptor)) continue;
                compositeRole = ((RoleDescriptor)e).getRole();
                if (compositeRole != null) {
                    if (!this.isPartOfTeam((Role)compositeRole, (TeamProfile)this.element)) {
                        messageFormat = ProcessUtil.createRoleDescriptor((Role)compositeRole);
                        this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)messageFormat, -1);
                    }
                    this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), e, -1);
                    messageFormat = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
                    activity = (Activity)this.getParentActivity(this.element);
                    ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)messageFormat.adapt((Notifier)activity, ITreeItemContentProvider.class);
                    Collection collection = itemProviderAdapter.getChildren((Object)activity);
                    this.fireNotification(collection, (RoleDescriptor)e);
                    continue;
                }
                messageFormat = new MessageFormat(PropertiesResources.Process_TeamAssignError);
                activity = new Activity[]{((RoleDescriptor)e).getName(), ((TeamProfile)this.element).getName()};
                AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(PropertiesResources.Process_AssignmentInfoTitle, messageFormat.format(activity));
            }
        }
    }

    private void fireNotification(Collection collection, RoleDescriptor roleDescriptor) {
        for (Object e : collection) {
            ItemProviderAdapter itemProviderAdapter;
            Object object;
            if (e instanceof Activity) {
                object = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
                itemProviderAdapter = (ItemProviderAdapter)object.adapt((Notifier)((Activity)e), ITreeItemContentProvider.class);
                collection = itemProviderAdapter.getChildren((Object)((Activity)e));
                this.fireNotification(collection, roleDescriptor);
            }
            if (e instanceof ActivityWrapperItemProvider) {
                object = ((WrapperItemProvider)e).getValue();
                itemProviderAdapter = (ActivityWrapperItemProvider)e;
                this.fireNotification(itemProviderAdapter.getChildren(object), roleDescriptor);
            }
            if (!(e instanceof RoleDescriptorWrapperItemProvider) || !((RoleDescriptor)(object = (RoleDescriptorWrapperItemProvider)e).getValue()).getRole().equals(roleDescriptor.getRole())) continue;
            object.fireNotifyChanged((Notification)new ViewerNotification((Notification)new NotificationImpl(1, object, object), object, false, true));
        }
    }

    protected void remove(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (Object e : arrayList) {
                if (e instanceof RoleDescriptor) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)((RoleDescriptor)e), -1);
                }
                List list = this.findRoleDescriptor(e);
                for (RoleDescriptor roleDescriptor : list) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)roleDescriptor, -1);
                }
            }
        }
    }

    private List findRoleDescriptor(Object object) {
        List list = ((TeamProfile)this.element).getTeamRoles();
        ArrayList arrayList = new ArrayList();
        for (Object e : list) {
            List list2;
            List list3;
            if (object instanceof CompositeRole) {
                if (!(e instanceof CompositeRole) || !(list3 = ((CompositeRole)object).getAggregatedRoles()).equals(list2 = ((CompositeRole)e).getAggregatedRoles())) continue;
                arrayList.add(e);
                continue;
            }
            if (!(object instanceof RoleDescriptor) || !(e instanceof RoleDescriptor) || e instanceof CompositeRole || !((Object)(list3 = ((RoleDescriptor)object).getRole())).equals(list2 = ((RoleDescriptor)e).getRole())) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    protected void openAddDialog() {
        List list = ProcessUtil.getAssociatedElementList((List)((TeamProfile)this.element).getTeamRoles());
        ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getFilter(), this.element, FilterConstants.ROLE_DESCRIPTORS, list);
        itemsFilterDialog.setBlockOnOpen(true);
        itemsFilterDialog.setTitle(FilterConstants.ROLES);
        String[] stringArray = new String[]{FilterConstants.ROLES};
        itemsFilterDialog.setTypes(stringArray);
        itemsFilterDialog.open();
        this.add(itemsFilterDialog.getSelectedItems());
    }

    protected void openAddFromProcessDialog() {
        List list = ((TeamProfile)this.element).getTeamRoles();
        Process process = (Process)this.getProcess(this.element);
        IFilter iFilter = this.getDescriptorFilter();
        if (iFilter != null && process != null) {
            ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iFilter, process, FilterConstants.ROLE_DESCRIPTORS, list);
            itemsFilterDialog.setBlockOnOpen(true);
            itemsFilterDialog.setTitle(FilterConstants.ROLE_DESCRIPTORS);
            itemsFilterDialog.open();
            this.addFromProcess(itemsFilterDialog.getSelectedItems());
        }
    }

    protected Object getProcess(BreakdownElement breakdownElement) {
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
        Object object = itemProviderAdapter.getParent((Object)breakdownElement);
        if (object instanceof Process) {
            return object;
        }
        return this.getProcess((BreakdownElement)object);
    }

    protected IFilter getDescriptorFilter() {
        return new DescriptorProcessFilter(this.getConfiguration()){

            protected boolean childAccept(Object object) {
                List list;
                Object object2;
                Object object3;
                if (object instanceof Activity) {
                    object3 = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
                    object2 = new ArrayList();
                    this.getActivitiesInScope((AdapterFactory)object3, TeamProfileRoleSection.this.element, (List)object2);
                    if (object2.contains(object)) {
                        return true;
                    }
                    if (object.equals(TeamProfileRoleSection.this.getParentActivity(TeamProfileRoleSection.this.element))) {
                        return true;
                    }
                    list = ((Activity)object).getBreakdownElements();
                    if (list.contains(TeamProfileRoleSection.this.getParentActivity(TeamProfileRoleSection.this.element))) {
                        return true;
                    }
                    List list2 = TeamProfileRoleSection.this.getAllowableActivities();
                    if (list2.contains(object)) {
                        return true;
                    }
                }
                if (object instanceof RoleDescriptor) {
                    object3 = TeamProfileRoleSection.this.getParentActivity((BreakdownElement)object);
                    object2 = TeamProfileRoleSection.this.getParentActivity(TeamProfileRoleSection.this.element);
                    if (object2.equals(object3)) {
                        return true;
                    }
                    if (object3 instanceof Activity) {
                        if (TeamProfileRoleSection.this.getBaseActivities((Activity)object2).contains(object3)) {
                            return true;
                        }
                        if (TeamProfileRoleSection.this.getAllowableActivities().contains(object3)) {
                            return true;
                        }
                    }
                }
                if (object instanceof RoleDescriptorWrapperItemProvider || object instanceof CompositeRoleWrapperItemProvider) {
                    object3 = ((BreakdownElementWrapperItemProvider)object).getParent(object);
                    if (TeamProfileRoleSection.this.getParentActivity(TeamProfileRoleSection.this.element).equals(object3)) {
                        return true;
                    }
                    if (object3 instanceof Activity || object3 instanceof ActivityWrapperItemProvider) {
                        if (object3 instanceof ActivityWrapperItemProvider) {
                            object3 = ((ActivityWrapperItemProvider)object3).getValue();
                        }
                        if (TeamProfileRoleSection.this.getAllowableActivities().contains(object3)) {
                            return true;
                        }
                    }
                }
                if (object instanceof ActivityWrapperItemProvider) {
                    object3 = ((BreakdownElementWrapperItemProvider)object).getParent(object);
                    if (TeamProfileRoleSection.this.getParentActivity(TeamProfileRoleSection.this.element).equals(object3)) {
                        return true;
                    }
                    object2 = ((BreakdownElementWrapperItemProvider)object).getValue();
                    if (object2 instanceof Activity && (list = TeamProfileRoleSection.this.getAllowableActivities()).contains(object2)) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    private List getBaseActivities(Activity activity) {
        ArrayList<VariabilityElement> arrayList = new ArrayList<VariabilityElement>();
        while (!activity.getVariabilityType().equals(VariabilityType.NA_LITERAL)) {
            VariabilityElement variabilityElement = activity.getVariabilityBasedOnElement();
            if (variabilityElement == null || !(variabilityElement instanceof Activity)) break;
            arrayList.add(variabilityElement);
            activity = (Activity)variabilityElement;
        }
        return arrayList;
    }

    private Object getParentActivity(BreakdownElement breakdownElement) {
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
        Object object = itemProviderAdapter.getParent((Object)breakdownElement);
        while (!(object instanceof Activity)) {
            breakdownElement = (BreakdownElement)object;
            itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
            object = itemProviderAdapter.getParent((Object)breakdownElement);
        }
        return object;
    }

    private void getChildActivitiesInScope(AdapterFactory adapterFactory, Activity activity, List list) {
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)activity, ITreeItemContentProvider.class);
        Collection collection = itemProviderAdapter.getChildren((Object)activity);
        if (collection instanceof List) {
            List list2 = (List)collection;
            for (Object e : list2) {
                if (e instanceof Activity) {
                    list.add(e);
                    this.getChildActivitiesInScope(adapterFactory, (Activity)e, list);
                }
                if (!(e instanceof ActivityWrapperItemProvider)) continue;
                Object object = ((WrapperItemProvider)e).getValue();
                list.add(object);
                this.getChildActivitiesInScope(adapterFactory, (Activity)object, list);
            }
        }
    }

    private boolean containsType(List list, Class clazz, FilterHelper filterHelper) {
        for (Object e : list) {
            if (e instanceof MethodElement && clazz.isInstance(e) && filterHelper.matcher(e)) {
                return true;
            }
            if (!(e instanceof Activity)) continue;
            return this.containsType(((Activity)e).getBreakdownElements(), clazz, filterHelper);
        }
        return false;
    }

    private List getAllowableActivities() {
        Object object;
        ArrayList arrayList = new ArrayList();
        Object object2 = this.getParentActivity(this.element);
        if (object2 instanceof Activity) {
            object = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
            this.getChildActivitiesInScope((AdapterFactory)object, (Activity)object2, arrayList);
        }
        object = new HashSet();
        for (Object e : arrayList) {
            if (!(e instanceof Activity)) continue;
            ((AbstractCollection)object).addAll(this.getBaseActivities((Activity)e));
        }
        arrayList.addAll(object);
        return arrayList;
    }
}

